#!/bin/bash


# Prefer gawk - we know exactly what it can do.
# awk on Sun does not support functions, need to use nawk for this
if gawk '{print 1}'</dev/null > /dev/null 2>&1; then
   AWK=gawk
elif nawk '{print 1}'</dev/null > /dev/null 2>&1; then
   AWK=nawk
else
   AWK=awk
fi


# compare_homo_lumo.sh and compare_homo_lumo.sh should be in the same directory
BASEDIR=$(dirname "$0") 
compare_vectors="$BASEDIR"/compare_homo_lumo.sh

OCC=$1
UNOCC=$2
TOL=$3
ID=$4

if 
$compare_vectors occupied_spectrum${ID}.txt occupied_spectrum_diag${ID}.txt $TOL  
then
echo Occipied eigenvalues OK
else
echo Occipied eigenvalues ERROR
exit 1
fi

if 
$compare_vectors unoccupied_spectrum${ID}.txt unoccupied_spectrum_diag${ID}.txt $TOL  
then
echo Unoccipied eigenvalues OK
else
echo Unoccipied eigenvalues ERROR
exit 1
fi


if 
$compare_vectors homo_coefficient_vec${ID}.txt homo_coefficient_vec_diag${ID}.txt $TOL  
then
echo HOMO eigenvector OK
else
echo HOMO eigenvector ERROR
exit 1
fi

if 
$compare_vectors lumo_coefficient_vec${ID}.txt lumo_coefficient_vec_diag${ID}.txt $TOL  
then
echo LUMO eigenvector OK
else
echo LUMO eigenvector ERROR
exit 1
fi


i=1
exit_status=0
while [ "$i" -lt $OCC ]
do
     $compare_vectors occ_${i}_coefficient_vec${ID}.txt occ_${i}_coefficient_vec_diag${ID}.txt $TOL 

     exit_status=$?  # exit status from the last command
     if [ "$exit_status" -eq 1 ]; then
         break
     fi

     i=`expr $i + 1 `
done

if [ "$exit_status" -eq 0 ];
then
echo Occupied eigenvectors OK
else
echo Occupied eigenvectors ERROR
exit 1
fi


i=1
exit_status=0
while [ "$i" -lt $UNOCC ]
do
     $compare_vectors unocc_${i}_coefficient_vec${ID}.txt unocc_${i}_coefficient_vec_diag${ID}.txt $TOL 

     exit_status=$?  # exit status from the last command
     if [ "$exit_status" -eq 1 ]; then
         break
     fi

     i=`expr $i + 1 `
done

if [ "$exit_status" -eq 0 ];
then
echo Unoccupied eigenvectors OK
else
echo Unoccupied eigenvectors ERROR
exit 1
fi









