/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// RateLimiterConfig Defines an IO rate limiter with independent bytes/s and ops/s limits. Limits are defined by configuring each of the _bandwidth_ and _ops_ token buckets.
type RateLimiterConfig struct {
	Bandwidth *TokenBucket `json:"bandwidth,omitempty"`
	Ops       *TokenBucket `json:"ops,omitempty"`
}

// NewRateLimiterConfig instantiates a new RateLimiterConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRateLimiterConfig() *RateLimiterConfig {
	this := RateLimiterConfig{}
	return &this
}

// NewRateLimiterConfigWithDefaults instantiates a new RateLimiterConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRateLimiterConfigWithDefaults() *RateLimiterConfig {
	this := RateLimiterConfig{}
	return &this
}

// GetBandwidth returns the Bandwidth field value if set, zero value otherwise.
func (o *RateLimiterConfig) GetBandwidth() TokenBucket {
	if o == nil || o.Bandwidth == nil {
		var ret TokenBucket
		return ret
	}
	return *o.Bandwidth
}

// GetBandwidthOk returns a tuple with the Bandwidth field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RateLimiterConfig) GetBandwidthOk() (*TokenBucket, bool) {
	if o == nil || o.Bandwidth == nil {
		return nil, false
	}
	return o.Bandwidth, true
}

// HasBandwidth returns a boolean if a field has been set.
func (o *RateLimiterConfig) HasBandwidth() bool {
	if o != nil && o.Bandwidth != nil {
		return true
	}

	return false
}

// SetBandwidth gets a reference to the given TokenBucket and assigns it to the Bandwidth field.
func (o *RateLimiterConfig) SetBandwidth(v TokenBucket) {
	o.Bandwidth = &v
}

// GetOps returns the Ops field value if set, zero value otherwise.
func (o *RateLimiterConfig) GetOps() TokenBucket {
	if o == nil || o.Ops == nil {
		var ret TokenBucket
		return ret
	}
	return *o.Ops
}

// GetOpsOk returns a tuple with the Ops field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RateLimiterConfig) GetOpsOk() (*TokenBucket, bool) {
	if o == nil || o.Ops == nil {
		return nil, false
	}
	return o.Ops, true
}

// HasOps returns a boolean if a field has been set.
func (o *RateLimiterConfig) HasOps() bool {
	if o != nil && o.Ops != nil {
		return true
	}

	return false
}

// SetOps gets a reference to the given TokenBucket and assigns it to the Ops field.
func (o *RateLimiterConfig) SetOps(v TokenBucket) {
	o.Ops = &v
}

func (o RateLimiterConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Bandwidth != nil {
		toSerialize["bandwidth"] = o.Bandwidth
	}
	if o.Ops != nil {
		toSerialize["ops"] = o.Ops
	}
	return json.Marshal(toSerialize)
}

type NullableRateLimiterConfig struct {
	value *RateLimiterConfig
	isSet bool
}

func (v NullableRateLimiterConfig) Get() *RateLimiterConfig {
	return v.value
}

func (v *NullableRateLimiterConfig) Set(val *RateLimiterConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableRateLimiterConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableRateLimiterConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRateLimiterConfig(val *RateLimiterConfig) *NullableRateLimiterConfig {
	return &NullableRateLimiterConfig{value: val, isSet: true}
}

func (v NullableRateLimiterConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRateLimiterConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
