/*
   SPDX-FileCopyrightText: 2013-2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "sendlaterutil.h"
#include "sendlaterutil_p.h"
#include "sendlaterinterface.h"

#include <AkonadiCore/ServerManager>

#include <QDBusInterface>
#include <servermanager.h>

using namespace MessageComposer;

QString SendLaterUtil::agentServiceName()
{
    using Akonadi::ServerManager;
    return ServerManager::agentServiceName(ServerManager::Agent, QStringLiteral("akonadi_sendlater_agent"));
}

QString SendLaterUtil::dbusPath()
{
    return QStringLiteral("/SendLaterAgent");
}

bool SendLaterUtil::sentLaterAgentWasRegistered()
{
    return org::freedesktop::Akonadi::SendLaterAgent{agentServiceName(), dbusPath(), QDBusConnection::sessionBus()}.isValid();
}

bool SendLaterUtil::sentLaterAgentEnabled()
{
    org::freedesktop::Akonadi::SendLaterAgent iface{agentServiceName(), dbusPath(), QDBusConnection::sessionBus()};
    return iface.isValid() && iface.enabledAgent();
}
