
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSequentialAnimationGroup.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSequentialAnimationGroup>
#include <QAbstractAnimation>
#include <QAnimationGroup>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPauseAnimation>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSequentialAnimationGroup

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSequentialAnimationGroup::staticMetaObject);
}


// QPauseAnimation *QSequentialAnimationGroup::addPause(int msecs)


static void _init_f_addPause_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QPauseAnimation * > ();
}

static void _call_f_addPause_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QPauseAnimation * > ((QPauseAnimation *)((QSequentialAnimationGroup *)cls)->addPause (arg1));
}


// QAbstractAnimation *QSequentialAnimationGroup::currentAnimation()


static void _init_f_currentAnimation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractAnimation * > ();
}

static void _call_f_currentAnimation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractAnimation * > ((QAbstractAnimation *)((QSequentialAnimationGroup *)cls)->currentAnimation ());
}


// int QSequentialAnimationGroup::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSequentialAnimationGroup *)cls)->duration ());
}


// QPauseAnimation *QSequentialAnimationGroup::insertPause(int index, int msecs)


static void _init_f_insertPause_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("msecs");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QPauseAnimation * > ();
}

static void _call_f_insertPause_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QPauseAnimation * > ((QPauseAnimation *)((QSequentialAnimationGroup *)cls)->insertPause (arg1, arg2));
}


// static QString QSequentialAnimationGroup::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSequentialAnimationGroup::tr (arg1, arg2, arg3));
}


// static QString QSequentialAnimationGroup::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSequentialAnimationGroup::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSequentialAnimationGroup () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addPause", "@brief Method QPauseAnimation *QSequentialAnimationGroup::addPause(int msecs)\n", false, &_init_f_addPause_767, &_call_f_addPause_767);
  methods += new qt_gsi::GenericMethod (":currentAnimation", "@brief Method QAbstractAnimation *QSequentialAnimationGroup::currentAnimation()\n", true, &_init_f_currentAnimation_c0, &_call_f_currentAnimation_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method int QSequentialAnimationGroup::duration()\nThis is a reimplementation of QAbstractAnimation::duration", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("insertPause", "@brief Method QPauseAnimation *QSequentialAnimationGroup::insertPause(int index, int msecs)\n", false, &_init_f_insertPause_1426, &_call_f_insertPause_1426);
  methods += gsi::qt_signal<QAbstractAnimation * > ("currentAnimationChanged(QAbstractAnimation *)", "currentAnimationChanged", gsi::arg("current"), "@brief Signal declaration for QSequentialAnimationGroup::currentAnimationChanged(QAbstractAnimation *current)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("currentLoopChanged(int)", "currentLoopChanged", gsi::arg("currentLoop"), "@brief Signal declaration for QSequentialAnimationGroup::currentLoopChanged(int currentLoop)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSequentialAnimationGroup::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > ("directionChanged(QAbstractAnimation::Direction)", "directionChanged", gsi::arg("arg1"), "@brief Signal declaration for QSequentialAnimationGroup::directionChanged(QAbstractAnimation::Direction)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QSequentialAnimationGroup::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QSequentialAnimationGroup::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > ("stateChanged(QAbstractAnimation::State, QAbstractAnimation::State)", "stateChanged", gsi::arg("newState"), gsi::arg("oldState"), "@brief Signal declaration for QSequentialAnimationGroup::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSequentialAnimationGroup::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSequentialAnimationGroup::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAnimationGroup> &qtdecl_QAnimationGroup ();

qt_gsi::QtNativeClass<QSequentialAnimationGroup> decl_QSequentialAnimationGroup (qtdecl_QAnimationGroup (), "QtCore", "QSequentialAnimationGroup_Native",
  methods_QSequentialAnimationGroup (),
  "@hide\n@alias QSequentialAnimationGroup");

GSI_QTCORE_PUBLIC gsi::Class<QSequentialAnimationGroup> &qtdecl_QSequentialAnimationGroup () { return decl_QSequentialAnimationGroup; }

}


class QSequentialAnimationGroup_Adaptor : public QSequentialAnimationGroup, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSequentialAnimationGroup_Adaptor();

  //  [adaptor ctor] QSequentialAnimationGroup::QSequentialAnimationGroup(QObject *parent)
  QSequentialAnimationGroup_Adaptor() : QSequentialAnimationGroup()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSequentialAnimationGroup::QSequentialAnimationGroup(QObject *parent)
  QSequentialAnimationGroup_Adaptor(QObject *parent) : QSequentialAnimationGroup(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QSequentialAnimationGroup::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSequentialAnimationGroup_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSequentialAnimationGroup::isSignalConnected(signal);
  }

  //  [expose] int QSequentialAnimationGroup::receivers(const char *signal)
  int fp_QSequentialAnimationGroup_receivers_c1731 (const char *signal) const {
    return QSequentialAnimationGroup::receivers(signal);
  }

  //  [expose] QObject *QSequentialAnimationGroup::sender()
  QObject * fp_QSequentialAnimationGroup_sender_c0 () const {
    return QSequentialAnimationGroup::sender();
  }

  //  [expose] int QSequentialAnimationGroup::senderSignalIndex()
  int fp_QSequentialAnimationGroup_senderSignalIndex_c0 () const {
    return QSequentialAnimationGroup::senderSignalIndex();
  }

  //  [emitter impl] void QSequentialAnimationGroup::currentAnimationChanged(QAbstractAnimation *current)
  void emitter_QSequentialAnimationGroup_currentAnimationChanged_2451(QAbstractAnimation *current)
  {
    emit QSequentialAnimationGroup::currentAnimationChanged(current);
  }

  //  [emitter impl] void QSequentialAnimationGroup::currentLoopChanged(int currentLoop)
  void emitter_QSequentialAnimationGroup_currentLoopChanged_767(int currentLoop)
  {
    emit QSequentialAnimationGroup::currentLoopChanged(currentLoop);
  }

  //  [emitter impl] void QSequentialAnimationGroup::destroyed(QObject *)
  void emitter_QSequentialAnimationGroup_destroyed_1302(QObject *arg1)
  {
    emit QSequentialAnimationGroup::destroyed(arg1);
  }

  //  [emitter impl] void QSequentialAnimationGroup::directionChanged(QAbstractAnimation::Direction)
  void emitter_QSequentialAnimationGroup_directionChanged_3310(QAbstractAnimation::Direction arg1)
  {
    emit QSequentialAnimationGroup::directionChanged(arg1);
  }

  //  [adaptor impl] int QSequentialAnimationGroup::duration()
  int cbs_duration_c0_0() const
  {
    return QSequentialAnimationGroup::duration();
  }

  virtual int duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QSequentialAnimationGroup_Adaptor, int>(&QSequentialAnimationGroup_Adaptor::cbs_duration_c0_0);
    } else {
      return QSequentialAnimationGroup::duration();
    }
  }

  //  [adaptor impl] bool QSequentialAnimationGroup::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSequentialAnimationGroup::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSequentialAnimationGroup_Adaptor, bool, QObject *, QEvent *>(&QSequentialAnimationGroup_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSequentialAnimationGroup::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QSequentialAnimationGroup::finished()
  void emitter_QSequentialAnimationGroup_finished_0()
  {
    emit QSequentialAnimationGroup::finished();
  }

  //  [emitter impl] void QSequentialAnimationGroup::objectNameChanged(const QString &objectName)
  void emitter_QSequentialAnimationGroup_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QSequentialAnimationGroup::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QSequentialAnimationGroup::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void emitter_QSequentialAnimationGroup_stateChanged_5680(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    emit QSequentialAnimationGroup::stateChanged(newState, oldState);
  }

  //  [adaptor impl] void QSequentialAnimationGroup::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSequentialAnimationGroup::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSequentialAnimationGroup_Adaptor, QChildEvent *>(&QSequentialAnimationGroup_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSequentialAnimationGroup::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSequentialAnimationGroup::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSequentialAnimationGroup::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSequentialAnimationGroup_Adaptor, QEvent *>(&QSequentialAnimationGroup_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSequentialAnimationGroup::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSequentialAnimationGroup::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSequentialAnimationGroup::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSequentialAnimationGroup_Adaptor, const QMetaMethod &>(&QSequentialAnimationGroup_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSequentialAnimationGroup::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QSequentialAnimationGroup::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QSequentialAnimationGroup::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSequentialAnimationGroup_Adaptor, bool, QEvent *>(&QSequentialAnimationGroup_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QSequentialAnimationGroup::event(_event);
    }
  }

  //  [adaptor impl] void QSequentialAnimationGroup::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSequentialAnimationGroup::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSequentialAnimationGroup_Adaptor, QTimerEvent *>(&QSequentialAnimationGroup_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSequentialAnimationGroup::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QSequentialAnimationGroup::updateCurrentTime(int)
  void cbs_updateCurrentTime_767_0(int arg1)
  {
    QSequentialAnimationGroup::updateCurrentTime(arg1);
  }

  virtual void updateCurrentTime(int arg1)
  {
    if (cb_updateCurrentTime_767_0.can_issue()) {
      cb_updateCurrentTime_767_0.issue<QSequentialAnimationGroup_Adaptor, int>(&QSequentialAnimationGroup_Adaptor::cbs_updateCurrentTime_767_0, arg1);
    } else {
      QSequentialAnimationGroup::updateCurrentTime(arg1);
    }
  }

  //  [adaptor impl] void QSequentialAnimationGroup::updateDirection(QAbstractAnimation::Direction direction)
  void cbs_updateDirection_3310_0(const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & direction)
  {
    QSequentialAnimationGroup::updateDirection(qt_gsi::QtToCppAdaptor<QAbstractAnimation::Direction>(direction).cref());
  }

  virtual void updateDirection(QAbstractAnimation::Direction direction)
  {
    if (cb_updateDirection_3310_0.can_issue()) {
      cb_updateDirection_3310_0.issue<QSequentialAnimationGroup_Adaptor, const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type &>(&QSequentialAnimationGroup_Adaptor::cbs_updateDirection_3310_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::Direction>(direction));
    } else {
      QSequentialAnimationGroup::updateDirection(direction);
    }
  }

  //  [adaptor impl] void QSequentialAnimationGroup::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void cbs_updateState_5680_0(const qt_gsi::Converter<QAbstractAnimation::State>::target_type & newState, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & oldState)
  {
    QSequentialAnimationGroup::updateState(qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(newState).cref(), qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(oldState).cref());
  }

  virtual void updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    if (cb_updateState_5680_0.can_issue()) {
      cb_updateState_5680_0.issue<QSequentialAnimationGroup_Adaptor, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &>(&QSequentialAnimationGroup_Adaptor::cbs_updateState_5680_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(newState), qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(oldState));
    } else {
      QSequentialAnimationGroup::updateState(newState, oldState);
    }
  }

  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateCurrentTime_767_0;
  gsi::Callback cb_updateDirection_3310_0;
  gsi::Callback cb_updateState_5680_0;
};

QSequentialAnimationGroup_Adaptor::~QSequentialAnimationGroup_Adaptor() { }

//  Constructor QSequentialAnimationGroup::QSequentialAnimationGroup(QObject *parent) (adaptor class)

static void _init_ctor_QSequentialAnimationGroup_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSequentialAnimationGroup_Adaptor> ();
}

static void _call_ctor_QSequentialAnimationGroup_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSequentialAnimationGroup_Adaptor *> (new QSequentialAnimationGroup_Adaptor (arg1));
}


// void QSequentialAnimationGroup::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSequentialAnimationGroup_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QSequentialAnimationGroup::currentAnimationChanged(QAbstractAnimation *current)

static void _init_emitter_currentAnimationChanged_2451 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<QAbstractAnimation * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentAnimationChanged_2451 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractAnimation *arg1 = gsi::arg_reader<QAbstractAnimation * >() (args, heap);
  ((QSequentialAnimationGroup_Adaptor *)cls)->emitter_QSequentialAnimationGroup_currentAnimationChanged_2451 (arg1);
}


// emitter void QSequentialAnimationGroup::currentLoopChanged(int currentLoop)

static void _init_emitter_currentLoopChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("currentLoop");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentLoopChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QSequentialAnimationGroup_Adaptor *)cls)->emitter_QSequentialAnimationGroup_currentLoopChanged_767 (arg1);
}


// void QSequentialAnimationGroup::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSequentialAnimationGroup_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QSequentialAnimationGroup::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QSequentialAnimationGroup_Adaptor *)cls)->emitter_QSequentialAnimationGroup_destroyed_1302 (arg1);
}


// emitter void QSequentialAnimationGroup::directionChanged(QAbstractAnimation::Direction)

static void _init_emitter_directionChanged_3310 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_directionChanged_3310 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & >() (args, heap);
  ((QSequentialAnimationGroup_Adaptor *)cls)->emitter_QSequentialAnimationGroup_directionChanged_3310 (arg1);
}


// void QSequentialAnimationGroup::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSequentialAnimationGroup_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// int QSequentialAnimationGroup::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSequentialAnimationGroup_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// bool QSequentialAnimationGroup::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSequentialAnimationGroup_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSequentialAnimationGroup::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSequentialAnimationGroup_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QSequentialAnimationGroup::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSequentialAnimationGroup_Adaptor *)cls)->emitter_QSequentialAnimationGroup_finished_0 ();
}


// exposed bool QSequentialAnimationGroup::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QSequentialAnimationGroup_Adaptor *)cls)->fp_QSequentialAnimationGroup_isSignalConnected_c2394 (arg1));
}


// emitter void QSequentialAnimationGroup::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSequentialAnimationGroup_Adaptor *)cls)->emitter_QSequentialAnimationGroup_objectNameChanged_4567 (arg1);
}


// exposed int QSequentialAnimationGroup::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSequentialAnimationGroup_Adaptor *)cls)->fp_QSequentialAnimationGroup_receivers_c1731 (arg1));
}


// exposed QObject *QSequentialAnimationGroup::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSequentialAnimationGroup_Adaptor *)cls)->fp_QSequentialAnimationGroup_sender_c0 ());
}


// exposed int QSequentialAnimationGroup::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSequentialAnimationGroup_Adaptor *)cls)->fp_QSequentialAnimationGroup_senderSignalIndex_c0 ());
}


// emitter void QSequentialAnimationGroup::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_emitter_stateChanged_5680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_5680 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  ((QSequentialAnimationGroup_Adaptor *)cls)->emitter_QSequentialAnimationGroup_stateChanged_5680 (arg1, arg2);
}


// void QSequentialAnimationGroup::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSequentialAnimationGroup_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QSequentialAnimationGroup::updateCurrentTime(int)

static void _init_cbs_updateCurrentTime_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateCurrentTime_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSequentialAnimationGroup_Adaptor *)cls)->cbs_updateCurrentTime_767_0 (arg1);
}

static void _set_callback_cbs_updateCurrentTime_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_updateCurrentTime_767_0 = cb;
}


// void QSequentialAnimationGroup::updateDirection(QAbstractAnimation::Direction direction)

static void _init_cbs_updateDirection_3310_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateDirection_3310_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSequentialAnimationGroup_Adaptor *)cls)->cbs_updateDirection_3310_0 (arg1);
}

static void _set_callback_cbs_updateDirection_3310_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_updateDirection_3310_0 = cb;
}


// void QSequentialAnimationGroup::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_cbs_updateState_5680_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_updateState_5680_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSequentialAnimationGroup_Adaptor *)cls)->cbs_updateState_5680_0 (arg1, arg2);
}

static void _set_callback_cbs_updateState_5680_0 (void *cls, const gsi::Callback &cb)
{
  ((QSequentialAnimationGroup_Adaptor *)cls)->cb_updateState_5680_0 = cb;
}


namespace gsi
{

gsi::Class<QSequentialAnimationGroup> &qtdecl_QSequentialAnimationGroup ();

static gsi::Methods methods_QSequentialAnimationGroup_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSequentialAnimationGroup::QSequentialAnimationGroup(QObject *parent)\nThis method creates an object of class QSequentialAnimationGroup.", &_init_ctor_QSequentialAnimationGroup_Adaptor_1302, &_call_ctor_QSequentialAnimationGroup_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSequentialAnimationGroup::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_currentAnimationChanged", "@brief Emitter for signal void QSequentialAnimationGroup::currentAnimationChanged(QAbstractAnimation *current)\nCall this method to emit this signal.", false, &_init_emitter_currentAnimationChanged_2451, &_call_emitter_currentAnimationChanged_2451);
  methods += new qt_gsi::GenericMethod ("emit_currentLoopChanged", "@brief Emitter for signal void QSequentialAnimationGroup::currentLoopChanged(int currentLoop)\nCall this method to emit this signal.", false, &_init_emitter_currentLoopChanged_767, &_call_emitter_currentLoopChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSequentialAnimationGroup::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSequentialAnimationGroup::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("emit_directionChanged", "@brief Emitter for signal void QSequentialAnimationGroup::directionChanged(QAbstractAnimation::Direction)\nCall this method to emit this signal.", false, &_init_emitter_directionChanged_3310, &_call_emitter_directionChanged_3310);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSequentialAnimationGroup::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method int QSequentialAnimationGroup::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QSequentialAnimationGroup::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSequentialAnimationGroup::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QSequentialAnimationGroup::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSequentialAnimationGroup::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QSequentialAnimationGroup::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSequentialAnimationGroup::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSequentialAnimationGroup::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSequentialAnimationGroup::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QSequentialAnimationGroup::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_5680, &_call_emitter_stateChanged_5680);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSequentialAnimationGroup::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@brief Virtual method void QSequentialAnimationGroup::updateCurrentTime(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@hide", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0, &_set_callback_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@brief Virtual method void QSequentialAnimationGroup::updateDirection(QAbstractAnimation::Direction direction)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@hide", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0, &_set_callback_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@brief Virtual method void QSequentialAnimationGroup::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@hide", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0, &_set_callback_cbs_updateState_5680_0);
  return methods;
}

gsi::Class<QSequentialAnimationGroup_Adaptor> decl_QSequentialAnimationGroup_Adaptor (qtdecl_QSequentialAnimationGroup (), "QtCore", "QSequentialAnimationGroup",
  methods_QSequentialAnimationGroup_Adaptor (),
  "@qt\n@brief Binding of QSequentialAnimationGroup");

}

