#!/bin/bash

KEY_CHAIN=build.keychain
CERTIFICATE_P12=certificate.p12

# Recreate the certificate from the secure environment variable
echo ${APPLE_CERT_P12} | base64 --decode > $CERTIFICATE_P12

# Create a keychain
security create-keychain -p main $KEY_CHAIN

# Make the keychain the default so identities are found
security default-keychain -s $KEY_CHAIN

# Unlock the keychain
security unlock-keychain -p main $KEY_CHAIN

security import $CERTIFICATE_P12 -k $KEY_CHAIN -P ${APPLE_CERT_P12_PASS} -T /usr/bin/codesign;

security set-key-partition-list -S apple-tool:,apple: -s -k main $KEY_CHAIN

# Remove cert file
rm -fr *.p12