; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=ipsccp -S < %s | FileCheck %s

define float @sitofp_and(i8 %x) {
; CHECK-LABEL: @sitofp_and(
; CHECK-NEXT:    [[PX:%.*]] = and i8 [[X:%.*]], 127
; CHECK-NEXT:    [[R:%.*]] = sitofp i8 [[PX]] to float
; CHECK-NEXT:    ret float [[R]]
;
  %px = and i8 %x, 127
  %r = sitofp i8 %px to float
  ret float %r
}

define half @sitofp_const(i8 %x) {
; CHECK-LABEL: @sitofp_const(
; CHECK-NEXT:    ret half 0xH5140
;
  %r = sitofp i8 42 to half
  ret half %r
}

define double @sitofp_zext(i7 %x) {
; CHECK-LABEL: @sitofp_zext(
; CHECK-NEXT:    [[PX:%.*]] = zext i7 [[X:%.*]] to i8
; CHECK-NEXT:    [[R:%.*]] = sitofp i8 [[PX]] to double
; CHECK-NEXT:    ret double [[R]]
;
  %px = zext i7 %x to i8
  %r = sitofp i8 %px to double
  ret double %r
}

; negative test

define double @sitofp_not_nonneg(i7 %x) {
; CHECK-LABEL: @sitofp_not_nonneg(
; CHECK-NEXT:    [[PX:%.*]] = sext i7 [[X:%.*]] to i8
; CHECK-NEXT:    [[R:%.*]] = sitofp i8 [[PX]] to double
; CHECK-NEXT:    ret double [[R]]
;
  %px = sext i7 %x to i8
  %r = sitofp i8 %px to double
  ret double %r
}

; x is known non-negative in t block

define float @dominating_condition(i32 %x) {
; CHECK-LABEL: @dominating_condition(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    [[A:%.*]] = sitofp i32 [[X]] to float
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       f:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[COND:%.*]] = phi float [ [[A]], [[T]] ], [ 4.200000e+01, [[F]] ]
; CHECK-NEXT:    ret float [[COND]]
;
entry:
  %cmp = icmp sge i32 %x, 0
  br i1 %cmp, label %t, label %f

t:
  %a = sitofp i32 %x to float
  br label %exit

f:
  br label %exit

exit:
  %cond = phi float [ %a, %t ], [ 42.0, %f ]
  ret float %cond
}

; x is known non-negative in f block

define float @dominating_condition_alt(i32 %x) {
; CHECK-LABEL: @dominating_condition_alt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[X:%.*]], 2000000000
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       f:
; CHECK-NEXT:    [[A:%.*]] = sitofp i32 [[X]] to float
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[COND:%.*]] = phi float [ -4.200000e+01, [[T]] ], [ [[A]], [[F]] ]
; CHECK-NEXT:    ret float [[COND]]
;
entry:
  %cmp = icmp ugt i32 %x, 2000000000
  br i1 %cmp, label %t, label %f

t:
  br label %exit

f:
  %a = sitofp i32 %x to float
  br label %exit

exit:
  %cond = phi float [ -42.0, %t ], [ %a, %f ]
  ret float %cond
}
