#ifndef __EUC_H__ /* file wrapper */
#define __EUC_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 ********************************************************************
 *
 * Attempts to define some definitions useful for dealing with
 * Japanese EUC Packed Format text.
 *    Codeset 0: ASCII (or JIS-Roman). Bytes/char: 1
 *    Codeset 1: JIS X 0208            Bytes/char: 2
 *    Codeset 0: Halfwidth katakana.   Bytes/char: 2
 *    Codeset 0: JIS X 0212            Bytes/char: 3
 */

/* Returns the codeset number for a character whose first byte is given. */
#define EUC_CODESET(X) ((euc_info[X]>>_euc_codeset_shift)&_euc_codeset_mask)

/* Returns the length of a character whose first byte is given */
#define EUC_CHAR_LENGTH(X) ((euc_info[X]>>_euc_bpc_shift)&_euc_bpc_mask)


/****************************************************************************/
/* private stuff below */
extern unsigned const char euc_info[256];
#define _euc_bpc_shift			0
#define _euc_bpc_mask			3
#define _euc_codeset_shift		2
#define _euc_codeset_mask		3

#endif /* file wrapper */
