/* Advanced/fixed-up API */

/*** optional: iterator/loop based search API from genrtree_search2.h ***/
/* (new implementation, without stack) */

typedef struct RTR(it2_s) RTR(it2_t);

/* iterator that can be used in an iterative search */
struct RTR(it2_s) {
	RTR(cardinal_t) cnt; /* number of objects found so far */
	RTR(box_t) query;

	const RTR(t) *curr;
	int n;
};

/* Return the first object matching the query or NULL, if there is no match */
void *RTR(first2)(RTR(it2_t) *it, const RTR(t) *root, const RTR(box_t) *query);

/* Return the next object matching the query or NULL, if there is no more */
void *RTR(next2)(RTR(it2_t) *it);

/* Return the first object from the tree or NULL, if the tree is empty */
void *RTR(all_first2)(RTR(it2_t) *it, const RTR(t) *root);

/* Return the next object matching from the tree, if there is no more */
void *RTR(all_next2)(RTR(it2_t) *it);
