/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/PolChemDef.hpp"
#include "MsXpS/libXpertMassCore/Monomer.hpp"

namespace MsXpS
{

namespace libXpertMassCore
{


class DECLSPEC PkaPhPiDataParser
{
  public:
  PkaPhPiDataParser(const PolChemDefCstSPtr &pol_chem_def_csp,
                    const QString &file_path = QString());

  ~PkaPhPiDataParser();

  void setFilePath(const QString &);
  const QString &filePath();

  bool renderXmlFile(std::vector<MonomerSPtr> &monomers,
                     std::vector<ModifSPtr> &modifs);

  protected:
  PolChemDefCstSPtr mcsp_polChemDef;
  QString m_filePath;
};

} // namespace libXpertMassCore

} // namespace MsXpS
