# To help simplify including Elemental in external projects
# TODO: Complain if Qt5 was used

ELEM_INC = @CMAKE_INSTALL_PREFIX@/include
ELEM_LIB = @CMAKE_INSTALL_PREFIX@/lib

CC = @CMAKE_C_COMPILER@
CXX = @CMAKE_CXX_COMPILER@
CXX_FLAGS = @CXX_FLAGS@

MATH_LIBS = @MATH_LIBSTRING@

MPI_CXX_COMPILE_FLAGS = @MPI_CXX_COMPILE_FLAGS@
MPI_CXX_LINK_FLAGS = @MPI_CXX_LINK_FLAGS@
MPI_CXX_INCSTRING = @MPI_CXX_INCSTRING@
MPI_CXX_LIBSTRING = @MPI_CXX_LIBSTRING@

ELEM_LINK_FLAGS = -L${ELEM_LIB} ${MPI_CXX_LINK_FLAGS}

THREAD_INIT = @CMAKE_THREAD_LIBS_INIT@
PMRRR_LIBS = -lpmrrr ${THREAD_INIT}

# Attempt to add Qt5 support if needed
ELEM_HAVE_QT5 = @ELEM_HAVE_QT5@
ifeq (${ELEM_HAVE_QT5},TRUE)
  ELEM_COMPILE_FLAGS = ${CXX_FLAGS} -I${ELEM_INC} ${MPI_CXX_INCSTRING} \
                       @QT5_COMPILESTRING@ @QT5_INCSTRING@ @QT5_DEFSTRING@
  ELEM_LIBS = -lelemental ${PMRRR_LIBS} ${MATH_LIBS} ${MPI_CXX_LIBSTRING} \
              @QT5_LIBSTRING@
else
  ELEM_COMPILE_FLAGS = ${CXX_FLAGS} -I${ELEM_INC} ${MPI_CXX_INCSTRING}
  ELEM_LIBS = -lelemental ${PMRRR_LIBS} ${MATH_LIBS} ${MPI_CXX_LIBSTRING}
endif
