
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileInputDataAttributes.h
    \brief Definition of InputData Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef InputDataAttributes_H
#define InputDataAttributes_H

#include "magics.h"
#include "BinningObject.h"
namespace magics {

class XmlNode;
class InputDataAttributes 
{
public:
//  --  constructor
    InputDataAttributes();
    
//  --  destructor
    virtual ~InputDataAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const InputDataAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string type_;
	string x_type_;
	string y_type_;
	doublearray x_;
	doublearray y_;
	stringarray date_x_;
	stringarray date_y_;
	doublearray x2_;
	doublearray y2_;
	stringarray date_x2_;
	stringarray date_y2_;
	double x_missing_;
	double y_missing_;
	doublearray values_;
	doublearray latitudes_;
	doublearray longitudes_;
	doublearray x_component_;
	doublearray y_component_;
	bool input_automatic_;
	unique_ptr<BinningObject> input_binning_;
	 

private:
	friend ostream& operator<<(ostream& s,const InputDataAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

