/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2019 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * diagonal fold conditional

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfDiagonalFoldIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDiagonalFoldIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (!fractal->transformCommon.functionEnabledAxFalse)
	{
		if (fractal->transformCommon.functionEnabledAx)
		{
			if (z.x > z.y)
			{
				REAL temp = z.y;
				z.y = z.x;
				z.x = temp;
			}
		}
		if (fractal->transformCommon.functionEnabledAyFalse)
		{
			if (z.y > z.z)
			{
				REAL temp = z.z;
				z.z = z.y;
				z.y = temp;
			}
		}
		if (fractal->transformCommon.functionEnabledAzFalse)
		{
			if (z.z > z.x)
			{
				REAL temp = z.x;
				z.x = z.z;
				z.z = temp;
			}
		}
	}
	else
	{
		if (fractal->transformCommon.functionEnabledAx
				&& aux->i >= fractal->transformCommon.startIterationsA
				&& aux->i < fractal->transformCommon.stopIterationsA)
		{
			if (z.x > z.y)
			{
				REAL temp = z.y;
				z.y = z.x;
				z.x = temp;
			}
		}
		if (fractal->transformCommon.functionEnabledAyFalse
				&& aux->i >= fractal->transformCommon.startIterationsB
				&& aux->i < fractal->transformCommon.stopIterationsB)
		{
			if (z.y > z.z)
			{
				REAL temp = z.z;
				z.z = z.y;
				z.y = temp;
			}
		}
		if (fractal->transformCommon.functionEnabledAzFalse
				&& aux->i >= fractal->transformCommon.startIterationsC
				&& aux->i < fractal->transformCommon.stopIterationsC)
		{
			if (z.z > z.x)
			{
				REAL temp = z.x;
				z.x = z.z;
				z.z = temp;
			}
		}
	}

	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = mad(aux->DE, fractal->analyticDE.scale1, fractal->analyticDE.offset0);
	}
	return z;
}