/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifdef METVIEW_QT5
 #include <QtWidgets>
#else
 #include <QtGui>
#endif

#include "VerbFunctionHelpDialog.h"


VerbFunctionHelpDialog::VerbFunctionHelpDialog(QWidget* parent) : QDialog(parent)
{

    setupUi(this); // this sets up GUI

    connect (paramTree,    SIGNAL(currentItemChanged(QTreeWidgetItem*, QTreeWidgetItem*)), this, SLOT(onParameterSelected(QTreeWidgetItem*, QTreeWidgetItem*)));
    connect (insertButton, SIGNAL(clicked()),                                              this, SLOT(onInsertButtonClicked()));


//    helpForFunction(fun);
}



void VerbFunctionHelpDialog::helpForFunction(VerbFunctionHelp *help, QString &functionName)
{
    // find the given function name in the map
    
    VerbFunctionHelpFunction *function = help->function(functionName);

    if (function != NULL)
    {
        // populate the parameter tree with the available parameters

        paramTree->clear();
        valueTree->clear();

        for (int i = 0; i < function->numParams(); i++)
        {
            QTreeWidgetItem *item;

            item = new QTreeWidgetItem(paramTree);        // create a new item for the tree
            item->setText (0, function->paramName(i));    // set its label
            
//            if (i == 0)
//                paramTree->setCurrentItem (item);
        }
        

        currentHelpFunction = function;
        
        functionLabel->setText (tr("Function: ") + functionName);

        show();
        raise();
        activateWindow();
    }
    
    else
    {
        QMessageBox::warning(this, tr("Verb Function Help"),
                             tr("Cannot find function '%1'.")
                             .arg(functionName));
    }
}



// ---------------------------------------------------------------------------
// FunctionListDialog::onParameterSelected
// triggered when the user selects a parameter
// Note: the second parameter is a pointer to the previous item selected - 
// its name has been removed because we don't use it and we want to avoid
// compiler warnings.
// ---------------------------------------------------------------------------

void VerbFunctionHelpDialog::onParameterSelected(QTreeWidgetItem *item,  QTreeWidgetItem*)
{

    //int paramIndex = paramTree->indexOfTopLevelItem(item);

    // populate the 'possible values' box with the values for this parameter
            //qDebug() << " paramIndex: " << paramIndex;

    //if (paramIndex != -1)
    if (item != NULL)
    {
        QString itemName = item->text(0);
        VerbFunctionHelpParam *param = currentHelpFunction->paramFromName(itemName);
        //currentHelpFunction->param(paramIndex);

        valueTree->clear();

        for (int i = 0; i < param->numValues(); i++)
        {
            QTreeWidgetItem *item;

            item = new QTreeWidgetItem(valueTree);     // create a new item for the tree
            item->setText (0, param->valueName(i));    // set its label
        }


        if (param->numValues() == 0)
        {
            QTreeWidgetItem *item;

            item = new QTreeWidgetItem(valueTree);     // create a new item for the tree
            item->setText (0, "No value list for this parameter");    // set its label
            valueTree->setSelectionMode(QAbstractItemView::NoSelection);
        }
        
        else
        {
            valueTree->setSelectionMode(QAbstractItemView::ExtendedSelection);
        }

        //emit insertFunctionName (item->text(0)); // emit a signal with the function name
        //close();
    }
}




// ---------------------------------------------------------------------------
// VerbFunctionHelpDialog::onInsertButtonClicked
// triggered when the user clicks the Insert button
// ---------------------------------------------------------------------------

void VerbFunctionHelpDialog::onInsertButtonClicked()
{
    // which parameter is selected?
    
    QString param;
    QList<QTreeWidgetItem  *> selectedItems = paramTree->selectedItems();

    if (selectedItems.size() > 0)
    {
        QTreeWidgetItem *item = selectedItems[0];
        param = item->text(0);


        // which value is selected?
        
        QString value;
        QList<QTreeWidgetItem  *> selectedItems = valueTree->selectedItems();

        QString values;  // will contain either a single value or a list of values
        int numItems = selectedItems.size();

        if (numItems > 0)
        {
            if (numItems > 1)
                values = "[";
                
            for (int i = 0; i < numItems; i++)
            {
                QTreeWidgetItem *item = selectedItems[i];
                value = item->text(0);
                value = "\"" + value + "\"";

                values += value;  // add to the list

                if ((numItems > 1) && (i < numItems))
                    values += ",";
            }

            if (numItems > 1)
                values += "]";
         }



        // construct the text to be sent to the document (and consider the user options)

        QString textToSend = param + " : " + values;

        if (upperCaseCheckBox->isChecked())
            textToSend = textToSend;
        else
            textToSend = textToSend.toLower();


        // send the text to the document

        emit sendTextToBeInsertedIntoFunctionCall (textToSend); // emit a signal with the text to be inserted

        close();
    }
}







