#pragma once

#include <vector>

#include <QObject>

#include "analyzer/plugins/analyzerplugin.h"
#include "analyzer/plugins/buffering_utils.h"
#include "util/memory.h"
#include "util/samplebuffer.h"

class DetectionFunction;

namespace mixxx {

class AnalyzerQueenMaryBeats : public AnalyzerBeatsPlugin {
  public:
    static AnalyzerPluginInfo pluginInfo() {
        return AnalyzerPluginInfo(
                // Don't change this ID. It was auto generated by VAMP until
                // Mixxx 2.1 and we keep it for a compatible config.
                "qm-tempotracker:0",
                QObject::tr("Queen Mary University London"),
                QObject::tr("Queen Mary Tempo and Beat Tracker"),
                true);
    }

    AnalyzerQueenMaryBeats();
    ~AnalyzerQueenMaryBeats() override;

    AnalyzerPluginInfo info() const override {
        return pluginInfo();
    }

    bool initialize(int samplerate) override;
    bool processSamples(const CSAMPLE* pIn, const int iLen) override;
    bool finalize() override;

    bool supportsBeatTracking() const override {
        return true;
    }

    QVector<double> getBeats() const override {
        return m_resultBeats;
    }

  private:
    std::unique_ptr<DetectionFunction> m_pDetectionFunction;
    DownmixAndOverlapHelper m_helper;
    int m_iSampleRate;
    int m_windowSize;
    int m_stepSize;
    std::vector<double> m_detectionResults;
    QVector<double> m_resultBeats;
};

} // namespace mixxx
