package com.mockobjects;

import java.util.*;

/*
 * TYPE TO PROVIDE BASIC ITERATOR IMPLEMENTATION TO BRIDGE GAP BETWEEN
 * JDK1.1.7 and JDK 1.2
 */

public class Iterator {
    private Vector vector;
    private int count;

    public Iterator(Vector v) {
        vector = v;
        count = 0;
    }

    public boolean hasNext() {
        return count < vector.size();
    }

    public Object next() {
        synchronized (vector) {
            if (count < vector.size()) {
                return vector.elementAt(count++);
            }
        }
        throw new NoSuchElementException("VectorEnumerator");
    }
}
