// HalPlayV3.h: interface for the CHalPlayMixNew class.
//
//////////////////////////////////////////////////////////////////////

#ifndef _HALPLAYMIXV3_H
#define _HALPLAYMIXV3_H

#include "Hal.h"
#include "LynxTWO.h"

enum
{
  MIXVAL_MIXSRCV3_RECORD0L = 0,
  MIXVAL_MIXSRCV3_RECORD0R,
  MIXVAL_MIXSRCV3_RECORD1L,
  MIXVAL_MIXSRCV3_RECORD1R,
  MIXVAL_MIXSRCV3_RECORD2L,
  MIXVAL_MIXSRCV3_RECORD2R,
  MIXVAL_MIXSRCV3_RECORD3L,
  MIXVAL_MIXSRCV3_RECORD3R,
  MIXVAL_MIXSRCV3_RECORD4L,
  MIXVAL_MIXSRCV3_RECORD4R,
  MIXVAL_MIXSRCV3_RECORD5L,
  MIXVAL_MIXSRCV3_RECORD5R,
  MIXVAL_MIXSRCV3_RECORD6L,
  MIXVAL_MIXSRCV3_RECORD6R,
  MIXVAL_MIXSRCV3_RECORD7L,
  MIXVAL_MIXSRCV3_RECORD7R,
  MIXVAL_MIXSRCV3_RECORD8L,
  MIXVAL_MIXSRCV3_RECORD8R,
  MIXVAL_MIXSRCV3_RECORD9L,
  MIXVAL_MIXSRCV3_RECORD9R,
  MIXVAL_MIXSRCV3_RECORD10L,
  MIXVAL_MIXSRCV3_RECORD10R,
  MIXVAL_MIXSRCV3_RECORD11L,
  MIXVAL_MIXSRCV3_RECORD11R,
  MIXVAL_MIXSRCV3_RECORD12L,
  MIXVAL_MIXSRCV3_RECORD12R,
  MIXVAL_MIXSRCV3_RECORD13L,
  MIXVAL_MIXSRCV3_RECORD13R,
  MIXVAL_MIXSRCV3_RECORD14L,
  MIXVAL_MIXSRCV3_RECORD14R,
  MIXVAL_MIXSRCV3_RECORD15L,
  MIXVAL_MIXSRCV3_RECORD15R,
  MIXVAL_MIXSRCV3_PLAY0L,
  MIXVAL_MIXSRCV3_PLAY0R,
  MIXVAL_MIXSRCV3_PLAY1L,
  MIXVAL_MIXSRCV3_PLAY1R,
  MIXVAL_MIXSRCV3_PLAY2L,
  MIXVAL_MIXSRCV3_PLAY2R,
  MIXVAL_MIXSRCV3_PLAY3L,
  MIXVAL_MIXSRCV3_PLAY3R,
  MIXVAL_MIXSRCV3_PLAY4L,
  MIXVAL_MIXSRCV3_PLAY4R,
  MIXVAL_MIXSRCV3_PLAY5L,
  MIXVAL_MIXSRCV3_PLAY5R,
  MIXVAL_MIXSRCV3_PLAY6L,
  MIXVAL_MIXSRCV3_PLAY6R,
  MIXVAL_MIXSRCV3_PLAY7L,
  MIXVAL_MIXSRCV3_PLAY7R,
  MIXVAL_MIXSRCV3_PLAY8L,
  MIXVAL_MIXSRCV3_PLAY8R,
  MIXVAL_MIXSRCV3_PLAY9L,
  MIXVAL_MIXSRCV3_PLAY9R,
  MIXVAL_MIXSRCV3_PLAY10L,
  MIXVAL_MIXSRCV3_PLAY10R,
  MIXVAL_MIXSRCV3_PLAY11L,
  MIXVAL_MIXSRCV3_PLAY11R,
  MIXVAL_MIXSRCV3_PLAY12L,
  MIXVAL_MIXSRCV3_PLAY12R,
  MIXVAL_MIXSRCV3_PLAY13L,
  MIXVAL_MIXSRCV3_PLAY13R,
  MIXVAL_MIXSRCV3_PLAY14L,
  MIXVAL_MIXSRCV3_PLAY14R,
  MIXVAL_MIXSRCV3_PLAY15L,
  MIXVAL_MIXSRCV3_PLAY15R
};

class CHalPlayMixV3
{
public:
  CHalPlayMixV3 ()
  {
  }
   ~CHalPlayMixV3 ()
  {
  }

  USHORT Open (PHALADAPTER pHalAdapter, USHORT usDstLine,
	       PMIXCTLV3 pPlayMixV3, PULONG pPlayMixControl,
	       PULONG pPlayMixStatus);

  // Controls on the Master
  SHORT GetVolume ()
  {
    return (m_sMasterVolume);
  }
  void SetVolume (SHORT sVolume);
  BOOLEAN GetMute ()
  {
    return (m_bMasterMute);
  }
  void SetMute (BOOLEAN bMute);
  BOOLEAN GetDither ()
  {
    return (m_bDither);
  }
  void SetDither (BOOLEAN bDither);

  ULONG GetLevel ();
  ULONG GetOverload ();
  void ResetOverload ();

  // Controls on each source channel
  SHORT GetVolume (USHORT usLine, USHORT usChannel);
  void SetVolume (USHORT usLine, USHORT usChannel, SHORT sVolume);

  BOOLEAN GetMute (USHORT usLine, USHORT usChannel);
  void SetMute (USHORT usLine, USHORT usChannel, BOOLEAN bMute);

  USHORT SetDefaults (BOOLEAN bDriverLoading);
  USHORT SetMixerControl (USHORT usSrcLine, USHORT usControl,
			  USHORT usChannel, ULONG ulValue);
  USHORT GetMixerControl (USHORT usSrcLine, USHORT usControl,
			  USHORT usChannel, PULONG pulValue);

private:
  void UpdateVolume (int nRegister);
  USHORT ConvertLine (USHORT usLine);

  CHalRegister m_RegMixVolume[MBV3_NUM_MIX_VOLUMES];
  CHalRegister m_RegMixControl;
  CHalRegister m_RegMixStatus;

  PHALADAPTER m_pHalAdapter;
  PHALMIXER m_pHalMixer;
  USHORT m_usDstLine;

#define MBV3_NUM_MONITOR_LINES		32
#define MBV3_NUM_CHANNELS_PER_LINE	2

  SHORT m_asMonitorVolume[MBV3_NUM_MONITOR_LINES][MBV3_NUM_CHANNELS_PER_LINE];	// 64 bytes
  BOOLEAN m_abMonitorMute[MBV3_NUM_MONITOR_LINES][MBV3_NUM_CHANNELS_PER_LINE];	// 64 bytes

  SHORT m_sMasterVolume;
  BOOLEAN m_bMasterMute;

  BOOLEAN m_bDither;
  ULONG m_ulOverloadCount;
};

#endif // _HALPLAYMIXV3_H
