/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2020      Evan Nemerson <evan@nemerson.com>
 *   2020      Hidayat Khan <huk2209@gmail.com>
 */

#define SIMDE_TEST_X86_AVX512_INSN mulhrs

#include <test/x86/avx512/test-avx512.h>
#include <simde/x86/avx512/set.h>
#include <simde/x86/avx512/mulhrs.h>

static int
test_simde_mm512_mulhrs_epi16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const int16_t a[32];
    const int16_t b[32];
    const int16_t r[32];
  } test_vec[] = {
    { {  INT16_C(  2012), -INT16_C( 16441), -INT16_C(  5959),  INT16_C( 17687),  INT16_C( 27737), -INT16_C( 25181), -INT16_C(  3282),  INT16_C( 22705),
         INT16_C( 13185),  INT16_C(  4437),  INT16_C( 13761), -INT16_C(  8944),  INT16_C( 19921), -INT16_C( 21079), -INT16_C( 20071),  INT16_C( 30226),
        -INT16_C(  9544),  INT16_C( 29237),  INT16_C( 19650),  INT16_C(  7095),  INT16_C( 23224), -INT16_C(  6471),  INT16_C( 27214), -INT16_C( 12481),
        -INT16_C( 27491),  INT16_C( 24544), -INT16_C(  3895), -INT16_C( 25796), -INT16_C(  6851), -INT16_C( 10424),  INT16_C( 23446),  INT16_C( 20301) },
      { -INT16_C( 32203), -INT16_C(  2111),  INT16_C( 30926), -INT16_C( 31214), -INT16_C( 13358),  INT16_C(  8300), -INT16_C( 21707), -INT16_C( 11281),
        -INT16_C( 12481),  INT16_C(  2354),  INT16_C( 28352), -INT16_C(   604), -INT16_C(  5036), -INT16_C(  5420),  INT16_C(  8519),  INT16_C( 31801),
        -INT16_C(  1373),  INT16_C( 29043), -INT16_C( 31118),  INT16_C( 17911),  INT16_C( 25681), -INT16_C( 30875),  INT16_C( 21775),  INT16_C( 20314),
        -INT16_C( 29660), -INT16_C(  7080), -INT16_C(   774),  INT16_C( 20194), -INT16_C( 18712),  INT16_C( 12345),  INT16_C( 29400),  INT16_C( 31660) },
      { -INT16_C(  1977),  INT16_C(  1059), -INT16_C(  5624), -INT16_C( 16848), -INT16_C( 11307), -INT16_C(  6378),  INT16_C(  2174), -INT16_C(  7817),
        -INT16_C(  5022),  INT16_C(   319),  INT16_C( 11906),  INT16_C(   165), -INT16_C(  3062),  INT16_C(  3487), -INT16_C(  5218),  INT16_C( 29334),
         INT16_C(   400),  INT16_C( 25913), -INT16_C( 18661),  INT16_C(  3878),  INT16_C( 18201),  INT16_C(  6097),  INT16_C( 18084), -INT16_C(  7737),
         INT16_C( 24884), -INT16_C(  5303),  INT16_C(    92), -INT16_C( 15897),  INT16_C(  3912), -INT16_C(  3927),  INT16_C( 21036),  INT16_C( 19615) } },
    { {  INT16_C(  8301), -INT16_C(  8211), -INT16_C(  7002), -INT16_C(  2268), -INT16_C( 30136),  INT16_C( 22654), -INT16_C( 10017),  INT16_C(   935),
        -INT16_C(   156),  INT16_C( 24552), -INT16_C( 13573), -INT16_C(  7251), -INT16_C(  6528),  INT16_C( 22547), -INT16_C( 16295), -INT16_C( 14636),
        -INT16_C( 15904), -INT16_C( 31067), -INT16_C( 13659), -INT16_C(  4483), -INT16_C(   940),  INT16_C( 13126), -INT16_C(  4652),  INT16_C( 14646),
         INT16_C(  7916), -INT16_C(  6248),  INT16_C( 17896),  INT16_C( 27082), -INT16_C(  8660), -INT16_C( 31295), -INT16_C( 27234),  INT16_C( 32331) },
      { -INT16_C(  4010), -INT16_C(  1020), -INT16_C( 32326),  INT16_C(  3818),  INT16_C( 12413),  INT16_C( 21057),  INT16_C( 30749),  INT16_C(  2443),
         INT16_C(  9110),  INT16_C( 32752), -INT16_C( 17816), -INT16_C( 27416), -INT16_C( 22120),  INT16_C( 13849),  INT16_C( 25663), -INT16_C( 27212),
        -INT16_C( 18347),  INT16_C(  3985),  INT16_C( 31546), -INT16_C( 18658),  INT16_C( 24491), -INT16_C( 14327), -INT16_C( 27433),  INT16_C( 28369),
        -INT16_C( 15945),  INT16_C(  8429), -INT16_C( 10884),  INT16_C(  5300), -INT16_C( 12674), -INT16_C( 17077), -INT16_C(   206), -INT16_C( 30893) },
      { -INT16_C(  1016),  INT16_C(   256),  INT16_C(  6908), -INT16_C(   264), -INT16_C( 11416),  INT16_C( 14558), -INT16_C(  9400),  INT16_C(    70),
        -INT16_C(    43),  INT16_C( 24540),  INT16_C(  7380),  INT16_C(  6067),  INT16_C(  4407),  INT16_C(  9529), -INT16_C( 12762),  INT16_C( 12154),
         INT16_C(  8905), -INT16_C(  3778), -INT16_C( 13150),  INT16_C(  2553), -INT16_C(   703), -INT16_C(  5739),  INT16_C(  3895),  INT16_C( 12680),
        -INT16_C(  3852), -INT16_C(  1607), -INT16_C(  5944),  INT16_C(  4380),  INT16_C(  3350),  INT16_C( 16309),  INT16_C(   171), -INT16_C( 30481) } },
    { { -INT16_C(  6984), -INT16_C(  3433), -INT16_C( 19104),  INT16_C(  2985), -INT16_C( 19692), -INT16_C(  4908), -INT16_C( 23225), -INT16_C(   166),
         INT16_C( 18279), -INT16_C(  7393), -INT16_C( 11492), -INT16_C( 25865),  INT16_C( 17057), -INT16_C( 11176), -INT16_C( 21694), -INT16_C(  1445),
        -INT16_C(  3441), -INT16_C(  4116), -INT16_C( 27225), -INT16_C( 17157), -INT16_C( 12472), -INT16_C( 28504),  INT16_C(   628), -INT16_C(  9329),
        -INT16_C( 20919),  INT16_C( 26046), -INT16_C( 18815),  INT16_C(  9215),  INT16_C( 22520),  INT16_C( 15095),  INT16_C( 20994), -INT16_C( 28108) },
      {  INT16_C(  8261), -INT16_C(  4991),  INT16_C( 31926), -INT16_C(   344),  INT16_C( 20555), -INT16_C( 16242),  INT16_C(  7506), -INT16_C( 25701),
         INT16_C( 23243),  INT16_C( 19712),  INT16_C(    16),  INT16_C(  2160),  INT16_C( 26455),  INT16_C( 23107),  INT16_C( 30649), -INT16_C(   276),
         INT16_C( 28056),  INT16_C( 20203), -INT16_C( 27670),  INT16_C( 13644), -INT16_C(  9244),  INT16_C( 14069), -INT16_C( 28168), -INT16_C( 15150),
        -INT16_C( 11541), -INT16_C(  1263), -INT16_C( 32302),  INT16_C( 10755),  INT16_C( 18152), -INT16_C( 24188),  INT16_C( 28862),  INT16_C( 22176) },
      { -INT16_C(  1761),  INT16_C(   523), -INT16_C( 18613), -INT16_C(    31), -INT16_C( 12353),  INT16_C(  2433), -INT16_C(  5320),  INT16_C(   130),
         INT16_C( 12966), -INT16_C(  4447), -INT16_C(     6), -INT16_C(  1705),  INT16_C( 13771), -INT16_C(  7881), -INT16_C( 20291),  INT16_C(    12),
        -INT16_C(  2946), -INT16_C(  2538),  INT16_C( 22989), -INT16_C(  7144),  INT16_C(  3518), -INT16_C( 12238), -INT16_C(   540),  INT16_C(  4313),
         INT16_C(  7368), -INT16_C(  1004),  INT16_C( 18547),  INT16_C(  3025),  INT16_C( 12475), -INT16_C( 11143),  INT16_C( 18491), -INT16_C( 19022) } },
    { { -INT16_C( 29731), -INT16_C( 14428), -INT16_C(  4066),  INT16_C(   765), -INT16_C(  3381), -INT16_C( 15303),  INT16_C(  2947),  INT16_C( 28296),
        -INT16_C( 26147), -INT16_C( 20375),  INT16_C( 27930),  INT16_C(   730),  INT16_C( 24243),  INT16_C( 29091),  INT16_C( 17358), -INT16_C( 21561),
         INT16_C( 27598), -INT16_C(  4749),  INT16_C( 28764),  INT16_C( 10223),  INT16_C( 10338), -INT16_C(  6421),  INT16_C( 29491),  INT16_C(  4436),
        -INT16_C( 16884),  INT16_C(  9921), -INT16_C( 25813), -INT16_C(  8664), -INT16_C( 13063), -INT16_C( 14512),  INT16_C(  5903), -INT16_C(  8590) },
      { -INT16_C(  6781), -INT16_C(  8245), -INT16_C( 17835), -INT16_C( 18426), -INT16_C(  3357),  INT16_C(  5790), -INT16_C(  3483),  INT16_C( 29223),
        -INT16_C(  5968), -INT16_C(  9320), -INT16_C( 15997),  INT16_C( 31930),  INT16_C(  2701), -INT16_C( 25533), -INT16_C( 18911), -INT16_C( 23430),
         INT16_C( 17819), -INT16_C(  3709), -INT16_C( 30208), -INT16_C(  7255),  INT16_C( 18300), -INT16_C(  7687),  INT16_C(  8505), -INT16_C(  5549),
        -INT16_C(  5111), -INT16_C( 29243),  INT16_C( 32685),  INT16_C( 14857),  INT16_C( 19849), -INT16_C( 21546),  INT16_C( 20739), -INT16_C( 25009) },
      {  INT16_C(  6153),  INT16_C(  3630),  INT16_C(  2213), -INT16_C(   430),  INT16_C(   346), -INT16_C(  2704), -INT16_C(   313),  INT16_C( 25235),
         INT16_C(  4762),  INT16_C(  5795), -INT16_C( 13635),  INT16_C(   711),  INT16_C(  1998), -INT16_C( 22668), -INT16_C( 10018),  INT16_C( 15417),
         INT16_C( 15008),  INT16_C(   538), -INT16_C( 26517), -INT16_C(  2263),  INT16_C(  5773),  INT16_C(  1506),  INT16_C(  7654), -INT16_C(   751),
         INT16_C(  2633), -INT16_C(  8854), -INT16_C( 25748), -INT16_C(  3928), -INT16_C(  7913),  INT16_C(  9542),  INT16_C(  3736),  INT16_C(  6556) } },
    { { -INT16_C( 11370), -INT16_C( 26993),  INT16_C( 14429), -INT16_C(  9863),  INT16_C( 29567), -INT16_C( 17990),  INT16_C(  3732), -INT16_C( 25181),
         INT16_C( 26874), -INT16_C( 22742),  INT16_C( 13544),  INT16_C( 29153), -INT16_C( 18559), -INT16_C( 31716),  INT16_C( 27656), -INT16_C( 24798),
        -INT16_C( 19905), -INT16_C( 25547), -INT16_C( 20502),  INT16_C( 27253),  INT16_C( 12066), -INT16_C( 18909), -INT16_C( 14787),  INT16_C( 14163),
         INT16_C( 32302),  INT16_C(  5854), -INT16_C( 16462),  INT16_C( 13192), -INT16_C( 23433),  INT16_C( 32695), -INT16_C(  9968),  INT16_C( 20254) },
      {  INT16_C( 21643),  INT16_C( 30443),  INT16_C( 24579),  INT16_C(  9696),  INT16_C(   912), -INT16_C( 12837),  INT16_C( 11977), -INT16_C(  2299),
        -INT16_C(  7252),  INT16_C( 24078), -INT16_C( 26973),  INT16_C(  6801),  INT16_C( 18490),  INT16_C( 19353), -INT16_C( 18398), -INT16_C( 21094),
        -INT16_C( 31220),  INT16_C(  3875),  INT16_C(   998),  INT16_C( 30260),  INT16_C(  3846), -INT16_C( 12476),  INT16_C( 18749), -INT16_C(  5433),
        -INT16_C( 10964), -INT16_C( 12472), -INT16_C(  9621), -INT16_C( 23063), -INT16_C( 31966),  INT16_C( 17648), -INT16_C( 29893),  INT16_C( 18418) },
      { -INT16_C(  7510), -INT16_C( 25078),  INT16_C( 10823), -INT16_C(  2918),  INT16_C(   823),  INT16_C(  7048),  INT16_C(  1364),  INT16_C(  1767),
        -INT16_C(  5948), -INT16_C( 16711), -INT16_C( 11149),  INT16_C(  6051), -INT16_C( 10472), -INT16_C( 18732), -INT16_C( 15528),  INT16_C( 15963),
         INT16_C( 18965), -INT16_C(  3021), -INT16_C(   624),  INT16_C( 25167),  INT16_C(  1416),  INT16_C(  7199), -INT16_C(  8461), -INT16_C(  2348),
        -INT16_C( 10808), -INT16_C(  2228),  INT16_C(  4833), -INT16_C(  9285),  INT16_C( 22859),  INT16_C( 17609),  INT16_C(  9093),  INT16_C( 11384) } },
    { {  INT16_C(  5393), -INT16_C(  2218), -INT16_C( 30183),  INT16_C(  8046), -INT16_C( 19815), -INT16_C( 10513), -INT16_C( 18693),  INT16_C( 10176),
         INT16_C(  2443), -INT16_C(  2313), -INT16_C(  7965),  INT16_C(  1435), -INT16_C( 29597), -INT16_C( 25014),  INT16_C( 15383),  INT16_C( 10469),
         INT16_C( 15185),  INT16_C( 27167), -INT16_C( 29243),  INT16_C( 24202),  INT16_C( 31039),  INT16_C( 14901), -INT16_C(  2769), -INT16_C( 17822),
         INT16_C( 23038), -INT16_C(  7760),  INT16_C( 19257), -INT16_C( 25113),  INT16_C( 12759), -INT16_C(  4549),  INT16_C(  8557), -INT16_C( 16874) },
      {  INT16_C( 13916),  INT16_C(  8745), -INT16_C( 19517),  INT16_C(   896), -INT16_C( 19156),  INT16_C( 23357), -INT16_C( 24661), -INT16_C( 22251),
        -INT16_C( 14856),  INT16_C( 12939),  INT16_C( 29200), -INT16_C(  5937),  INT16_C(  2723),  INT16_C(  4310), -INT16_C(  4821), -INT16_C( 30514),
        -INT16_C(  2269), -INT16_C(  6486),  INT16_C( 10922), -INT16_C( 10519),  INT16_C( 10208), -INT16_C( 29903),  INT16_C( 18118), -INT16_C( 16588),
        -INT16_C( 16629),  INT16_C(  7409), -INT16_C( 16335), -INT16_C( 11260), -INT16_C(  9526), -INT16_C(  2332), -INT16_C( 19513), -INT16_C(  5506) },
      {  INT16_C(  2290), -INT16_C(   592),  INT16_C( 17977),  INT16_C(   220),  INT16_C( 11584), -INT16_C(  7494),  INT16_C( 14068), -INT16_C(  6910),
        -INT16_C(  1108), -INT16_C(   913), -INT16_C(  7098), -INT16_C(   260), -INT16_C(  2459), -INT16_C(  3290), -INT16_C(  2263), -INT16_C(  9749),
        -INT16_C(  1051), -INT16_C(  5377), -INT16_C(  9747), -INT16_C(  7769),  INT16_C(  9669), -INT16_C( 13598), -INT16_C(  1531),  INT16_C(  9022),
        -INT16_C( 11691), -INT16_C(  1755), -INT16_C(  9600),  INT16_C(  8630), -INT16_C(  3709),  INT16_C(   324), -INT16_C(  5096),  INT16_C(  2835) } },
    { {  INT16_C( 10410),  INT16_C( 21969), -INT16_C( 17838),  INT16_C( 12843),  INT16_C( 24033), -INT16_C( 22339), -INT16_C(  3421), -INT16_C( 20633),
         INT16_C( 22705), -INT16_C(  7221), -INT16_C( 12520), -INT16_C(  7497), -INT16_C( 25431),  INT16_C( 29144),  INT16_C( 22095), -INT16_C(  1701),
         INT16_C( 11390), -INT16_C( 11954),  INT16_C( 31463), -INT16_C( 14333), -INT16_C( 15913),  INT16_C( 31344), -INT16_C( 10317),  INT16_C( 25641),
        -INT16_C(  3025),  INT16_C( 18247), -INT16_C(    61),  INT16_C( 27946),  INT16_C(   667), -INT16_C(  5410),  INT16_C( 14681), -INT16_C( 10269) },
      {  INT16_C( 12902),  INT16_C( 19880), -INT16_C( 21332), -INT16_C( 31979), -INT16_C( 31123),  INT16_C(  8445),  INT16_C( 10077), -INT16_C( 29308),
        -INT16_C( 13285), -INT16_C(  8236), -INT16_C(   309),  INT16_C( 26188),  INT16_C( 10753),  INT16_C( 23120),  INT16_C( 13155), -INT16_C( 14031),
        -INT16_C(  9627),  INT16_C(  4374),  INT16_C( 11398), -INT16_C(  3180), -INT16_C( 27982),  INT16_C(  3859), -INT16_C( 26695), -INT16_C( 11108),
         INT16_C( 29027),  INT16_C( 11955), -INT16_C(   145),  INT16_C( 28820), -INT16_C(  7127), -INT16_C( 29238), -INT16_C(  1000),  INT16_C( 32086) },
      {  INT16_C(  4099),  INT16_C( 13328),  INT16_C( 11613), -INT16_C( 12534), -INT16_C( 22827), -INT16_C(  5757), -INT16_C(  1052),  INT16_C( 18454),
        -INT16_C(  9205),  INT16_C(  1815),  INT16_C(   118), -INT16_C(  5992), -INT16_C(  8345),  INT16_C( 20563),  INT16_C(  8870),  INT16_C(   728),
        -INT16_C(  3346), -INT16_C(  1596),  INT16_C( 10944),  INT16_C(  1391),  INT16_C( 13589),  INT16_C(  3691),  INT16_C(  8405), -INT16_C(  8692),
        -INT16_C(  2680),  INT16_C(  6657),  INT16_C(     0),  INT16_C( 24579), -INT16_C(   145),  INT16_C(  4827), -INT16_C(   448), -INT16_C( 10055) } },
    { {  INT16_C( 28118),  INT16_C( 23695),  INT16_C(  9113),  INT16_C( 19279),  INT16_C( 25269),  INT16_C( 28250), -INT16_C(  2055),  INT16_C( 23875),
        -INT16_C(  2456), -INT16_C( 10357),  INT16_C(  8438),  INT16_C(  8008),  INT16_C(  4612),  INT16_C(  7340),  INT16_C(   782), -INT16_C(  7014),
         INT16_C( 10608),  INT16_C(  2368), -INT16_C( 28852),  INT16_C(   596), -INT16_C( 20751), -INT16_C(  5264), -INT16_C( 19547),  INT16_C(  3400),
        -INT16_C( 11350), -INT16_C( 24347),  INT16_C( 11763), -INT16_C(  1857),  INT16_C( 27711),  INT16_C( 19988), -INT16_C( 20881), -INT16_C(  8398) },
      {  INT16_C( 29655),  INT16_C(  9448),  INT16_C( 15362), -INT16_C(  3034), -INT16_C( 26902), -INT16_C( 28449),  INT16_C( 10058), -INT16_C(  2915),
        -INT16_C( 32006), -INT16_C(  4460),  INT16_C( 21423), -INT16_C(  4122), -INT16_C(  1345),  INT16_C( 11837),  INT16_C( 28585), -INT16_C( 32755),
        -INT16_C(  2590), -INT16_C(  6748), -INT16_C( 13775),  INT16_C(  7385), -INT16_C( 18335), -INT16_C( 21588),  INT16_C( 18911), -INT16_C(  9825),
         INT16_C( 13260),  INT16_C( 31687), -INT16_C( 21114),  INT16_C( 18026), -INT16_C( 22616),  INT16_C( 20852), -INT16_C( 32233), -INT16_C(  1583) },
      {  INT16_C( 25447),  INT16_C(  6832),  INT16_C(  4272), -INT16_C(  1785), -INT16_C( 20745), -INT16_C( 24526), -INT16_C(   631), -INT16_C(  2124),
         INT16_C(  2399),  INT16_C(  1410),  INT16_C(  5517), -INT16_C(  1007), -INT16_C(   189),  INT16_C(  2651),  INT16_C(   682),  INT16_C(  7011),
        -INT16_C(   838), -INT16_C(   488),  INT16_C( 12129),  INT16_C(   134),  INT16_C( 11611),  INT16_C(  3468), -INT16_C( 11281), -INT16_C(  1019),
        -INT16_C(  4593), -INT16_C( 23544), -INT16_C(  7579), -INT16_C(  1022), -INT16_C( 19126),  INT16_C( 12719),  INT16_C( 20540),  INT16_C(   406) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi16(test_vec[i].b);
    simde__m512i r = simde_mm512_mulhrs_epi16(a, b);
    simde_test_x86_assert_equal_i16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

SIMDE_TEST_FUNC_LIST_BEGIN
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mulhrs_epi16)
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/avx512/test-avx512-footer.h>
