/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;

final class NestedAllSky
implements HealpixNestedFixedRadiusConeComputer {
    private final double rRad;
    private final HealpixNestedBMOC moc;

    public NestedAllSky(double radiusRad, int depth) {
        assert (radiusRad >= Math.PI);
        this.rRad = radiusRad;
        long[] mocVals = new long[12];
        for (int i = 0; i < 12; ++i) {
            mocVals[i] = HealpixNestedBMOC.buildValue(0, i, true, depth);
        }
        this.moc = HealpixNestedBMOC.createUnsafe(depth, mocVals);
    }

    @Override
    public double getRadius() {
        return this.rRad;
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad) {
        return this.moc;
    }

    @Override
    public HealpixNestedBMOC overlappingCenters(double coneCenterLonRad, double coneCenterLatRad) {
        return this.moc;
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad, HealpixNestedFixedRadiusConeComputer.ReturnedCells returnedCells) {
        return this.moc;
    }

    @Override
    public HealpixNestedFixedRadiusConeComputer newComputer() {
        return this;
    }
}

