'\"
'\" Copyright (c) 2008 Peter Spjuth <pspjuth@users.sourceforge.net>
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH prefix n 8.6 Tcl "Tcl Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tcl::prefix \- facilities for prefix matching
.SH SYNOPSIS
.nf
\fB::tcl::prefix all\fR \fItable string\fR
\fB::tcl::prefix longest\fR \fItable string\fR
\fB::tcl::prefix match\fR ?\fIoption ...\fR? \fItable string\fR
.fi
.BE
.SH DESCRIPTION
.PP
This document describes commands looking up a prefix in a list of strings.
The following commands are supported:
.TP
\fB::tcl::prefix all\fR \fItable string\fR
.
Returns a list of all elements in \fItable\fR that begin with the prefix
\fIstring\fR.
.TP
\fB::tcl::prefix longest\fR \fItable string\fR
.
Returns the longest common prefix of all elements in \fItable\fR that
begin with the prefix \fIstring\fR.
.TP
\fB::tcl::prefix match\fR ?\fIoptions\fR? \fItable string\fR
.
If \fIstring\fR equals one element in \fItable\fR or is a prefix to exactly
one element, the matched element is returned. If not, the result depends
on the \fB\-error\fR option. (It is recommended that the \fItable\fR be sorted
before use with this subcommand, so that the list of matches presented in the
error message also becomes sorted, though this is not strictly necessary for
the operation of this subcommand itself.)
.RS
.TP
\fB\-exact\fR\0
.
Accept only exact matches.
.TP
\fB\-message\0\fIstring\fR
.
Use \fIstring\fR in the error message at a mismatch. Default is
.QW option .
.TP
\fB\-error\0\fIoptions\fR
.
The \fIoptions\fR are used when no match is found. If \fIoptions\fR is empty,
no error is generated and an empty string is returned. Otherwise the
\fIoptions\fR are used as \fBreturn\fR options when generating the error
message. The default corresponds to setting
.QW "\-level 0" .
Example: If
.QW "\fB\-error\fR {\-errorcode MyError \-level 1}"
is used, an error would be generated as:
.RS
.PP
.CS
return \-errorcode MyError \-level 1 \-code error \e
       "ambiguous option ..."
.CE
.RE
.RE
.SH "EXAMPLES"
.PP
Basic use:
.PP
.CS
namespace import ::tcl::prefix
\fBprefix match\fR {apa bepa cepa} apa
     \fI\(-> apa\fR
\fBprefix match\fR {apa bepa cepa} a
     \fI\(-> apa\fR
\fBprefix match\fR \-exact {apa bepa cepa} a
     \fI\(-> bad option "a": must be apa, bepa, or cepa\fR
\fBprefix match\fR \-message "switch" {apa ada bepa cepa} a
     \fI\(-> ambiguous switch "a": must be apa, ada, bepa, or cepa\fR
\fBprefix longest\fR {fblocked fconfigure fcopy file fileevent flush} fc
     \fI\(-> fco\fR
\fBprefix all\fR {fblocked fconfigure fcopy file fileevent flush} fc
     \fI\(-> fconfigure fcopy\fR
.CE
.PP
Simplifying option matching:
.PP
.CS
array set opts {\-apa 1 \-bepa "" \-cepa 0}
foreach {arg val} $args {
    set opts([\fBprefix match\fR {\-apa \-bepa \-cepa} $arg]) $val
}
.CE
.PP
Creating a \fBswitch\fR that supports prefixes:
.PP
.CS
switch [\fBprefix match\fR {apa bepa cepa} $arg] {
    apa  { }
    bepa { }
    cepa { }
}
.CE
.SH "SEE ALSO"
lsearch(n), namespace(n), string(n), Tcl_GetIndexFromObj(3)
.SH "KEYWORDS"
prefix, table lookup
'\" Local Variables:
'\" mode: nroff
'\" End:
