// @HEADER
//
// ***********************************************************************
//
//        MueLu: A package for multigrid based preconditioning
//                  Copyright 2012 Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact
//                    Jonathan Hu       (jhu@sandia.gov)
//                    Andrey Prokopenko (aprokop@sandia.gov)
//                    Ray Tuminaro      (rstumin@sandia.gov)
//
// ***********************************************************************
//
// @HEADER
#ifndef MUELU_DESCRIBABLE_DECL_HPP
#define MUELU_DESCRIBABLE_DECL_HPP

#include <string>                       // for string
#include "Teuchos_FancyOStream.hpp"     // for FancyOStream
#include "Teuchos_VerbosityLevel.hpp"   // for EVerbosityLevel
#include "Teuchos_Describable.hpp"

#include "MueLu_VerbosityLevel.hpp"

namespace MueLu {

  /*!
     @class Describable
     @brief Base class for MueLu classes

     @ingroup MueLuBaseClasses
  */
  class Describable
    : public Teuchos::Describable
  {
    mutable std::string shortClassName_ = ""; // cached so that we don't have to call demangleName() every time; mutable so that ShortClassName() can initialize lazily while remaining const

  public:

    //! Destructor.
    virtual ~Describable();

    //! @name MueLu Describe
    //@{

    virtual void describe(Teuchos::FancyOStream &out_arg, const VerbLevel verbLevel = Default) const;

    //@}

    //! @name Overridden from Teuchos::Describable
    //@{

    //! Return a simple one-line description of this object.
    virtual std::string description() const;

    //! Print the object with some verbosity level to an FancyOStream object.
    void describe(Teuchos::FancyOStream &out, const Teuchos::EVerbosityLevel verbLevel = Teuchos::Describable::verbLevel_default) const;

    //@}

    //! Return the class name of the object, without template parameters and without namespace
    virtual std::string ShortClassName() const;

  }; // class Describable

} // namespace MueLu

#define MUELU_DESCRIBABLE_SHORT
#endif // MUELU_DESCRIBABLE_DECL_HPP
