/*
* ===========================
* VDK Visual Development Kit
* Version 1.2.3
* October 1998, August 2000
* ===========================
*
* Copyright (C) 1998, Mario Motta
* Developed by Mario Motta <mmotta@guest.net>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
* 02111-1307, USA.
*
*/
#include "vdk/vdkstring.h"
#include <glib.h>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cstdarg>
extern "C"
{
#include <ctype.h>
}


VDKString  
VDKString::operator + (const char* s)  const
{
	VDKString temp(*this);
	temp += s; 
	return temp; 
}

VDKString operator +(const char* s, const VDKString& vdks)
{
	VDKString temp(s);
	temp += vdks;
	return temp;
}

VDKString::VDKString() 
{
	p = new STRING; p->s = 0;
	p->ref = 1;
}

VDKString::VDKString (const char*s) 
{
	p = new STRING;
	if(s)
	{
		p->s = new char[std::strlen(s)+1];
		std::strcpy(p->s,s);
	}
	else
	{
		p->s = 0;
	}
	p->ref = 1; 
}

VDKString::VDKString (const char& c)
{
	p = new STRING;
	if(c != '\0')
	{
		p->s = new char[2];
		(p->s)[0] = c;
		(p->s)[1] = '\0';
	}
	else
	{
		p->s = 0;
	}
	p->ref = 1;
}

VDKString::VDKString(const VDKString& s)
{
	s.p-> ref++;         
	p = s.p;             
}

VDKString& 
VDKString::operator= (const VDKString& s) 
{
	if (this == &s) return *this;
	else s.p->ref++;
	if (--p->ref == 0) 
	{ 
		if(p->s != 0)delete[] p->s;
		delete p; 
	} 
	p= s.p; 
	return *this;
}

VDKString& 
VDKString::operator= (const char* s)
{
	if (p->ref > 1) 
	{
		p->ref--;
		p = new STRING;
	}
else if (p->ref == 1 && p->s != 0 ) 
	{
		delete[] p->s;
	}
if(s)
	{
	  p->s = new char[std::strlen(s)+1];
	  std::strcpy(p->s,s);
	}
else
	{
	p->s = 0;
	}
p->ref = 1;
return *this;
}

VDKString::~VDKString() 
{
	if(--p->ref == 0)
	{
		if(p->s != 0) delete[] p->s;
		delete p;  
	}
}

int 
VDKString::operator == (const VDKString& s) const 
{ 
  if(p->s == s.p->s) // can be 0 either
    return true;
  else if ((p->s == 0) || (s.p->s == 0))
    return false;
  else
    return !std::strcmp(p->s,s.p->s); 
}

int 
VDKString::operator <( const VDKString& s) const 
{
  if ((p->s == 0) || (s.p->s == 0))
    return false;
  else
    return std::strcmp(p->s,s.p->s) < 0; 
}

int 
VDKString::operator>(const VDKString& s) const 
{
  if ((p->s == 0) || (s.p->s == 0))
    return false;
  else
    return std::strcmp(p->s,s.p->s) > 0; 
}

int 
VDKString::operator <=(const VDKString& s) const 
{ 
  return (*this < s || *this == s); 
}

int 
VDKString::operator >=(const VDKString& s) const 
{ 
  return (*this > s || *this == s); 
}

int 
VDKString::operator !=(const VDKString& s) const 
{ 
  return !(*this == s);	 
}

VDKString& 
VDKString::operator +=(const char* s) 
{
	if(isNull())
	  {
	    *this = VDKString(s);
	  }
	else
	  {
	    if(s)
	      {
		char* local = new char[std::strlen(p->s)+std::strlen (s)+1];
		std::strcat(std::strcpy(local,p->s),s);
		*this = VDKString(local);
		delete[] local;
	      }
	  }
	return *this;
}

VDKString& 
VDKString::operator +=(const VDKString& s)
{
  *this += s.c_str();
  return *this;		
}

const char* VDKString::c_str() const
{
  return p->s;
}

VDKString 
VDKString::operator + (const VDKString& s) const
{ 
  return *this + s.c_str();	
}

bool 
VDKString::isNull() const
{ 
  return (p->s == 0); 
}

int 
VDKString::size() const
{ 
  if(!isNull())
    return std::strlen(p->s);
  else
    return 0;
}

char VDKString::operator[](unsigned int ix) const
{
  if((p->s == 0) || (ix > std::strlen(p->s)))
    return '\0';
  else
    return p->s[ix];
}

VDKString&
VDKString::DelSelection(unsigned int begin, unsigned int len)
{
	if (isNull() || (len == 0)) return *this;
	unsigned int L = (unsigned int)size();
	if (begin > L) return *this;
	VDKString temp = p->s;
	temp.Cut(begin);
	if (begin + len < L) temp += (p->s + begin + len);
	*this = temp;
	return *this;
}

VDKString&
VDKString::RTrim()
{
	if (isNull()) return *this;
	unsigned int iPos = (unsigned int)size();
	unsigned int iCar = *(p->s + iPos - 1);
	while (iCar == ' ') {
		iPos--;
		iCar = *(p->s + iPos);
	}
	VDKString temp = p->s;
	*this = temp.Cut(iPos + 1);
	return *this;
}

VDKString&
VDKString::LTrim()
{
	if (isNull()) return *this;
	unsigned int iPos = 0;
	unsigned int iCar = *(p->s);
	while (iCar == ' ') {
		iPos++;
		iCar = *(p->s + iPos);
	}
	*this = DelSelection(0, iPos);
	return *this;
}

VDKString&
VDKString::Trim()
{
	RTrim();
	LTrim();
	return *this;
}

unsigned int
VDKString::CharCount(const char car) const
{
	if (isNull()) return 0;
	unsigned int i = 0, nbcar = 0;
	char Car = *p->s;
	while (Car != 0) {
		if (Car == car) nbcar++;
		Car = *(p->s + i + 1);
		i++;
	}
	return nbcar;
}

// This essentially for english or french people
// It has to be completed for other countries
VDKString&
VDKString::UpperCase()
{
	if (isNull()) return *this;
	unsigned int L = (unsigned int)size();
	char *szTemp = new char[L + 1];
	// Memory error
	if (szTemp == 0) return *this;
	for (unsigned int i = 0; i < L; i++) {
	   	switch (p->s[i]) {
			case '' :
			case '' :
		        case '' :
		        case '' :
		         	szTemp[i] = 'A';
					break;
			case '' :
		        case '' :
		        case '' :
		        case '' :
		         	szTemp[i] = 'E';
			        break;
			case '' :
	         	case '' :
	         	case '' :
	         	case '' :
	         		szTemp[i] = 'I';
					break;
	      		case '' :
	         	case '' :
	         	case '' :
	         	case '' :
	         		szTemp[i] = 'O';
					break;
	      		case '' :
	         	case '' :
	         	case '' :
	         	case '' :
	         		szTemp[i] = 'U';
					break;
	   		default : szTemp[i] = toupper(p->s[i]);
	      }
   }
   szTemp[L] = 0;
   *this = szTemp;
   return *this;
}

// It is supposed here that upper case letters
// never have accents
VDKString&
VDKString::LowerCase()
{
	if (isNull()) return *this;
	unsigned int L = (unsigned int)size();
	char *szTemp = new char[L + 1];
	// Memory error
	if (szTemp == 0) return *this;
	for (unsigned int i = 0; i < L; i++) {
		szTemp[i] = tolower(p->s[i]);
	}
	szTemp[L] = 0;
	*this = szTemp;
	return *this;
}

bool 
VDKString::isEmpty() const
{
	return (size() == 0); 
}

VDKString&
VDKString::Concatf(const char* format, ...)
{
	va_list argptr;
	int cnt;

	// buffer is already full up, give up
	if (size() > MAXPRINTFLEN - 1) return *this;
	// alloc a large string
	char* szBuffer = new char[MAXPRINTFLEN];
	// Memory error, nothing is done yet
	if (szBuffer == 0) return *this;
	// constructing the new string
	va_start(argptr, format);
	cnt = g_vsnprintf(szBuffer, MAXPRINTFLEN, format, argptr);
	va_end(argptr);
	if (cnt == EOF) {
		// EOF encountered, returns backward
		delete[] szBuffer;
		return *this;
	}
	*this = (*this += szBuffer);	
	delete[] szBuffer;
	return *this;
}


VDKString&
VDKString::Sprintf(const char* format, ...)
{
	va_list argptr;
	int cnt;

	// buffer is already full up, give up
	if (size() > MAXPRINTFLEN - 1) return *this;
	// alloc a large string
	char* szBuffer = new char[MAXPRINTFLEN];
	// Memory error, nothing is done yet
	if (szBuffer == 0) return *this;
	// constructing the new string
	va_start(argptr, format);
	cnt = g_vsnprintf(szBuffer, MAXPRINTFLEN, format, argptr);
	va_end(argptr);
	if (cnt == EOF) {
		// EOF encountered, returns backward
		delete[] szBuffer;
		return *this;
	}
	*this = szBuffer;
	delete[] szBuffer;
	return *this;
}

VDKString&
VDKString::GetPart(unsigned int i, const char sep)
{
	unsigned int L;
	char szSep[2];
	VDKString temp;

	if (isNull()) return *this;
	if ((i == 0) || (i > CharCount(sep) + 1)) {
		*this = temp;
		return *this;
	}
	unsigned int j = 1;
	szSep[0] = sep;
	szSep[1] = 0;
	char* szS = std::strpbrk(p->s, szSep);
	char* szP = p->s;
	while (j < i) {
		szP = szS + 1;
		szS = std::strpbrk(szP, szSep);
		j ++;
	}
	if (szS != 0) L = szS - szP;
	else L = (p->s + size()) - szP;
	temp = *this;
	temp.SubStr((szP - p->s), L);
	*this = temp;
	return *this;
}

int
VDKString::GetFCharPos(const char car) const
{
	if (isNull()) return -1;
	int rslt = (std::strchr(p->s, car) - p->s);
	if (rslt < 0) return -1;
	else return rslt;
}

int
VDKString::GetLCharPos(const char car) const
{
	if (isNull()) return -1;
	char *oldpos = p->s, *newpos = p->s;
	while (newpos) {
		oldpos = newpos;
		newpos = std::strchr(oldpos + 1, car);
	}
	if (oldpos == p->s) return -1;
	else return (oldpos - p->s);
}

double
VDKString::StrtoDouble() const
{
	if (isNull()) return 0;
	else return atof(p->s);
}

int
VDKString::StrtoInt() const
{
	if (isNull()) return 0;
	else return std::atoi(p->s);
}

VDKString&
VDKString::SubStr(unsigned int start, unsigned int len)
{
	if (isNull() || (start > (unsigned int)size())) return *this;
	char *szTemp = new char[size() + 1];
	std::strncpy(szTemp, (p->s + start), len);
	*(szTemp + len) = 0; // put ZT that strncpy always forget !!
	*this = szTemp;
	delete[] szTemp;
	return *this;
}

VDKString&
VDKString::Cut(unsigned int len)
{
	if (isNull() || (len >= (unsigned int)size())) return *this;
	VDKString temp = p->s;
	*(temp.p->s + len) = 0;
	*this = temp.p->s;
	return *this;
}

VDKString&
VDKString::LPad(unsigned int len, const char car)
{
	if (isNull()) return *this;
	unsigned int L = (unsigned int)size();
	int s = len - L; // s = number of missing chars
	if (s > 0) {
		char *local = new char[s + 1];
		std::memset(local, car, s);
		local[s] = 0;
		VDKString temp = local;
		*this = (temp += *this);
		delete[] local;
	}
	return *this;
}

VDKString&
VDKString::RPad(unsigned int len, const char car)
{
	if (isNull()) return *this;
	unsigned int L = (unsigned int)size();
	int s = len - L; // s = number of missing chars
	if (s > 0) {
		char *local = new char[s + 1];
		std::memset(local, car, s);
		local[s] = 0;
		VDKString temp = local;
		*this = (*this += temp);
		delete[] local;
	}
	return *this;
}

VDKString&
VDKString::DoubleChar(const char car)
{
	char DCar[3];
	VDKString temp, rslt;
	unsigned int i = 1, ncar;

	if (isNull() || (car == 0)) return *this;
	ncar = CharCount(car);
	// Nothing to modify here
	if (ncar == 0) return *this;
	DCar[0] = DCar[1] = car;
	DCar[2] = 0;
	for(i = 1; i <= ncar; i++) {
		temp = *this;
		temp.GetPart(i, car);
		rslt += temp;
		rslt += DCar;
	}
	temp = *this;
	temp.GetPart(i, car);
	rslt += temp;
	*this = rslt;
	return *this;
}

VDKString&
VDKString::FormatDate(const char sep, int orig, int ret)
{
	char day[3], month[3], year[5], rslt[11];
	unsigned int doffset, moffset, yoffset;

	if (isNull() || (size() < 8)) return *this;
	bool HasSep = (!isdigit(p->s[2]) || !isdigit(p->s[4]));
	std::memset(day, 0, 3);
	std::memset(month, 0, 3);
	std::memset(year, 0, 5);
	switch(orig) {
		case ENG_DATE :
			if (HasSep) {
				doffset = 3; moffset = 0; yoffset = 6;
			}
			else {
				doffset = 2; moffset = 0; yoffset = 4;
			}
			break;
		case EUR_DATE :
			if (HasSep) {
				doffset = 0; moffset = 3; yoffset = 6;
			}
			else {
				doffset = 0; moffset = 2; yoffset = 4;
			}
			break;
		default : // defaults to INT_DATE
			if (HasSep) {
				doffset = 8; moffset = 5; yoffset = 0;
			}
			else {
				doffset = 6; moffset = 4; yoffset = 0;
			}
	}
	std::memcpy(day, p->s + doffset, 2);
	std::memcpy(month, p->s + moffset, 2);
	std::memcpy(year, p->s + yoffset, 4);
	switch(ret) {
		case ENG_DATE :
			if (sep != 0)
				sprintf(rslt, "%s%c%s%c%s", month, sep, day, sep, year);
			else
				sprintf(rslt, "%s%s%s", month, day, year);
			break;
		case EUR_DATE :
			if (sep != 0)
				sprintf(rslt, "%s%c%s%c%s", day, sep, month, sep, year);
			else
				sprintf(rslt, "%s%s%s", day, month, year);
			break;
		default : // defaults to INT_DATE
			if (sep != 0)
				sprintf(rslt, "%s%c%s%c%s", year, sep, month, sep, day);
			else
				sprintf(rslt, "%s%s%s", year, month, day);
	}
	*this = rslt;
	return *this;
}
