/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.FindReplaceActions;
import jsyntaxpane.components.Markers;

public class ReplaceDialog
extends JDialog
implements CaretListener,
KeyListener,
ContainerListener {
    private JTextComponent textComponent;
    private FindReplaceActions finder;
    private static Markers.SimpleMarker SEARCH_MARKER = new Markers.SimpleMarker(Color.YELLOW);
    private JButton jBtnNext;
    private JButton jBtnReplaceAll;
    private JCheckBox jChkIgnoreCase;
    private JCheckBox jChkRegex;
    private JCheckBox jChkWrap;
    private JComboBox jCmbFind;
    private JComboBox jCmbReplace;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLblStatus;
    private JToggleButton jTglHighlight;

    public ReplaceDialog(JTextComponent text, FindReplaceActions finderActions) {
        super(ActionUtils.getFrameFor(text), false);
        this.initComponents();
        this.registerKeyAction(this);
        this.textComponent = text;
        this.finder = finderActions;
        this.textComponent.addCaretListener(this);
        this.setLocationRelativeTo(text.getRootPane());
    }

    public void updateHighlights() {
        Markers.removeMarkers(this.textComponent, SEARCH_MARKER);
        if (this.jTglHighlight.isSelected()) {
            Markers.markAll(this.textComponent, this.finder.getPattern(), SEARCH_MARKER);
        }
    }

    private void showRegexpError(PatternSyntaxException ex) throws HeadlessException {
        JOptionPane.showMessageDialog(this, "Regexp error: " + ex.getMessage(), "Regular Expression Error", 0);
        this.jCmbFind.requestFocus();
    }

    private void updateFinder() {
        String regex;
        int flag = 0;
        if (!this.jChkRegex.isSelected()) {
            flag |= 0x10;
        }
        flag |= this.jChkIgnoreCase.isSelected() ? 2 : 0;
        if (this.jChkIgnoreCase.isSelected()) {
            flag |= 2;
        }
        if ((regex = (String)this.jCmbFind.getSelectedItem()) != null && regex.length() > 0) {
            Pattern pattern = Pattern.compile(regex, flag);
            this.finder.setWrap(this.jChkWrap.isSelected());
            this.finder.setPattern(pattern);
            ActionUtils.insertIntoCombo(this.jCmbFind, regex);
        } else {
            this.finder.setPattern(null);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jBtnNext = new JButton();
        this.jLblStatus = new JLabel();
        this.jBtnReplaceAll = new JButton();
        this.jChkWrap = new JCheckBox();
        this.jChkRegex = new JCheckBox();
        this.jChkIgnoreCase = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jTglHighlight = new JToggleButton();
        this.jCmbReplace = new JComboBox();
        this.jCmbFind = new JComboBox();
        this.setTitle("Find and Replace");
        this.setName("");
        this.setResizable(false);
        this.jLabel1.setText("Find");
        this.jBtnNext.setMnemonic('N');
        this.jBtnNext.setText("Next");
        this.jBtnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jBtnNextActionPerformed(evt);
            }
        });
        this.jBtnReplaceAll.setMnemonic('H');
        this.jBtnReplaceAll.setText("Replace All");
        this.jBtnReplaceAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jBtnReplaceAllActionPerformed(evt);
            }
        });
        this.jChkWrap.setMnemonic('W');
        this.jChkWrap.setText("Wrap around");
        this.jChkWrap.setToolTipText("Wrap to beginning when end is reached");
        this.jChkRegex.setMnemonic('R');
        this.jChkRegex.setText("Regular Expression");
        this.jChkIgnoreCase.setMnemonic('I');
        this.jChkIgnoreCase.setText("Ignore Case");
        this.jLabel2.setText("Replace");
        this.jTglHighlight.setText("Highlight");
        this.jTglHighlight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jTglHighlightActionPerformed(evt);
            }
        });
        this.jCmbReplace.setEditable(true);
        this.jCmbFind.setEditable(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChkRegex).addComponent(this.jChkIgnoreCase)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(178, 178, 178).addComponent(this.jLblStatus, -1, 39, Short.MAX_VALUE).addGap(3, 3, 3)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkWrap, -2, 105, -2)))).addComponent(this.jCmbFind, 0, 337, Short.MAX_VALUE).addComponent(this.jCmbReplace, 0, 337, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jBtnReplaceAll, GroupLayout.Alignment.LEADING, -1, 102, Short.MAX_VALUE).addComponent(this.jBtnNext, GroupLayout.Alignment.LEADING, -1, 102, Short.MAX_VALUE).addComponent(this.jTglHighlight, -1, 102, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jLblStatus)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jCmbFind, -2, -1, -2)).addComponent(this.jBtnNext)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jBtnReplaceAll).addComponent(this.jCmbReplace, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkRegex).addComponent(this.jChkWrap, -2, 23, -2).addComponent(this.jTglHighlight)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkIgnoreCase).addContainerGap()));
        this.pack();
    }

    private void jBtnNextActionPerformed(ActionEvent evt) {
        try {
            this.updateFinder();
            this.finder.doFindNext(this.textComponent);
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException ex) {
            this.showRegexpError(ex);
        }
    }

    private void jBtnReplaceAllActionPerformed(ActionEvent evt) {
        try {
            this.updateFinder();
            String replacement = (String)this.jCmbReplace.getSelectedItem();
            ActionUtils.insertIntoCombo(this.jCmbFind, replacement);
            this.finder.replaceAll(this.textComponent, replacement);
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException ex) {
            this.showRegexpError(ex);
        }
    }

    private void jTglHighlightActionPerformed(ActionEvent evt) {
        this.updateFinder();
        this.updateHighlights();
    }

    public void caretUpdate(CaretEvent e) {
        this.updateHighlights();
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void componentAdded(ContainerEvent e) {
        this.registerKeyAction(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.registerKeyAction(e.getChild());
    }

    private void registerKeyAction(Component c) {
        if (!(c instanceof ReplaceDialog)) {
            c.removeKeyListener(this);
            c.addKeyListener(this);
        }
        if (c instanceof Container) {
            Container cnt = (Container)c;
            cnt.removeContainerListener(this);
            cnt.addContainerListener(this);
            Component[] ch = cnt.getComponents();
            for (int i = 0; i < ch.length; ++i) {
                this.registerKeyAction(ch[i]);
            }
        }
    }
}

