#!/usr/bin/make -f

comma = ,

# resolve all direct entries in first "package..." section in TODO
_VENDORLIBS = $(shell perl -nE \
 '/^(?:\s{2}[*]\s*(?:(package)|(\S+))|\s{4}[*]\s*(\S+))/ or next; \
 $$i++ if $$1; exit if $$i > 1 or $$2; say $$3 if $$3 and $$i;' \
 debian/TODO)
_preserve_crates_from_TODO = set -e;\
 cargo vendor --versioned-dirs debian/vendorlibs~;\
 rm -rf debian/vendorlibs;\
 mkdir debian/vendorlibs;\
 cd debian/vendorlibs~ && mv --target-directory=../vendorlibs $(_VENDORLIBS)
_tolerate_binaries_in_preserved_crates = set -e;\
 { cd debian/vendorlibs && grep -rIL . | sed 's/^/debian\/vendorlibs\//'; } \
 > debian/source/include-binaries

# preserve a file, and reset to use that (or optionally another)
_preserve_and_use = set -e; for f in $(1); do [ -f $$f.orig ] || cp $$f $$f.orig; cp -f $(or $2,$$f.orig) $$f; done

# restore a preserved file
_restore = for f in $(1); do [ ! -f $$f.orig ] || mv -f $$f.orig $$f; done

# mangle crate metadata
_mangle_version = perl -gpi \
 -e 's/$(1)\W+(version =)? "\K\Q$(subst |,$(comma),$(2))"/$(subst |,$(comma),$(3))"/g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(4))
_strip_crate = perl -gpi \
 -e 's/\[(dev-)?dependencies.($(subst $() $(),|,$(strip $(1))))\][^\n]*(\n[^\[\n][^\n]*)*//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(2))
_strip_crate_android = perl -gpi \
 -e 's/\[target\W+cfg\Wtarget_os\W+android\W+[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(1))
_strip_crate_mac = perl -gpi \
 -e 's/\[target\W+cfg(\Wall)?\W(target_os\W+(ios|macos)|target_vendor\W+apple)[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 -e 's/\[target\W+cfg\(any\((target_os\W+(ios|macos)\W+)+\)\)[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(1))
_strip_crate_mac_or_windows = perl -gpi \
 -e 's/\[target\W+cfg\(any\((target_os\W+(macos|windows)\W+)+\)\)[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(1))
_strip_crate_redox = perl -gpi \
 -e 's/\[target\W+cfg\Wtarget_os\W+redox[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(1))
_strip_crate_uefi = perl -gpi \
 -e 's/\[target\W+cfg(\Wall)?\Wtarget_os\W+uefi[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(1))
_strip_crate_wasm = perl -gpi \
 -e 's/\[target\W+cfg(\Wall)?\W(target_arch\W+wasm(32|64)|target_family\W+wasm|target_os\W+(emscripten|wasi))[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 -e 's/\[target\W+cfg(\Wall)?\Wany\((target_arch\W+wasm(32|64)\W+)+\)[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 -e 's/\[target\W+wasm(32|64)[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(1))
_strip_crate_windows = perl -gpi \
 -e 's/\[target\W+cfg(\Wall)?(\Wtarget_os)?\W+windows[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 -e 's/\[target\W+cfg\(any\(target_os\W+windows\W+\)\)[^\n]*(\n[^\[\n][^\n]*)*//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(1))
_strip_feature = perl -gpi \
 -e 's/\n($(subst $() $(),|,$(strip $(1)))) = \[[^\]]+\]//g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(2))
_strip_feature_item = perl -gpi \
 $(eval regex = ($(subst ?,\?,$(subst /,\/,$(subst $() $(),|,$(strip $(1)))))))\
 -e 's/\n\s+"($(regex))",//g;' \
 -e 's/\n\w\S+ = \[\K"($(regex))"\]/\]/g;' \
 $(patsubst %,debian/vendorlibs/%*/Cargo.toml,$(2))

# hint at effective licensing
_set_copyleft = perl -gpi \
 -e 's/\Qfn main() {\E\n\K/    println!("dh-cargo:deb-built-using=$(3)={}", std::env::var("CARGO_MANIFEST_DIR").unwrap());\n\n/g;' \
 debian/vendorlibs/$(2)*/$(1)
_set_copyleft_false = $(foreach x,$(2),$(call _set_copyleft,$(1),$(x),$(x)=0);)

# resolve summary for embedded crates
_GONE = $(filter-out 0,\
 $(shell grep -Fxc '      * package is missing' debian/TODO))
_PENDING = $(filter-out 0,\
 $(shell grep -Fxc '      * package is pending' debian/TODO))
_INCOMPLETE = $(filter-out 0,\
 $(shell grep -Fc '      * package lacks feature' debian/TODO))
_BROKEN = $(filter-out 0,\
 $(shell grep -c '      \* package is .*broken' debian/TODO))
_UNWANTED = $(filter-out 0,\
 $(shell grep -c '      \* package is unwanted' debian/TODO))
_OLD = $(filter-out 0,\
 $(shell grep -Fxc '      * package is outdated' debian/TODO))
_AHEAD = $(filter-out 0,\
 $(shell grep -Fxc '      * package is ahead' debian/TODO))
_SNAPSHOT = $(filter-out 0,\
 $(shell grep -Fxc '      * package should cover snapshot' debian/TODO))
_REASONS = $(strip\
 $(if $(_GONE),$(_GONE)_missing)\
 $(if $(_PENDING),$(_PENDING)_pending)\
 $(if $(_BROKEN),$(_BROKEN)_broken)\
 $(if $(_UNWANTED),$(_UNWANTED)_unwanted)\
 $(if $(_INCOMPLETE),$(_INCOMPLETE)_incomplete)\
 $(if $(_OLD),$(_OLD)_outdated)\
 $(if $(_AHEAD),$(_AHEAD)_ahead)\
 $(if $(_SNAPSHOT),$(_SNAPSHOT)_unreleased))
_EMBEDDED = $(if $(_REASONS),\n    ($(subst _,$() ,$(subst $() ,$(comma)_,$(_REASONS)))))
_summarize_in_changelog_and_to_stdout = @CRATES=$$(ls -1 debian/vendorlibs | grep -c .);\
 perl -gpi \
  -e 's/FIXME: avoid most possible of embedded \K\d+ crates\n\h+[^\)\n]*\)/'"$$CRATES"' crates$(_EMBEDDED)/;' \
  debian/changelog;\
 echo;\
 echo "DONE: embedding $$CRATES crates $(strip $(subst \n,,$(_EMBEDDED)))";\
 echo
