// GENERATED FILE - DO NOT EDIT.
// Generated by gen_spirv_builder_and_parser.py using data from spirv.core.grammar.json.
//
// Copyright 2021 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// spirv_instruction_parser_autogen.h:
//   Functions to parse SPIR-V binary for each instruction.

#ifndef COMMON_SPIRV_SPIRVINSTRUCTIONPARSERAUTOGEN_H_
#define COMMON_SPIRV_SPIRVINSTRUCTIONPARSERAUTOGEN_H_

#include <spirv/unified1/spirv.hpp>

#include "spirv_types.h"

namespace angle
{
namespace spirv
{
void GetInstructionOpAndLength(const uint32_t *_instruction, spv::Op *opOut, uint32_t *lengthOut);
void ParseUndef(const uint32_t *_instruction, IdResultType *idResultType1, IdResult *idResult2);
void ParseSourceContinued(const uint32_t *_instruction, LiteralString *continuedSource);
void ParseSource(const uint32_t *_instruction,
                 spv::SourceLanguage *sourceLanguage1,
                 LiteralInteger *version,
                 IdRef *file,
                 LiteralString *source);
void ParseSourceExtension(const uint32_t *_instruction, LiteralString *extension);
void ParseName(const uint32_t *_instruction, IdRef *target, LiteralString *name);
void ParseMemberName(const uint32_t *_instruction,
                     IdRef *type,
                     LiteralInteger *member,
                     LiteralString *name);
void ParseString(const uint32_t *_instruction, IdResult *idResult1, LiteralString *string);
void ParseLine(const uint32_t *_instruction,
               IdRef *file,
               LiteralInteger *line,
               LiteralInteger *column);
void ParseExtension(const uint32_t *_instruction, LiteralString *name);
void ParseExtInstImport(const uint32_t *_instruction, IdResult *idResult1, LiteralString *name);
void ParseExtInst(const uint32_t *_instruction,
                  IdResultType *idResultType1,
                  IdResult *idResult2,
                  IdRef *set,
                  LiteralExtInstInteger *instruction,
                  IdRefList *operandList);
void ParseMemoryModel(const uint32_t *_instruction,
                      spv::AddressingModel *addressingModel1,
                      spv::MemoryModel *memoryModel2);
void ParseEntryPoint(const uint32_t *_instruction,
                     spv::ExecutionModel *executionModel1,
                     IdRef *entryPoint,
                     LiteralString *name,
                     IdRefList *interfaceList);
void ParseExecutionMode(const uint32_t *_instruction,
                        IdRef *entryPoint,
                        spv::ExecutionMode *mode,
                        LiteralIntegerList *operandsList);
void ParseCapability(const uint32_t *_instruction, spv::Capability *capability);
void ParseTypeVoid(const uint32_t *_instruction, IdResult *idResult1);
void ParseTypeBool(const uint32_t *_instruction, IdResult *idResult1);
void ParseTypeInt(const uint32_t *_instruction,
                  IdResult *idResult1,
                  LiteralInteger *width,
                  LiteralInteger *signedness);
void ParseTypeFloat(const uint32_t *_instruction,
                    IdResult *idResult1,
                    LiteralInteger *width,
                    spv::FPEncoding *floatingPointEncoding);
void ParseTypeVector(const uint32_t *_instruction,
                     IdResult *idResult1,
                     IdRef *componentType,
                     LiteralInteger *componentCount);
void ParseTypeMatrix(const uint32_t *_instruction,
                     IdResult *idResult1,
                     IdRef *columnType,
                     LiteralInteger *columnCount);
void ParseTypeImage(const uint32_t *_instruction,
                    IdResult *idResult1,
                    IdRef *sampledType,
                    spv::Dim *dim3,
                    LiteralInteger *depth,
                    LiteralInteger *arrayed,
                    LiteralInteger *mS,
                    LiteralInteger *sampled,
                    spv::ImageFormat *imageFormat8,
                    spv::AccessQualifier *accessQualifier9);
void ParseTypeSampler(const uint32_t *_instruction, IdResult *idResult1);
void ParseTypeSampledImage(const uint32_t *_instruction, IdResult *idResult1, IdRef *imageType);
void ParseTypeArray(const uint32_t *_instruction,
                    IdResult *idResult1,
                    IdRef *elementType,
                    IdRef *length);
void ParseTypeRuntimeArray(const uint32_t *_instruction, IdResult *idResult1, IdRef *elementType);
void ParseTypeStruct(const uint32_t *_instruction, IdResult *idResult1, IdRefList *memberList);
void ParseTypePointer(const uint32_t *_instruction,
                      IdResult *idResult1,
                      spv::StorageClass *storageClass2,
                      IdRef *type);
void ParseTypeFunction(const uint32_t *_instruction,
                       IdResult *idResult1,
                       IdRef *returnType,
                       IdRefList *parameterList);
void ParseConstantTrue(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2);
void ParseConstantFalse(const uint32_t *_instruction,
                        IdResultType *idResultType1,
                        IdResult *idResult2);
void ParseConstant(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   LiteralContextDependentNumber *value);
void ParseConstantComposite(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRefList *constituentsList);
void ParseConstantNull(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2);
void ParseSpecConstantTrue(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2);
void ParseSpecConstantFalse(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2);
void ParseSpecConstant(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       LiteralContextDependentNumber *value);
void ParseSpecConstantComposite(const uint32_t *_instruction,
                                IdResultType *idResultType1,
                                IdResult *idResult2,
                                IdRefList *constituentsList);
void ParseFunction(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   spv::FunctionControlMask *functionControl3,
                   IdRef *functionType);
void ParseFunctionParameter(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2);
void ParseFunctionCall(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *function,
                       IdRefList *argumentList);
void ParseVariable(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   spv::StorageClass *storageClass3,
                   IdRef *initializer);
void ParseImageTexelPointer(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *image,
                            IdRef *coordinate,
                            IdRef *sample);
void ParseLoad(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *pointer,
               spv::MemoryAccessMask *memoryAccess4);
void ParseStore(const uint32_t *_instruction,
                IdRef *pointer,
                IdRef *object,
                spv::MemoryAccessMask *memoryAccess3);
void ParseCopyMemory(const uint32_t *_instruction,
                     IdRef *target,
                     IdRef *source,
                     spv::MemoryAccessMask *memoryAccess3,
                     spv::MemoryAccessMask *memoryAccess4);
void ParseAccessChain(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *base,
                      IdRefList *indexesList);
void ParseInBoundsAccessChain(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdRef *base,
                              IdRefList *indexesList);
void ParseArrayLength(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *structure,
                      LiteralInteger *arraymember);
void ParseDecorate(const uint32_t *_instruction,
                   IdRef *target,
                   spv::Decoration *decoration2,
                   LiteralIntegerList *valuesList);
void ParseMemberDecorate(const uint32_t *_instruction,
                         IdRef *structureType,
                         LiteralInteger *member,
                         spv::Decoration *decoration3,
                         LiteralIntegerList *valuesList);
void ParseDecorationGroup(const uint32_t *_instruction, IdResult *idResult1);
void ParseGroupDecorate(const uint32_t *_instruction,
                        IdRef *decorationGroup,
                        IdRefList *targetsList);
void ParseGroupMemberDecorate(const uint32_t *_instruction,
                              IdRef *decorationGroup,
                              PairIdRefLiteralIntegerList *targetsPairList);
void ParseVectorExtractDynamic(const uint32_t *_instruction,
                               IdResultType *idResultType1,
                               IdResult *idResult2,
                               IdRef *vector,
                               IdRef *index);
void ParseVectorInsertDynamic(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdRef *vector,
                              IdRef *component,
                              IdRef *index);
void ParseVectorShuffle(const uint32_t *_instruction,
                        IdResultType *idResultType1,
                        IdResult *idResult2,
                        IdRef *vector1,
                        IdRef *vector2,
                        LiteralIntegerList *componentsList);
void ParseCompositeConstruct(const uint32_t *_instruction,
                             IdResultType *idResultType1,
                             IdResult *idResult2,
                             IdRefList *constituentsList);
void ParseCompositeExtract(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *composite,
                           LiteralIntegerList *indexesList);
void ParseCompositeInsert(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *object,
                          IdRef *composite,
                          LiteralIntegerList *indexesList);
void ParseCopyObject(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand);
void ParseTranspose(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *matrix);
void ParseSampledImage(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *image,
                       IdRef *sampler);
void ParseImageSampleImplicitLod(const uint32_t *_instruction,
                                 IdResultType *idResultType1,
                                 IdResult *idResult2,
                                 IdRef *sampledImage,
                                 IdRef *coordinate,
                                 spv::ImageOperandsMask *imageOperands5,
                                 IdRefList *imageOperandIdsList);
void ParseImageSampleExplicitLod(const uint32_t *_instruction,
                                 IdResultType *idResultType1,
                                 IdResult *idResult2,
                                 IdRef *sampledImage,
                                 IdRef *coordinate,
                                 spv::ImageOperandsMask *imageOperands5,
                                 IdRefList *imageOperandIdsList);
void ParseImageSampleDrefImplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     IdRef *dref,
                                     spv::ImageOperandsMask *imageOperands6,
                                     IdRefList *imageOperandIdsList);
void ParseImageSampleDrefExplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     IdRef *dref,
                                     spv::ImageOperandsMask *imageOperands6,
                                     IdRefList *imageOperandIdsList);
void ParseImageSampleProjImplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     spv::ImageOperandsMask *imageOperands5,
                                     IdRefList *imageOperandIdsList);
void ParseImageSampleProjExplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     spv::ImageOperandsMask *imageOperands5,
                                     IdRefList *imageOperandIdsList);
void ParseImageSampleProjDrefImplicitLod(const uint32_t *_instruction,
                                         IdResultType *idResultType1,
                                         IdResult *idResult2,
                                         IdRef *sampledImage,
                                         IdRef *coordinate,
                                         IdRef *dref,
                                         spv::ImageOperandsMask *imageOperands6,
                                         IdRefList *imageOperandIdsList);
void ParseImageSampleProjDrefExplicitLod(const uint32_t *_instruction,
                                         IdResultType *idResultType1,
                                         IdResult *idResult2,
                                         IdRef *sampledImage,
                                         IdRef *coordinate,
                                         IdRef *dref,
                                         spv::ImageOperandsMask *imageOperands6,
                                         IdRefList *imageOperandIdsList);
void ParseImageFetch(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *image,
                     IdRef *coordinate,
                     spv::ImageOperandsMask *imageOperands5,
                     IdRefList *imageOperandIdsList);
void ParseImageGather(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *sampledImage,
                      IdRef *coordinate,
                      IdRef *component,
                      spv::ImageOperandsMask *imageOperands6,
                      IdRefList *imageOperandIdsList);
void ParseImageDrefGather(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *sampledImage,
                          IdRef *coordinate,
                          IdRef *dref,
                          spv::ImageOperandsMask *imageOperands6,
                          IdRefList *imageOperandIdsList);
void ParseImageRead(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *image,
                    IdRef *coordinate,
                    spv::ImageOperandsMask *imageOperands5,
                    IdRefList *imageOperandIdsList);
void ParseImageWrite(const uint32_t *_instruction,
                     IdRef *image,
                     IdRef *coordinate,
                     IdRef *texel,
                     spv::ImageOperandsMask *imageOperands4,
                     IdRefList *imageOperandIdsList);
void ParseImage(const uint32_t *_instruction,
                IdResultType *idResultType1,
                IdResult *idResult2,
                IdRef *sampledImage);
void ParseImageQuerySizeLod(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *image,
                            IdRef *levelofDetail);
void ParseImageQuerySize(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *image);
void ParseImageQueryLod(const uint32_t *_instruction,
                        IdResultType *idResultType1,
                        IdResult *idResult2,
                        IdRef *sampledImage,
                        IdRef *coordinate);
void ParseImageQueryLevels(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *image);
void ParseImageQuerySamples(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *image);
void ParseConvertFToU(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *floatValue);
void ParseConvertFToS(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *floatValue);
void ParseConvertSToF(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *signedValue);
void ParseConvertUToF(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *unsignedValue);
void ParseUConvert(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *unsignedValue);
void ParseSConvert(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *signedValue);
void ParseFConvert(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *floatValue);
void ParseQuantizeToF16(const uint32_t *_instruction,
                        IdResultType *idResultType1,
                        IdResult *idResult2,
                        IdRef *value);
void ParseBitcast(const uint32_t *_instruction,
                  IdResultType *idResultType1,
                  IdResult *idResult2,
                  IdRef *operand);
void ParseSNegate(const uint32_t *_instruction,
                  IdResultType *idResultType1,
                  IdResult *idResult2,
                  IdRef *operand);
void ParseFNegate(const uint32_t *_instruction,
                  IdResultType *idResultType1,
                  IdResult *idResult2,
                  IdRef *operand);
void ParseIAdd(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseFAdd(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseISub(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseFSub(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseIMul(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseFMul(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseUDiv(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseSDiv(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseFDiv(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseUMod(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseSRem(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseSMod(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseFRem(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseFMod(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2);
void ParseVectorTimesScalar(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *vector,
                            IdRef *scalar);
void ParseMatrixTimesScalar(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *matrix,
                            IdRef *scalar);
void ParseVectorTimesMatrix(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *vector,
                            IdRef *matrix);
void ParseMatrixTimesVector(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *matrix,
                            IdRef *vector);
void ParseMatrixTimesMatrix(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *leftMatrix,
                            IdRef *rightMatrix);
void ParseOuterProduct(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *vector1,
                       IdRef *vector2);
void ParseDot(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              IdRef *vector1,
              IdRef *vector2);
void ParseIAddCarry(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseISubBorrow(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand1,
                     IdRef *operand2);
void ParseUMulExtended(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseSMulExtended(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseAny(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              IdRef *vector);
void ParseAll(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              IdRef *vector);
void ParseIsNan(const uint32_t *_instruction,
                IdResultType *idResultType1,
                IdResult *idResult2,
                IdRef *x);
void ParseIsInf(const uint32_t *_instruction,
                IdResultType *idResultType1,
                IdResult *idResult2,
                IdRef *x);
void ParseLogicalEqual(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseLogicalNotEqual(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *operand1,
                          IdRef *operand2);
void ParseLogicalOr(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseLogicalAnd(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand1,
                     IdRef *operand2);
void ParseLogicalNot(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand);
void ParseSelect(const uint32_t *_instruction,
                 IdResultType *idResultType1,
                 IdResult *idResult2,
                 IdRef *condition,
                 IdRef *object1,
                 IdRef *object2);
void ParseIEqual(const uint32_t *_instruction,
                 IdResultType *idResultType1,
                 IdResult *idResult2,
                 IdRef *operand1,
                 IdRef *operand2);
void ParseINotEqual(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseUGreaterThan(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseSGreaterThan(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseUGreaterThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *operand1,
                            IdRef *operand2);
void ParseSGreaterThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *operand1,
                            IdRef *operand2);
void ParseULessThan(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseSLessThan(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseULessThanEqual(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *operand1,
                         IdRef *operand2);
void ParseSLessThanEqual(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *operand1,
                         IdRef *operand2);
void ParseFOrdEqual(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseFUnordEqual(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *operand1,
                      IdRef *operand2);
void ParseFOrdNotEqual(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseFUnordNotEqual(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *operand1,
                         IdRef *operand2);
void ParseFOrdLessThan(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseFUnordLessThan(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *operand1,
                         IdRef *operand2);
void ParseFOrdGreaterThan(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *operand1,
                          IdRef *operand2);
void ParseFUnordGreaterThan(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *operand1,
                            IdRef *operand2);
void ParseFOrdLessThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *operand1,
                            IdRef *operand2);
void ParseFUnordLessThanEqual(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdRef *operand1,
                              IdRef *operand2);
void ParseFOrdGreaterThanEqual(const uint32_t *_instruction,
                               IdResultType *idResultType1,
                               IdResult *idResult2,
                               IdRef *operand1,
                               IdRef *operand2);
void ParseFUnordGreaterThanEqual(const uint32_t *_instruction,
                                 IdResultType *idResultType1,
                                 IdResult *idResult2,
                                 IdRef *operand1,
                                 IdRef *operand2);
void ParseShiftRightLogical(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *base,
                            IdRef *shift);
void ParseShiftRightArithmetic(const uint32_t *_instruction,
                               IdResultType *idResultType1,
                               IdResult *idResult2,
                               IdRef *base,
                               IdRef *shift);
void ParseShiftLeftLogical(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *base,
                           IdRef *shift);
void ParseBitwiseOr(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseBitwiseXor(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand1,
                     IdRef *operand2);
void ParseBitwiseAnd(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand1,
                     IdRef *operand2);
void ParseNot(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              IdRef *operand);
void ParseBitFieldInsert(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *base,
                         IdRef *insert,
                         IdRef *offset,
                         IdRef *count);
void ParseBitFieldSExtract(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *base,
                           IdRef *offset,
                           IdRef *count);
void ParseBitFieldUExtract(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *base,
                           IdRef *offset,
                           IdRef *count);
void ParseBitReverse(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *base);
void ParseBitCount(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *base);
void ParseDPdx(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *p);
void ParseDPdy(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *p);
void ParseFwidth(const uint32_t *_instruction,
                 IdResultType *idResultType1,
                 IdResult *idResult2,
                 IdRef *p);
void ParseDPdxFine(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *p);
void ParseDPdyFine(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *p);
void ParseFwidthFine(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *p);
void ParseDPdxCoarse(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *p);
void ParseDPdyCoarse(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *p);
void ParseFwidthCoarse(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *p);
void ParseEmitStreamVertex(const uint32_t *_instruction, IdRef *stream);
void ParseEndStreamPrimitive(const uint32_t *_instruction, IdRef *stream);
void ParseControlBarrier(const uint32_t *_instruction,
                         IdScope *execution,
                         IdScope *memory,
                         IdMemorySemantics *semantics);
void ParseMemoryBarrier(const uint32_t *_instruction,
                        IdScope *memory,
                        IdMemorySemantics *semantics);
void ParseAtomicLoad(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics);
void ParseAtomicStore(const uint32_t *_instruction,
                      IdRef *pointer,
                      IdScope *memory,
                      IdMemorySemantics *semantics,
                      IdRef *value);
void ParseAtomicExchange(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *pointer,
                         IdScope *memory,
                         IdMemorySemantics *semantics,
                         IdRef *value);
void ParseAtomicCompareExchange(const uint32_t *_instruction,
                                IdResultType *idResultType1,
                                IdResult *idResult2,
                                IdRef *pointer,
                                IdScope *memory,
                                IdMemorySemantics *equal,
                                IdMemorySemantics *unequal,
                                IdRef *value,
                                IdRef *comparator);
void ParseAtomicIIncrement(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *pointer,
                           IdScope *memory,
                           IdMemorySemantics *semantics);
void ParseAtomicIDecrement(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *pointer,
                           IdScope *memory,
                           IdMemorySemantics *semantics);
void ParseAtomicIAdd(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicISub(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicSMin(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicUMin(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicSMax(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicUMax(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicAnd(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *pointer,
                    IdScope *memory,
                    IdMemorySemantics *semantics,
                    IdRef *value);
void ParseAtomicOr(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *pointer,
                   IdScope *memory,
                   IdMemorySemantics *semantics,
                   IdRef *value);
void ParseAtomicXor(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *pointer,
                    IdScope *memory,
                    IdMemorySemantics *semantics,
                    IdRef *value);
void ParsePhi(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              PairIdRefIdRefList *variableParentPairList);
void ParseLoopMerge(const uint32_t *_instruction,
                    IdRef *mergeBlock,
                    IdRef *continueTarget,
                    spv::LoopControlMask *loopControl3);
void ParseSelectionMerge(const uint32_t *_instruction,
                         IdRef *mergeBlock,
                         spv::SelectionControlMask *selectionControl2);
void ParseLabel(const uint32_t *_instruction, IdResult *idResult1);
void ParseBranch(const uint32_t *_instruction, IdRef *targetLabel);
void ParseBranchConditional(const uint32_t *_instruction,
                            IdRef *condition,
                            IdRef *trueLabel,
                            IdRef *falseLabel,
                            LiteralIntegerList *branchweightsList);
void ParseSwitch(const uint32_t *_instruction,
                 IdRef *selector,
                 IdRef *default_,
                 PairLiteralIntegerIdRefList *targetPairList);
void ParseReturnValue(const uint32_t *_instruction, IdRef *value);
void ParseImageSparseSampleImplicitLod(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdRef *sampledImage,
                                       IdRef *coordinate,
                                       spv::ImageOperandsMask *imageOperands5,
                                       IdRefList *imageOperandIdsList);
void ParseImageSparseSampleExplicitLod(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdRef *sampledImage,
                                       IdRef *coordinate,
                                       spv::ImageOperandsMask *imageOperands5,
                                       IdRefList *imageOperandIdsList);
void ParseImageSparseSampleDrefImplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType1,
                                           IdResult *idResult2,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           IdRef *dref,
                                           spv::ImageOperandsMask *imageOperands6,
                                           IdRefList *imageOperandIdsList);
void ParseImageSparseSampleDrefExplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType1,
                                           IdResult *idResult2,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           IdRef *dref,
                                           spv::ImageOperandsMask *imageOperands6,
                                           IdRefList *imageOperandIdsList);
void ParseImageSparseSampleProjImplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType1,
                                           IdResult *idResult2,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           spv::ImageOperandsMask *imageOperands5,
                                           IdRefList *imageOperandIdsList);
void ParseImageSparseSampleProjExplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType1,
                                           IdResult *idResult2,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           spv::ImageOperandsMask *imageOperands5,
                                           IdRefList *imageOperandIdsList);
void ParseImageSparseSampleProjDrefImplicitLod(const uint32_t *_instruction,
                                               IdResultType *idResultType1,
                                               IdResult *idResult2,
                                               IdRef *sampledImage,
                                               IdRef *coordinate,
                                               IdRef *dref,
                                               spv::ImageOperandsMask *imageOperands6,
                                               IdRefList *imageOperandIdsList);
void ParseImageSparseSampleProjDrefExplicitLod(const uint32_t *_instruction,
                                               IdResultType *idResultType1,
                                               IdResult *idResult2,
                                               IdRef *sampledImage,
                                               IdRef *coordinate,
                                               IdRef *dref,
                                               spv::ImageOperandsMask *imageOperands6,
                                               IdRefList *imageOperandIdsList);
void ParseImageSparseFetch(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *image,
                           IdRef *coordinate,
                           spv::ImageOperandsMask *imageOperands5,
                           IdRefList *imageOperandIdsList);
void ParseImageSparseGather(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *sampledImage,
                            IdRef *coordinate,
                            IdRef *component,
                            spv::ImageOperandsMask *imageOperands6,
                            IdRefList *imageOperandIdsList);
void ParseImageSparseDrefGather(const uint32_t *_instruction,
                                IdResultType *idResultType1,
                                IdResult *idResult2,
                                IdRef *sampledImage,
                                IdRef *coordinate,
                                IdRef *dref,
                                spv::ImageOperandsMask *imageOperands6,
                                IdRefList *imageOperandIdsList);
void ParseImageSparseTexelsResident(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdRef *residentCode);
void ParseImageSparseRead(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *image,
                          IdRef *coordinate,
                          spv::ImageOperandsMask *imageOperands5,
                          IdRefList *imageOperandIdsList);
void ParseModuleProcessed(const uint32_t *_instruction, LiteralString *process);
void ParseExecutionModeId(const uint32_t *_instruction,
                          IdRef *entryPoint,
                          spv::ExecutionMode *mode,
                          LiteralIntegerList *operandsList);
void ParseGroupNonUniformElect(const uint32_t *_instruction,
                               IdResultType *idResultType1,
                               IdResult *idResult2,
                               IdScope *execution);
void ParseGroupNonUniformAll(const uint32_t *_instruction,
                             IdResultType *idResultType1,
                             IdResult *idResult2,
                             IdScope *execution,
                             IdRef *predicate);
void ParseGroupNonUniformAny(const uint32_t *_instruction,
                             IdResultType *idResultType1,
                             IdResult *idResult2,
                             IdScope *execution,
                             IdRef *predicate);
void ParseGroupNonUniformAllEqual(const uint32_t *_instruction,
                                  IdResultType *idResultType1,
                                  IdResult *idResult2,
                                  IdScope *execution,
                                  IdRef *value);
void ParseGroupNonUniformBroadcast(const uint32_t *_instruction,
                                   IdResultType *idResultType1,
                                   IdResult *idResult2,
                                   IdScope *execution,
                                   IdRef *value,
                                   IdRef *invocationId);
void ParseGroupNonUniformBroadcastFirst(const uint32_t *_instruction,
                                        IdResultType *idResultType1,
                                        IdResult *idResult2,
                                        IdScope *execution,
                                        IdRef *value);
void ParseGroupNonUniformBallot(const uint32_t *_instruction,
                                IdResultType *idResultType1,
                                IdResult *idResult2,
                                IdScope *execution,
                                IdRef *predicate);
void ParseGroupNonUniformInverseBallot(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdScope *execution,
                                       IdRef *value);
void ParseGroupNonUniformBallotBitExtract(const uint32_t *_instruction,
                                          IdResultType *idResultType1,
                                          IdResult *idResult2,
                                          IdScope *execution,
                                          IdRef *value,
                                          IdRef *index);
void ParseGroupNonUniformBallotBitCount(const uint32_t *_instruction,
                                        IdResultType *idResultType1,
                                        IdResult *idResult2,
                                        IdScope *execution,
                                        spv::GroupOperation *operation,
                                        IdRef *value);
void ParseGroupNonUniformBallotFindLSB(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdScope *execution,
                                       IdRef *value);
void ParseGroupNonUniformBallotFindMSB(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdScope *execution,
                                       IdRef *value);
void ParseGroupNonUniformShuffle(const uint32_t *_instruction,
                                 IdResultType *idResultType1,
                                 IdResult *idResult2,
                                 IdScope *execution,
                                 IdRef *value,
                                 IdRef *invocationId);
void ParseGroupNonUniformShuffleXor(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    IdRef *value,
                                    IdRef *mask);
void ParseGroupNonUniformShuffleUp(const uint32_t *_instruction,
                                   IdResultType *idResultType1,
                                   IdResult *idResult2,
                                   IdScope *execution,
                                   IdRef *value,
                                   IdRef *delta);
void ParseGroupNonUniformShuffleDown(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdScope *execution,
                                     IdRef *value,
                                     IdRef *delta);
void ParseGroupNonUniformIAdd(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformFAdd(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformIMul(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformFMul(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformSMin(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformUMin(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformFMin(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformSMax(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformUMax(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformFMax(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize);
void ParseGroupNonUniformBitwiseAnd(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    spv::GroupOperation *operation,
                                    IdRef *value,
                                    IdRef *clusterSize);
void ParseGroupNonUniformBitwiseOr(const uint32_t *_instruction,
                                   IdResultType *idResultType1,
                                   IdResult *idResult2,
                                   IdScope *execution,
                                   spv::GroupOperation *operation,
                                   IdRef *value,
                                   IdRef *clusterSize);
void ParseGroupNonUniformBitwiseXor(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    spv::GroupOperation *operation,
                                    IdRef *value,
                                    IdRef *clusterSize);
void ParseGroupNonUniformLogicalAnd(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    spv::GroupOperation *operation,
                                    IdRef *value,
                                    IdRef *clusterSize);
void ParseGroupNonUniformLogicalOr(const uint32_t *_instruction,
                                   IdResultType *idResultType1,
                                   IdResult *idResult2,
                                   IdScope *execution,
                                   spv::GroupOperation *operation,
                                   IdRef *value,
                                   IdRef *clusterSize);
void ParseGroupNonUniformLogicalXor(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    spv::GroupOperation *operation,
                                    IdRef *value,
                                    IdRef *clusterSize);
void ParseGroupNonUniformQuadBroadcast(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdScope *execution,
                                       IdRef *value,
                                       IdRef *index);
void ParseGroupNonUniformQuadSwap(const uint32_t *_instruction,
                                  IdResultType *idResultType1,
                                  IdResult *idResult2,
                                  IdScope *execution,
                                  IdRef *value,
                                  IdRef *direction);
void ParseCopyLogical(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *operand);
void ParsePtrEqual(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *operand1,
                   IdRef *operand2);
void ParsePtrNotEqual(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *operand1,
                      IdRef *operand2);

}  // namespace spirv
}  // namespace angle

#endif  // COMMON_SPIRV_SPIRVINSTRUCTIONPARSERAUTOGEN_H_
