/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;
import jde.debugger.spec.EventRequestSpecList;
import jde.debugger.spec.WatchpointSpec;

public class Watch
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 3) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = this.m_args.remove(0).toString();
        String methodName = this.m_args.remove(0).toString();
        String typeString = this.m_args.remove(0).toString().toLowerCase();
        EventRequestSpecList eventRequests = this.m_debugger.getEventRequestSpecList();
        WatchpointSpec er = null;
        if (typeString.equals("for_access")) {
            if (!this.m_debugger.getVM().canWatchFieldAccess()) {
                throw new JDEException("This VM implementation cannot watch field accesses");
            }
            er = eventRequests.createAccessWatchpoint(classPattern, methodName);
        } else if (typeString.equals("for_modification")) {
            if (!this.m_debugger.getVM().canWatchFieldModification()) {
                throw new JDEException("This VM implementation cannot watch field modifications");
            }
            er = eventRequests.createModificationWatchpoint(classPattern, methodName);
        } else {
            throw new JDEException("'" + typeString + "' not understood: use either 'for_access' or 'for_modification'");
        }
        er.setThread(Etc.getThreadFromArgs(this.m_args));
        er.setExpression(Etc.getExprFromArgs(this.m_args));
        er.setObjectID(Etc.getObjectIDFromArgs(this.m_args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.m_args));
        er.setClassFilters(Etc.getClassFiltersFromArgs(this.m_args));
        er.setClassExFilters(Etc.getClassExFiltersFromArgs(this.m_args));
        eventRequests.install(er);
        this.m_debugger.signalCommandResult(this.m_cmdID, er.getID().toString(), true, false);
    }

    public Object clone() {
        return new Watch();
    }
}

