/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;

public class UnresolvedRowHint {
    static final short FIELD_TABLE_ID = 0;
    static final short FIELD_ROW_ID = 1;
    static final short FIELD_SPAN_CELL_INFO = 2;
    static final short FIELD_NONE = 100;
    protected String tableId;
    protected String rowId;
    protected ArrayList cells = new ArrayList();

    public UnresolvedRowHint() {
    }

    public UnresolvedRowHint(String tableId, String rowId) {
        this.tableId = tableId;
        this.rowId = rowId;
    }

    public void addUnresolvedCell(String style, int colId, int colSpan, int rowSpan) {
        this.cells.add(new SpannedCellInfo(style, colId, colSpan, rowSpan));
    }

    public ICellContent initUnresolvedCell(ICellContent cell, InstanceID rowId, int colId) {
        int rowSpan = 1;
        int colSpan = 1;
        SpannedCellInfo cellInfo = this.getSpannedCellInfo(colId);
        if (cellInfo != null) {
            rowSpan = cellInfo.rowSpan;
            if (rowSpan > 1 && !this.equals(rowId, this.rowId)) {
                --rowSpan;
            }
            colSpan = cellInfo.colSpan;
            if (cellInfo.style != null && cellInfo.style.length() > 0) {
                CSSEngine engine = cell.getCSSEngine();
                StyleDeclaration style = new StyleDeclaration(engine);
                style.setCssText(cellInfo.style);
                cell.setInlineStyle(style);
            }
        }
        cell.setColumn(colId);
        cell.setRowSpan(rowSpan);
        cell.setColSpan(colSpan);
        return cell;
    }

    public boolean isDropColumn(int colId) {
        for (SpannedCellInfo cellInfo : this.cells) {
            if (!(cellInfo.colId == colId & cellInfo.rowSpan < 0)) continue;
            return true;
        }
        return false;
    }

    protected SpannedCellInfo getSpannedCellInfo(int colId) {
        for (SpannedCellInfo cellInfo : this.cells) {
            if (cellInfo.colId != colId) continue;
            return cellInfo;
        }
        return null;
    }

    protected boolean equals(InstanceID rowId, String id) {
        if (rowId != null && id != null) {
            return rowId.toUniqueString().equals(id);
        }
        return false;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void writeObject(DataOutputStream out) throws IOException {
        if (this.tableId != null) {
            IOUtil.writeShort((OutputStream)out, (short)0);
            IOUtil.writeString((DataOutputStream)out, (String)this.tableId.toString());
        }
        if (this.rowId != null) {
            IOUtil.writeShort((OutputStream)out, (short)1);
            IOUtil.writeString((DataOutputStream)out, (String)this.rowId.toString());
        }
        if (this.cells.size() > 0) {
            for (SpannedCellInfo cell : this.cells) {
                IOUtil.writeShort((OutputStream)out, (short)2);
                cell.writeObject(out);
            }
        }
        IOUtil.writeShort((OutputStream)out, (short)100);
    }

    public void readObject(DataInputStream in) throws IOException {
        int filedId = 0;
        while (filedId != 100) {
            filedId = IOUtil.readShort((InputStream)in);
            switch (filedId) {
                case 0: {
                    this.tableId = IOUtil.readString((DataInputStream)in);
                    break;
                }
                case 1: {
                    this.rowId = IOUtil.readString((DataInputStream)in);
                    break;
                }
                case 2: {
                    SpannedCellInfo cell = new SpannedCellInfo();
                    cell.readObject(in);
                    this.cells.add(cell);
                    break;
                }
            }
        }
    }

    protected static class SpannedCellInfo {
        static final short FIELD_STYLE = 0;
        static final short FIELD_COLID = 1;
        static final short FIELD_ROWSPAN = 2;
        static final short FIELD_COLSPAN = 3;
        static final short FIELD_NONE = 100;
        protected String style;
        protected int rowSpan;
        protected int colId;
        protected int colSpan;

        public SpannedCellInfo() {
        }

        public SpannedCellInfo(String style, int colId, int colSpan, int rowSpan) {
            this.style = style;
            this.colId = colId;
            this.rowSpan = rowSpan;
            this.colSpan = colSpan;
        }

        public void writeObject(DataOutputStream out) throws IOException {
            if (this.style != null) {
                IOUtil.writeShort((OutputStream)out, (short)0);
                IOUtil.writeString((DataOutputStream)out, (String)this.style);
            }
            IOUtil.writeShort((OutputStream)out, (short)1);
            IOUtil.writeInt((OutputStream)out, (int)this.colId);
            IOUtil.writeShort((OutputStream)out, (short)2);
            IOUtil.writeInt((OutputStream)out, (int)this.rowSpan);
            IOUtil.writeShort((OutputStream)out, (short)3);
            IOUtil.writeInt((OutputStream)out, (int)this.colSpan);
            IOUtil.writeShort((OutputStream)out, (short)100);
        }

        public void readObject(DataInputStream in) throws IOException {
            int filedId = 0;
            while (filedId != 100) {
                filedId = IOUtil.readShort((InputStream)in);
                switch (filedId) {
                    case 0: {
                        this.style = IOUtil.readString((DataInputStream)in);
                        break;
                    }
                    case 1: {
                        this.colId = IOUtil.readInt((InputStream)in);
                        break;
                    }
                    case 2: {
                        this.rowSpan = IOUtil.readInt((InputStream)in);
                        break;
                    }
                    case 3: {
                        this.colSpan = IOUtil.readInt((InputStream)in);
                        break;
                    }
                }
            }
        }
    }
}

