/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.common.util.XmlUtil;
import com.nvidia.cuda.ide.util.IMarkerScope;
import com.nvidia.viper.EventManager;
import com.nvidia.viper.MetricManager;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.TimelineFactory;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityAPI;
import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityEvent;
import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.activity.CuptiActivityOpenAcc;
import com.nvidia.viper.activity.CuptiActivityPCSampling;
import com.nvidia.viper.activity.CuptiActivityPCSamplingRecordInfo;
import com.nvidia.viper.activity.CuptiActivitySourceLevelResultBase;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultCriticalPath;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.jni.CCFFMessage;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.jni.CallTree;
import com.nvidia.viper.jni.ChironException;
import com.nvidia.viper.jni.CpuSampleInfo;
import com.nvidia.viper.jni.CpuThread;
import com.nvidia.viper.jni.NativeChiron;
import com.nvidia.viper.jni.NativeXutils;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.ContainerState;
import com.nvidia.viper.model.CriticalPath;
import com.nvidia.viper.model.CudaFunctionManager;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ExpertData;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.InstantaneousEventManager;
import com.nvidia.viper.model.InstantaneousMetricManager;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.OpenAccSummary;
import com.nvidia.viper.model.OpenMPSummary;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.model.SourceLevelResult;
import com.nvidia.viper.model.SourceLocator;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineColorMode;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalAPI;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineIntervalMemset;
import com.nvidia.viper.model.TimelineIntervalOpenAcc;
import com.nvidia.viper.model.TimelineIntervalPThread;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineProcess;
import com.nvidia.viper.model.TimelineRuler;
import com.nvidia.viper.model.TimelineStream;
import com.nvidia.viper.model.TimelineUVM;
import com.nvidia.viper.model.UniqueActivityID;
import com.nvidia.viper.model.UvmManager;
import com.nvidia.viper.model.VerticalRuler;
import com.nvidia.viper.ui.CpuTreeView;
import com.nvidia.viper.ui.LargeDataMessageDialog;
import com.nvidia.viper.ui.TimelineFigure;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.Disposable;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Session
extends ModelWithProperties
implements IModel,
IMarkerScope,
ISessionSerializable,
Disposable {
    private static final int VERSION_COPY_PDM_FILE = 2;
    public static final int VERSION = 2;
    public static final String PROPERTY_SESSION = "session:session";
    public static final String PROPERTY_NAME = "session:name";
    public static final String PROPERTY_FILE = "session:file";
    public static final String PROPERTY_EXECUTABLE = "session:executable";
    public static final String PROPERTY_EXPERT = "session:expert";
    public static final String PROPERTY_ANALYSIS = "session:analysis";
    public static final String PROPERTY_EXPERT_SYSTEM = "session:expertsystem";
    public static final String PROPERTY_EXPERTDATA = "session:expertdata";
    public static final String PROPERTY_TIMELINES = "session:timelines";
    public static final String PROPERTY_TIMELINE = "session:timeline";
    public static final String PROPERTY_TIMELINE_RESET = "session:timelinereset";
    public static final String PROPERTY_VRULER = "session:vruler";
    public static final String PROPERTY_HRULER = "session:hruler";
    public static final String PROPERTY_HORIZONTAL_SCALE = "session:hScale";
    public static final String PROPERTY_HORIZONTAL_REVEAL = "session:hReveal";
    public static final String PROPERTY_X_POSITION = "session:xPosition";
    public static final String PROPERTY_WIDTH = "session:width";
    public static final String PROPERTY_VERTICAL_REVEAL = "session:vReveal";
    public static final String PROPERTY_HIGHLIGHT_INTERVAL = "session:hInterval";
    public static final String PROPERTY_SELECTED_INTERVAL = "session:sInterval";
    public static final String PROPERTY_COLORMODE = "session:colorMode";
    public static final String PROPERTY_PROGRESS_CANCEL = "session:progress:cancel";
    public static final String PROPERTY_UNFOCUS_TIMELINES = "session:unfocus:timelines";
    public static final String DATANAME_TIMELINE = "session:dataname:timeline";
    public static final String DATANAME_METRIC = "session:dataname:metric";
    private static final double DEFAULT_HSCALE = 1.0E-6;
    public static final String FILE_EXTENSION = "nvvp";
    private CpuThread currentThread;
    private Collection<CpuThread> allThreads;
    private int version;
    private String name;
    private int pdmSize = -1;
    private long startCorrelationId;
    private long endCorrelationId;
    private Executable executable;
    private Expert expert;
    private String rebelReportPath;
    private Analysis analysis;
    private ExpertSystem expertSystem;
    private SourceLocator sourceLocator;
    private CudaFunctionManager cudaFunctionManager;
    private InstantaneousMetricManager instantaneousMetricManager;
    private InstantaneousEventManager instantaneousEventManager;
    private UvmManager uvmManager;
    private ExpertData expertData;
    private List<Timeline> topLevelTimelines;
    private List<Timeline> allTimelines;
    private List<Timeline> allVisibleTimelines;
    private TimelineState timelineState;
    private TimelineRuler horizontalRuler;
    private VerticalRuler verticalRuler;
    private double maxHorizontalScale;
    private double horizontalScale;
    private int horizontalReveal;
    private int xPosition;
    private int width;
    private int verticalReveal;
    private TimelineIntervalPair primaryHighlighted;
    private Collection<TimelineIntervalPair> allHighlighted;
    private TimelineIntervalPair primarySelected;
    private Collection<TimelineIntervalPair> secondarySelected;
    private Collection<TimelineIntervalPair> allSelected;
    private Collection<Long> allSelectedIntervalIds;
    private boolean dirty;
    private boolean readOnly;
    private Object file;
    private Color currentTimelineBGColor;
    private ViperColors.GradientColors[] timelineIntervalColors;
    private TimelineColorMode colorMode;
    private TimelineFactory timelineFactory;
    private LinkedList<Thread> tlRefreshThreads = new LinkedList();
    private EventRefreshThread etRefreshThread;
    private Lock threadsControl = new ReentrantLock();
    private volatile Condition tlThreadFinished = this.threadsControl.newCondition();
    private volatile Condition etThreadFinished = this.threadsControl.newCondition();
    private volatile boolean tlThreadRunning = false;
    private volatile boolean etThreadRunning = false;
    private Map<Long, Set<UniqueActivityID>> kernelIDMap = new HashMap<Long, Set<UniqueActivityID>>();
    private Map<Long, Long> idToAuxIdMap = new HashMap<Long, Long>();
    private Map<Long, Long> idToEndIdMap = new HashMap<Long, Long>();
    public Map<Integer, ViperColors.GradientColors> processIdToColorMap = new HashMap<Integer, ViperColors.GradientColors>();
    public Map<Integer, ViperColors.GradientColors> streamIdToColorMap = new HashMap<Integer, ViperColors.GradientColors>();
    public Map<String, ViperColors.GradientColors> kernelNameToColorMap = new HashMap<String, ViperColors.GradientColors>();
    private Set<Event> eventSet = new HashSet<Event>();
    private Set<Metric> aggregatedMetricSet = new HashSet<Metric>();
    private boolean timelinesCreated = false;
    private CriticalPath criticalPathCache = null;
    private OpenAccSummary openAccSummary = null;
    private Map<Integer, OpenAccSummary> openAccSummaryMap;
    private Map<Integer, OpenMPSummary> openMPSummaryMap;
    private Map<SessionFilter, String> scopeReportMap = null;
    private TimelineOptions timelineOptions;
    int timelineFocusMode;
    private static final int MAX_CACHED_INTERVALS = 100000;
    private LinkedHashMap<Long, ITimelineInterval> recentlyLoadedIntervals;
    private long earliestTime;
    private long latestTime;
    private Map<ProfileDataModel, TimeRange> pdmTimeRangeMap;
    private boolean normalizeIndependent;
    private CallTree[] cpuTree;
    private TreePath[][] cpuTreeState;
    private CpuSampleInfo samples;
    private HashMap<String, List<CCFFMessage>> messagesMap;
    private IPath cpuSourceBaseDir;
    private String cpuFile;
    private int samplingPeriod;
    private int summaryViewDefaultProcess;
    public static int UVM_NUM_SEGMENT_DEFAULT = 100;

    public void addAnalysisMapping(long id, Set<UniqueActivityID> analyses) {
        ITimelineInterval interval = this.recentlyLoadedIntervals.get(id);
        if (interval != null) {
            interval.setAnalysisLoaded(false);
        }
        if (analyses == null) {
            return;
        }
        Set<UniqueActivityID> set = this.kernelIDMap.get(id);
        if (set == null) {
            set = new HashSet<UniqueActivityID>();
            this.kernelIDMap.put(id, set);
        } else {
            TimelineIntervalKernel kernel = (TimelineIntervalKernel)interval;
            HashSet<Integer> metricsToRemove = new HashSet<Integer>();
            HashSet<Event> eventsToRemove = new HashSet<Event>();
            Set<SourceLevelResult> sourceLevelResults = null;
            boolean pcSamplingRecordInfo = false;
            block12: for (UniqueActivityID analysis : analyses) {
                ICuptiActivity analysisActivity = analysis.pdm.getActivity(analysis.id);
                if (analysisActivity == null) continue;
                switch (analysisActivity.getKind()) {
                    case CUPTI_ACTIVITY_KIND_EVENT: 
                    case CUPTI_ACTIVITY_KIND_EVENT_INSTANCE: {
                        Long kernelEventValue;
                        CuptiActivityEvent analysisEventActivity = (CuptiActivityEvent)analysisActivity;
                        Event analysisEvent = EventManager.getEvent(analysisEventActivity.domain, analysisEventActivity.id);
                        if (kernel == null || (kernelEventValue = kernel.getEventValue(analysisEvent)) == null) continue block12;
                        eventsToRemove.add(analysisEvent);
                        break;
                    }
                    case CUPTI_ACTIVITY_KIND_METRIC: 
                    case CUPTI_ACTIVITY_KIND_METRIC_INSTANCE: {
                        CuptiActivityMetric kernelMetricActivity;
                        CuptiActivityMetric analysisMetricActivity = (CuptiActivityMetric)analysisActivity;
                        Metric analysisMetric = MetricManager.getMetric(analysisMetricActivity.id);
                        if (kernel == null || (kernelMetricActivity = kernel.getAggregateMetricActivity(analysisMetric)) == null) continue block12;
                        metricsToRemove.add(analysisMetricActivity.id);
                        break;
                    }
                    case CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS: 
                    case CUPTI_ACTIVITY_KIND_BRANCH: 
                    case CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION: 
                    case CUPTI_ACTIVITY_KIND_SHARED_ACCESS: 
                    case CUPTI_ACTIVITY_KIND_PC_SAMPLING: {
                        sourceLevelResults = analysis.pdm.getNullSourceLevelResults();
                        break;
                    }
                    case CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO: {
                        sourceLevelResults = analysis.pdm.getNullSourceLevelResults();
                        pcSamplingRecordInfo = true;
                        break;
                    }
                }
            }
            Iterator<UniqueActivityID> existingAnalysisIterator = set.iterator();
            block13: while (existingAnalysisIterator.hasNext()) {
                UniqueActivityID existingAnalysis = existingAnalysisIterator.next();
                ICuptiActivity existingAnalysisActivity = existingAnalysis.pdm.getActivity(existingAnalysis.id);
                if (existingAnalysisActivity == null) continue;
                block6 : switch (existingAnalysisActivity.getKind()) {
                    case CUPTI_ACTIVITY_KIND_EVENT: 
                    case CUPTI_ACTIVITY_KIND_EVENT_INSTANCE: {
                        CuptiActivityEvent existingAnalysisEventActivity = (CuptiActivityEvent)existingAnalysisActivity;
                        if (!eventsToRemove.contains(EventManager.getEvent(existingAnalysisEventActivity.domain, existingAnalysisEventActivity.id))) break;
                        existingAnalysisIterator.remove();
                        break;
                    }
                    case CUPTI_ACTIVITY_KIND_METRIC: 
                    case CUPTI_ACTIVITY_KIND_METRIC_INSTANCE: {
                        CuptiActivityMetric existingAnalysisMetricActivity = (CuptiActivityMetric)existingAnalysisActivity;
                        if (!metricsToRemove.contains(existingAnalysisMetricActivity.id)) break;
                        existingAnalysisIterator.remove();
                        break;
                    }
                    case CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS: 
                    case CUPTI_ACTIVITY_KIND_BRANCH: 
                    case CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION: 
                    case CUPTI_ACTIVITY_KIND_SHARED_ACCESS: 
                    case CUPTI_ACTIVITY_KIND_PC_SAMPLING: {
                        if (sourceLevelResults == null) continue block13;
                        for (SourceLevelResult sourceLevelResult : sourceLevelResults) {
                            if (sourceLevelResult.getActivityKind() != existingAnalysisActivity.getKind()) continue;
                            existingAnalysisIterator.remove();
                            break block6;
                        }
                        continue block13;
                    }
                    case CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO: {
                        if (!pcSamplingRecordInfo) break;
                        existingAnalysisIterator.remove();
                        break;
                    }
                }
            }
        }
        set.addAll(analyses);
    }

    public void addAnalysisResults(ITimelineInterval kernel) {
        if (kernel.isAllAnalysisDataLoaded()) {
            return;
        }
        kernel.clearSourceLevelResults();
        HashSet<CuptiActivityKind> presentKinds = new HashSet<CuptiActivityKind>();
        HashSet<SourceLevelResult> nullSourceLevelResults = new HashSet<SourceLevelResult>();
        Set<UniqueActivityID> set = this.kernelIDMap.get(kernel.getID());
        if (set != null) {
            for (UniqueActivityID id : set) {
                Set<SourceLevelResult> nullResults;
                if (id.id != 0L) {
                    this.addSingleAnalysisFromId(kernel, id.pdm, id.id, presentKinds);
                }
                if ((nullResults = id.pdm.getNullSourceLevelResults()) == null) continue;
                nullSourceLevelResults.addAll(nullResults);
            }
        }
        for (SourceLevelResult slr : nullSourceLevelResults) {
            if (presentKinds.contains((Object)slr.getActivityKind())) continue;
            kernel.addSourceLevelResult(slr.createNullCuptiActivity(kernel));
        }
        kernel.setAnalysisLoaded(true);
    }

    public int getMainFunctionId(CuptiActivityFunction f, ProfileDataModel pdm) {
        CuptiActivityFunction function = pdm.functions.get(f.id);
        CuptiActivityFunction sessionFunction = null;
        if (function != null && (sessionFunction = this.cudaFunctionManager.getFunction(f.name, f.moduleId)) == null) {
            ViperExceptionHandler.logError("Can't find function");
        }
        return sessionFunction == null ? -1 : sessionFunction.id;
    }

    public int getMainSourceLocatorId(int id, ProfileDataModel pdm) {
        CuptiActivitySourceLocator cuptiLocator = pdm.sourceLocators.get(id);
        CuptiActivitySourceLocator sessionCuptiLocator = null;
        if (cuptiLocator != null && cuptiLocator.id != 0 && (sessionCuptiLocator = this.sourceLocator.getLocation(cuptiLocator, cuptiLocator.lineNumber)) == null) {
            sessionCuptiLocator = this.sourceLocator.createLocation(cuptiLocator, cuptiLocator.lineNumber);
        }
        int newSrcLocatorId = sessionCuptiLocator == null ? 0 : sessionCuptiLocator.id;
        return newSrcLocatorId;
    }

    private void addSingleAnalysisFromId(ITimelineInterval kernel, ProfileDataModel pdm, long id, Set<CuptiActivityKind> presentKinds) {
        if (id == 0L) {
            return;
        }
        ICuptiActivity a = pdm.getActivity(this.timelineFactory.getOriginalId(id));
        if (a != null) {
            try {
                this.addSingleAnalysis(kernel, presentKinds, a, pdm);
            }
            catch (Exception e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
    }

    private void addSingleAnalysis(ITimelineInterval kernel, Set<CuptiActivityKind> presentKinds, ICuptiActivity activity, ProfileDataModel pdm) throws Exception {
        switch (activity.getKind()) {
            case CUPTI_ACTIVITY_KIND_EVENT: 
            case CUPTI_ACTIVITY_KIND_EVENT_INSTANCE: {
                CuptiActivityEvent event = (CuptiActivityEvent)activity;
                kernel.addEvent(event);
                break;
            }
            case CUPTI_ACTIVITY_KIND_METRIC: 
            case CUPTI_ACTIVITY_KIND_METRIC_INSTANCE: {
                CuptiActivityMetric metric = (CuptiActivityMetric)activity;
                kernel.addMetric(metric);
                break;
            }
            case CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS: 
            case CUPTI_ACTIVITY_KIND_BRANCH: 
            case CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION: 
            case CUPTI_ACTIVITY_KIND_SHARED_ACCESS: 
            case CUPTI_ACTIVITY_KIND_PC_SAMPLING: {
                CuptiActivityBase sourceLevel = activity.getKind() == CuptiActivityKind.CUPTI_ACTIVITY_KIND_PC_SAMPLING ? (CuptiActivityPCSampling)activity : (CuptiActivitySourceLevelResultBase)activity;
                kernel.addSourceLevelResult((ICuptiActivitySourceLevelResult)((Object)sourceLevel));
                int functionId = sourceLevel.getFunctionId();
                if (functionId != 0) {
                    sourceLevel.setFunctionId(this.getMainFunctionId(pdm.functions.get(functionId), pdm));
                }
                sourceLevel.setSourceLocatorId(this.getMainSourceLocatorId(sourceLevel.getSourceLocatorId(), pdm));
                presentKinds.add(sourceLevel.getKind());
                break;
            }
            case CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO: {
                CuptiActivityPCSamplingRecordInfo recordInfo = (CuptiActivityPCSamplingRecordInfo)activity;
                kernel.addPCSamplingRecordInfo(recordInfo);
                break;
            }
        }
    }

    public ITimelineInterval loadInterval(long id, boolean addAnalysisResult) {
        if (id == 0L) {
            return null;
        }
        ITimelineInterval interval = this.getLoadedInterval(id);
        if (interval == null) {
            Long auxId = this.getAuxId(id);
            Long endId = this.getEndId(id);
            ITimelineInterval iTimelineInterval = this.timelineFactory == null ? null : (interval = this.timelineFactory.loadIntervalFromId(id, auxId == null ? 0L : auxId, endId == null ? 0L : endId, true));
            if (interval == null) {
                return null;
            }
        }
        if (interval.getKind() == TimelineIntervalKind.KERNEL && addAnalysisResult) {
            this.addAnalysisResults((TimelineIntervalKernel)interval);
        }
        return interval;
    }

    public Session() {
        this.timelineFocusMode = TimelineFocusMode.NONE.value;
        this.recentlyLoadedIntervals = new LinkedHashMap<Long, ITimelineInterval>(100001, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, ITimelineInterval> eldest) {
                return this.size() > 100000;
            }
        };
        this.pdmTimeRangeMap = new HashMap<ProfileDataModel, TimeRange>();
        this.normalizeIndependent = false;
        this.messagesMap = new HashMap();
        this.samplingPeriod = 0;
        this.version = 2;
        this.name = null;
        this.executable = null;
        this.expert = null;
        this.analysis = null;
        this.expertSystem = null;
        this.sourceLocator = new SourceLocator(this);
        this.cudaFunctionManager = new CudaFunctionManager();
        this.instantaneousMetricManager = new InstantaneousMetricManager();
        this.instantaneousEventManager = new InstantaneousEventManager();
        this.uvmManager = new UvmManager(this);
        this.topLevelTimelines = new LinkedList<Timeline>();
        this.allTimelines = null;
        this.allVisibleTimelines = null;
        this.timelineState = null;
        this.maxHorizontalScale = 1.0E-6;
        this.horizontalScale = 1.0E-6;
        this.xPosition = 0;
        this.width = 1000;
        this.earliestTime = -1L;
        this.latestTime = 0L;
        this.file = null;
        this.dirty = false;
        this.readOnly = false;
        this.currentTimelineBGColor = ViperColors.TIMELINE_BGCOLOR_0;
        this.timelineIntervalColors = null;
        this.colorMode = TimelineColorMode.KERNEL;
        this.setVerticalRuler(new VerticalRuler(this));
        this.setHorizontalRuler(new TimelineRuler(this));
        this.cpuTree = new CallTree[3];
        this.cpuTreeState = new TreePath[3][];
        this.allThreads = new HashSet<CpuThread>();
        this.samples = new CpuSampleInfo();
        this.messagesMap = new HashMap();
        this.timelineOptions = new TimelineOptions();
        this.openAccSummaryMap = new HashMap<Integer, OpenAccSummary>();
        this.openMPSummaryMap = new HashMap<Integer, OpenMPSummary>();
        this.summaryViewDefaultProcess = 0;
        this.addPropertyChangeListener(new ISessionPropertyChangeListener(){

            @Override
            public void propertyChange(IModel model, String propertyName) {
                if (Session.PROPERTY_ANALYSIS.equals(propertyName)) {
                    Session.this.updateCriticalPathCache();
                }
            }
        });
    }

    public Session(Element el) throws ViperException {
        this();
        this.read(el);
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.firePropertyChange(PROPERTY_TIMELINE_RESET);
        this.removeAllPropertyChangeListeners();
        Session session = this;
        synchronized (session) {
            Thread th = this.tlRefreshThreads.peekLast();
            if (th != null) {
                th.interrupt();
            }
            this.waitForLoadTimelines();
        }
        if (this.timelineFactory != null) {
            this.timelineFactory.dispose();
            this.timelineFactory = null;
        }
        try {
            this.setTimelines(null);
        }
        catch (ViperException e) {
            ViperExceptionHandler.logError("unable to dispose timelines", e);
        }
        if (this.executable != null) {
            this.executable.dispose();
        }
        if (this.expert != null) {
            this.expert.dispose();
        }
        if (this.expertData != null) {
            this.expertData.dispose();
        }
        if (this.analysis != null) {
            this.analysis.dispose();
        }
        if (this.expertSystem != null) {
            this.expertSystem.dispose();
        }
        if (this.sourceLocator != null) {
            this.sourceLocator.dispose();
        }
        if (this.cudaFunctionManager != null) {
            this.cudaFunctionManager.dispose();
        }
        if (this.uvmManager != null) {
            this.uvmManager.dispose();
        }
        if (this.instantaneousMetricManager != null) {
            this.instantaneousMetricManager.dispose();
        }
        if (this.instantaneousEventManager != null) {
            this.instantaneousEventManager.dispose();
        }
        this.executable = null;
        this.expert = null;
        this.expertData = null;
        this.analysis = null;
        this.expertSystem = null;
        this.sourceLocator = null;
        this.cudaFunctionManager = null;
        this.uvmManager = null;
        this.instantaneousMetricManager = null;
        this.instantaneousEventManager = null;
        this.topLevelTimelines = null;
        this.allTimelines = null;
        this.allVisibleTimelines = null;
        this.timelineState = null;
        this.horizontalRuler = null;
        this.verticalRuler = null;
        this.allHighlighted = null;
        this.primarySelected = null;
        this.secondarySelected = null;
        this.allSelected = null;
        this.allSelectedIntervalIds = null;
        this.file = null;
        this.recentlyLoadedIntervals = null;
    }

    public String getRebelReportPath() {
        return this.rebelReportPath;
    }

    public void setRebelReportPath(String rebelReportPath) {
        this.rebelReportPath = rebelReportPath;
    }

    public boolean needProfilingDataDelete() {
        Executable exe = this.getExecutable();
        if (exe != null) {
            try {
                return exe.isTimestampChanged() && !this.getTimelines().isEmpty();
            }
            catch (ConnectionNotFoundException e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
        return false;
    }

    public boolean needToGenerateTimeline() {
        Executable exe = this.getExecutable();
        if (exe != null) {
            try {
                return exe.isTimestampChanged() || this.getTimelines().isEmpty();
            }
            catch (ConnectionNotFoundException e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
        return false;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtils.equals(name, this.name)) {
            this.name = name;
            this.dirty = true;
            this.firePropertyChange(PROPERTY_NAME);
        }
    }

    public TimelineColorMode getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(TimelineColorMode colorMode) {
        if (!this.colorMode.equals((Object)colorMode)) {
            TimelineColorMode oldMode = this.colorMode;
            this.colorMode = colorMode;
            this.setTimelineIntervalColors(oldMode, this.colorMode);
            this.firePropertyChange(PROPERTY_COLORMODE);
        }
    }

    public Object getFile() {
        return this.file;
    }

    public void setFile(Object file) {
        if (file == null && this.file != null || file != null && !file.equals(this.file)) {
            this.file = file;
            this.firePropertyChange(PROPERTY_FILE);
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public boolean isProfileAllProcesses() {
        return this.executable != null ? this.executable.isProfileAllProcesses() : false;
    }

    public void setExecutable(Executable executable) {
        if (this.executable != executable) {
            Executable oldExec = this.executable;
            if (oldExec != null) {
                oldExec.removeAllPropertyChangeListeners();
            }
            this.executable = executable;
            if (this.executable != null) {
                this.executable.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.dirty = true;
                        Session.this.firePropertyChange(Session.PROPERTY_EXECUTABLE);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_EXECUTABLE);
        }
    }

    public Expert getExpert() {
        return this.expert;
    }

    public void setExpert(Expert expert) {
        if (this.expert != expert) {
            Expert oldExpert = this.expert;
            if (oldExpert != null) {
                oldExpert.removeAllPropertyChangeListeners();
            }
            this.expert = expert;
            if (this.expert != null) {
                this.expert.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.dirty = true;
                        Session.this.firePropertyChange(Session.PROPERTY_EXPERT);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_EXPERT);
        }
    }

    public ExpertData getExpertData() {
        if (this.expertData == null) {
            this.expertData = new ExpertData(this);
            this.expertData.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                @Override
                public void propertyChange(IModel model, String propertyName) {
                    Session.this.firePropertyChange(Session.PROPERTY_EXPERTDATA);
                }
            });
        }
        return this.expertData;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    private void updateCriticalPathCache() {
        this.criticalPathCache = null;
        Analysis analysis = this.getAnalysis();
        if (analysis != null) {
            List<AnalysisResult> results = analysis.getAnalysisResults(AnalysisStage.DEPENDENCY_ANALYSIS);
            for (AnalysisResult result : results) {
                if (!(result instanceof AnalysisResultCriticalPath)) continue;
                this.criticalPathCache = ((AnalysisResultCriticalPath)result).getCriticalPath();
                break;
            }
        }
    }

    public void setAnalysis(Analysis analysis) {
        if (this.analysis != analysis) {
            Analysis oldAnalysis = this.analysis;
            if (oldAnalysis != null) {
                oldAnalysis.removeAllPropertyChangeListeners();
            }
            this.analysis = analysis;
            if (this.analysis != null) {
                this.analysis.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        if ("analysis:visited".equals(propertyName) || "analysis:guided".equals(propertyName) || "analysis:pciegen".equals(propertyName) || "analysis:pcielinkrate".equals(propertyName) || "analysis:pcielinkwidth".equals(propertyName)) {
                            Session.this.dirty = true;
                        }
                        Session.this.firePropertyChange(Session.PROPERTY_ANALYSIS);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_ANALYSIS);
        }
    }

    public ExpertSystem getExpertSystem() {
        return this.expertSystem;
    }

    public void setExpertSystem(ExpertSystem expertSystem) {
        if (this.expertSystem != expertSystem) {
            ExpertSystem oldExpertSystem = this.expertSystem;
            if (oldExpertSystem != null) {
                oldExpertSystem.removeAllPropertyChangeListeners();
            }
            this.expertSystem = expertSystem;
            if (this.expertSystem != null) {
                this.expertSystem.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.dirty = true;
                        Session.this.firePropertyChange(Session.PROPERTY_EXPERT_SYSTEM);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_EXPERT_SYSTEM);
        }
    }

    public SourceLocator getSourceLocator() {
        return this.sourceLocator;
    }

    public CudaFunctionManager getCudaFunctionManager() {
        return this.cudaFunctionManager;
    }

    public UvmManager getUvmManager() {
        return this.uvmManager;
    }

    public InstantaneousMetricManager getInstantaneousMetricManager() {
        return this.instantaneousMetricManager;
    }

    public InstantaneousEventManager getInstantaneousEventManager() {
        return this.instantaneousEventManager;
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        if (this.sourceLocator != sourceLocator) {
            this.sourceLocator = sourceLocator;
            this.dirty = true;
        }
    }

    public ProfileDataModel getPdm(String filename) throws ViperException {
        ProfileDataModel pdm = new ProfileDataModel(filename);
        try {
            this.sourceLocator.appendToPDM(pdm);
            this.cudaFunctionManager.appendToPDM(pdm);
            for (Timeline timeline : this.getTimelines()) {
                if (!timeline.getKind().appendsToPDM()) continue;
                timeline.appendToPDM(pdm);
            }
        }
        catch (ViperException e) {
            if (CUptiResult.CUPTI_ERROR_OUT_OF_MEMORY.name().equals(e.toString().trim())) {
                ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.OutOfMemoryWarning_Label, ViperMessages.OutOfMemorySaveWarning_Message);
            }
            throw e;
        }
        return pdm;
    }

    public TimelineDevice getDeviceTimeline(int deviceId) {
        List<Timeline> deviceTimelines = this.getTimelines(TimelineKind.DEVICE);
        for (Timeline timeline : deviceTimelines) {
            TimelineDevice deviceTimeline = (TimelineDevice)timeline;
            if (deviceTimeline.getId() != deviceId) continue;
            return deviceTimeline;
        }
        return null;
    }

    public String getDeviceName(int deviceId) {
        TimelineDevice deviceTimeline = this.getDeviceTimeline(deviceId);
        if (deviceTimeline != null) {
            return deviceTimeline.getName();
        }
        return null;
    }

    public List<Timeline> getVisibleTimelines() {
        if (this.allVisibleTimelines == null) {
            List<Timeline> timelines = this.getTimelines();
            this.allVisibleTimelines = new ArrayList<Timeline>(timelines.size());
            for (Timeline tl : timelines) {
                if (!tl.isVisible()) continue;
                this.allVisibleTimelines.add(tl);
            }
            this.allVisibleTimelines = Collections.unmodifiableList(this.allVisibleTimelines);
        }
        return this.allVisibleTimelines;
    }

    public List<Timeline> getTimelines() {
        if (this.allTimelines == null) {
            this.allTimelines = new LinkedList<Timeline>();
            for (Timeline tl : this.topLevelTimelines) {
                this.allTimelines.add(tl);
                this.collectDescendants(tl, this.allTimelines);
            }
            this.allTimelines = Collections.unmodifiableList(this.allTimelines);
        }
        return this.allTimelines;
    }

    public List<Timeline> getTopLevelTimelines() {
        return Collections.unmodifiableList(this.topLevelTimelines);
    }

    private void collectDescendants(Timeline parent, List<Timeline> tls) {
        for (Timeline child : parent.getChildren()) {
            tls.add(child);
            this.collectDescendants(child, tls);
        }
    }

    protected void clearAllTimelineList() {
        this.allTimelines = null;
    }

    protected void clearAllVisibleTimelineList() {
        this.allVisibleTimelines = null;
    }

    public List<Timeline> getTimelines(TimelineKind kind) {
        return this.getTimelines(Arrays.asList(kind));
    }

    public List<Timeline> getTimelines(Collection<TimelineKind> kinds) {
        ArrayList<Timeline> ctls = new ArrayList<Timeline>();
        for (Timeline tl : this.getTimelines()) {
            if (!kinds.contains((Object)tl.getKind())) continue;
            ctls.add(tl);
        }
        return ctls;
    }

    protected void initTimeline(Timeline timeline) {
        timeline.setSession(this);
        timeline.addPropertyChangeListener(new ISessionPropertyChangeListener(){

            @Override
            public void propertyChange(IModel model, String propertyName) {
                String propagatePropertyName = Session.PROPERTY_TIMELINE;
                if ("timeline:visible".equals(propertyName) || "timeline:filtered".equals(propertyName)) {
                    Session.this.handleVisibilityChange();
                } else if ("timeline:ievent".equals(propertyName)) {
                    if (Session.this.expertData != null) {
                        Session.this.expertData.refreshEvents();
                    }
                    Session.this.dirty = true;
                } else if ("timeline:imetric".equals(propertyName)) {
                    if (Session.this.expertData != null) {
                        Session.this.expertData.refreshMetrics();
                    }
                    Session.this.dirty = true;
                } else if ("timeline:children".equals(propertyName)) {
                    Session.this.clearAllTimelineList();
                    Session.this.clearAllVisibleTimelineList();
                    Session.this.setTimelineBackgroundColors();
                    propagatePropertyName = Session.PROPERTY_TIMELINES;
                    Session.this.dirty = true;
                }
                Session.this.firePropertyChange(propagatePropertyName);
            }
        });
        for (Timeline child : timeline.getChildren()) {
            this.initTimeline(child);
        }
    }

    public boolean addTopLevelTimeline(Timeline timeline, boolean update) {
        if (timeline.getParent() != null) {
            return false;
        }
        this.topLevelTimelines.add(timeline);
        this.initTimeline(timeline);
        this.dirty = true;
        this.clearAllTimelineList();
        this.clearAllVisibleTimelineList();
        if (update) {
            this.setTimelineBackgroundColors();
            if (this.expertData != null) {
                this.expertData.refreshAll();
            }
            this.firePropertyChange(PROPERTY_TIMELINES);
        }
        return true;
    }

    public boolean removeTopLevelTimeline(Timeline timeline, boolean update) {
        if (timeline.getParent() != null) {
            return false;
        }
        boolean removed = this.removeTimelineRec(timeline);
        removed &= this.topLevelTimelines.remove(timeline);
        this.clearAllTimelineList();
        this.clearAllVisibleTimelineList();
        this.dirty = true;
        if (update) {
            this.setTimelineBackgroundColors();
            if (this.expertData != null) {
                this.expertData.refreshAll();
            }
            this.firePropertyChange(PROPERTY_TIMELINES);
        }
        return removed;
    }

    private boolean removeTimelineRec(Timeline timeline) {
        boolean removed = true;
        timeline.removeAllPropertyChangeListeners();
        for (Timeline child : timeline.getChildren()) {
            removed &= this.removeTimelineRec(child);
            timeline.removeChild(child);
        }
        timeline.dispose();
        return removed;
    }

    public void setTimelines(ProfileDataModel profileDataModel) throws ViperException {
        this.initTimeline();
        final TimelineFactory[] factory = new TimelineFactory[1];
        if (profileDataModel != null) {
            factory[0] = new TimelineFactory(profileDataModel, this, true);
            this.timelineFactory = factory[0];
            this.updateMaxHorizontalScale();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session.this.createTimelines(factory[0]);
                }
                catch (ViperException e) {
                    ViperExceptionHandler.handle(ViperMessages.LoadPdm_Fail_Title, ViperMessages.LoadPdm_Fail_Message, e);
                }
            }
        });
    }

    public void recreateTimelines() throws ViperException {
        this.uvmManager.clearCpuPageFaults();
        List<ProfileDataModel> pdms = this.getTimelinePdms();
        this.setTimelines(null);
        if (pdms.size() == 1) {
            this.setTimelines(pdms.get(0));
        } else if (pdms.size() > 1) {
            this.setTimelinesMultiplePdms(pdms.toArray(new ProfileDataModel[pdms.size()]));
        }
    }

    public void initTimeline() {
        if (this.cudaFunctionManager != null) {
            this.cudaFunctionManager.resetForNewTimeline();
        }
        if (this.uvmManager != null) {
            this.uvmManager.resetForNewTimeline();
        }
        this.timelineFocusMode = TimelineFocusMode.NONE.value;
        this.earliestTime = -1L;
        this.idToAuxIdMap.clear();
        this.idToEndIdMap.clear();
        this.recentlyLoadedIntervals.clear();
        this.openAccSummaryMap.clear();
        this.openMPSummaryMap.clear();
        this.summaryViewDefaultProcess = 0;
    }

    public void setTimelinesMultiplePdms(ProfileDataModel[] pdms) throws ViperException {
        TimelineFactory factory;
        this.initTimeline();
        this.timelineFactory = factory = new TimelineFactory(pdms, this, true);
        this.updateMaxHorizontalScale();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session.this.createTimelines(factory);
                }
                catch (ViperException e) {
                    ViperExceptionHandler.handle(ViperMessages.LoadPdm_Fail_Title, ViperMessages.LoadPdm_Fail_Message, e);
                }
            }
        });
    }

    private void createTimelines(TimelineFactory factory) throws ViperException {
        ArrayList<Timeline> rtimelines = new ArrayList<Timeline>(this.topLevelTimelines);
        this.topLevelTimelines.clear();
        this.clearAllTimelineList();
        this.clearAllVisibleTimelineList();
        this.pdmSize = -1;
        this.startCorrelationId = -1L;
        this.endCorrelationId = -1L;
        this.firePropertyChange(PROPERTY_TIMELINE_RESET);
        this.firePropertyChange(PROPERTY_SESSION);
        for (Timeline tl : rtimelines) {
            this.removeTopLevelTimeline(tl, false);
        }
        try {
            if (!this.topLevelTimelines.isEmpty() || this.timelineState == null) {
                this.timelineState = new TimelineState();
            }
            this.setPrimaryAndSecondarySelected(null, null, false, true);
            if (this.analysis != null) {
                this.analysis.resetForNewTimeline();
            }
            if (this.expertSystem != null) {
                this.expertSystem.resetForNewTimeline();
            }
            if (this.sourceLocator != null) {
                this.sourceLocator.resetForNewTimeline();
            }
            if (factory != null) {
                ModelWithProperties.disableAllNotifications();
                factory.createTimelines(this);
                for (Timeline tl : this.getTimelines()) {
                    tl.processIntervalMins();
                }
            }
            this.timelinesCreated = true;
            this.timelineState.apply();
            this.setTimelineIntervalColors(this.colorMode, this.colorMode);
            this.clearAllTimelineList();
            this.clearAllVisibleTimelineList();
            this.setTimelineBackgroundColors();
            if (this.expertData != null) {
                this.expertData.refreshAll();
            }
            if (!this.topLevelTimelines.isEmpty() && this.analysis != null) {
                this.analysis.setVisitedStage(AnalysisStage.TIMELINE, null, true);
            }
        }
        finally {
            if (factory != null) {
                ModelWithProperties.enableAllNotifications();
            }
        }
        this.firePropertyChange(PROPERTY_SESSION);
        this.firePropertyChange(PROPERTY_TIMELINES);
    }

    public boolean mergeTimelines(ProfileDataModel profileDataModel, SessionFilter scope, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults) throws ViperException {
        boolean completeMerge = true;
        if (profileDataModel != null) {
            TimelineFactory factory = new TimelineFactory(profileDataModel, this, false);
            completeMerge = factory.merge(this, scope, mergeEvents, mergeMetrics, mergeSourceLevelResults, profileDataModel);
            boolean addedNvlink = this.timelineFactory.addNvlinkTimelines(this, factory);
            if (addedNvlink) {
                this.reloadTimelines();
            }
            if (completeMerge) {
                this.timelineFactory.addAnalysisPdm(profileDataModel);
            }
            if (this.expertData != null) {
                if (mergeEvents) {
                    this.expertData.refreshEvents();
                }
                if (mergeMetrics) {
                    this.expertData.refreshMetrics();
                }
            }
        }
        return completeMerge;
    }

    private Color nextTimelineBackgroundColor() {
        Color next = this.currentTimelineBGColor;
        this.currentTimelineBGColor = this.currentTimelineBGColor.equals((Object)ViperColors.TIMELINE_BGCOLOR_0) ? ViperColors.TIMELINE_BGCOLOR_1 : ViperColors.TIMELINE_BGCOLOR_0;
        return next;
    }

    private void setTimelineBackgroundColors() {
        this.currentTimelineBGColor = ViperColors.TIMELINE_BGCOLOR_0;
        List<Timeline> bgtimelines = this.getVisibleTimelines();
        for (Timeline tl : bgtimelines) {
            tl.setBackgroundColor(this.nextTimelineBackgroundColor());
        }
    }

    protected void setTimelineIntervalColors(TimelineColorMode oldColorMode, TimelineColorMode newColorMode) {
        block22: {
            List<Timeline> colorTimelines;
            Object tls;
            this.processIdToColorMap.clear();
            this.streamIdToColorMap.clear();
            this.kernelNameToColorMap.clear();
            ArrayList<Timeline> containerTimelines = new ArrayList<Timeline>();
            List<Timeline> deviceTimelines = this.getTimelines(TimelineKind.DEVICE);
            for (Timeline device : deviceTimelines) {
                List<Timeline> contextTimelines = device.getDescendants(TimelineKind.CONTEXT);
                if (contextTimelines.isEmpty()) {
                    containerTimelines.add(device);
                    continue;
                }
                containerTimelines.addAll(contextTimelines);
            }
            List<Timeline> processes = null;
            int numColors = 0;
            if (newColorMode.equals((Object)TimelineColorMode.PROCESS)) {
                processes = this.getTimelines(TimelineKind.PROCESS);
                numColors = processes.size();
            } else {
                for (Timeline container : containerTimelines) {
                    if (newColorMode == TimelineColorMode.STREAM) {
                        List<Timeline> tls2 = container.getDescendants(TimelineKind.STREAM);
                        numColors = Math.max(numColors, tls2.size());
                        continue;
                    }
                    if (newColorMode != TimelineColorMode.KERNEL) continue;
                    HashSet<String> kernelNames = new HashSet<String>();
                    tls = container.getDescendants(TimelineKind.KERNEL);
                    Iterator iterator = tls.iterator();
                    while (iterator.hasNext()) {
                        Timeline tl = (Timeline)iterator.next();
                        kernelNames.add(tl.getName());
                    }
                    numColors = Math.max(numColors, kernelNames.size());
                }
            }
            if (this.timelineIntervalColors == null || this.timelineIntervalColors.length < numColors) {
                if (this.timelineIntervalColors != null) {
                    tls = this.timelineIntervalColors;
                    int kernelNames = this.timelineIntervalColors.length;
                    int n = 0;
                    while (n < kernelNames) {
                        Object color = tls[n];
                        ((ViperColors.GradientColors)color).dispose();
                        ++n;
                    }
                }
                List<ViperColors.GradientColors> colors = ViperColors.getGradientColors(numColors, ViperColors.INTERVAL_KERNEL_COLORTHEME);
                this.timelineIntervalColors = colors.toArray(new ViperColors.GradientColors[0]);
            }
            if (oldColorMode.equals((Object)TimelineColorMode.STREAM) || oldColorMode.equals((Object)TimelineColorMode.PROCESS)) {
                colorTimelines = this.getTimelines(Arrays.asList(TimelineKind.MEMCPY_DTOH, TimelineKind.MEMCPY_HTOD, TimelineKind.MEMCPY_DTOD, TimelineKind.MEMCPY_PTOP));
                for (Timeline tl : colorTimelines) {
                    tl.setIntervalColors(null);
                }
            }
            if (oldColorMode.equals((Object)TimelineColorMode.PROCESS)) {
                colorTimelines = this.getTimelines(Arrays.asList(TimelineKind.UVM_MEMCPY_HTOD, TimelineKind.UVM_MEMCPY_DTOH, TimelineKind.UVM_PAGE_FAULT, TimelineKind.UVM_GPU_PAGE_FAULT));
                for (Timeline t1 : colorTimelines) {
                    t1.setIntervalColors(null);
                }
            }
            if (numColors <= 0 || this.timelineIntervalColors.length <= 0) break block22;
            if (newColorMode == TimelineColorMode.PROCESS) {
                List<Timeline> uvms = this.getTimelines(Arrays.asList(TimelineKind.UVM_MEMCPY_DTOH, TimelineKind.UVM_MEMCPY_HTOD, TimelineKind.UVM_PAGE_FAULT, TimelineKind.UVM_GPU_PAGE_FAULT));
                int idx = 0;
                int stride = this.timelineIntervalColors.length / numColors;
                for (Timeline process : processes) {
                    if (!(process instanceof TimelineProcess)) continue;
                    int processId = ((TimelineProcess)process).getId();
                    this.processIdToColorMap.put(processId, this.timelineIntervalColors[idx]);
                    for (Timeline uvm : uvms) {
                        if (!(uvm instanceof TimelineUVM)) continue;
                        ((TimelineUVM)uvm).setIntervalColors(processId, this.timelineIntervalColors[idx]);
                    }
                    idx += stride;
                }
            } else {
                for (Timeline container : containerTimelines) {
                    if (newColorMode == TimelineColorMode.STREAM) {
                        List<Timeline> tls3 = container.getDescendants(TimelineKind.STREAM);
                        int idx = 0;
                        int stride = this.timelineIntervalColors.length / numColors;
                        for (Timeline tl : tls3) {
                            TimelineStream streamTl = (TimelineStream)tl;
                            this.streamIdToColorMap.put(streamTl.getId(), this.timelineIntervalColors[idx]);
                            idx += stride;
                        }
                        continue;
                    }
                    if (newColorMode != TimelineColorMode.KERNEL) continue;
                    List<Timeline> tls4 = container.getDescendants(TimelineKind.KERNEL);
                    int idx = 0;
                    int stride = this.timelineIntervalColors.length / numColors;
                    for (Timeline tl : tls4) {
                        String kernelName = tl.getName();
                        if (this.kernelNameToColorMap.containsKey(kernelName)) continue;
                        this.kernelNameToColorMap.put(kernelName, this.timelineIntervalColors[idx]);
                        idx += stride;
                    }
                }
            }
        }
    }

    public long getDuration() {
        if (this.normalizeIndependent) {
            return this.timelineFactory.getMaxDurationAcrossPdm();
        }
        return this.latestTime - this.earliestTime;
    }

    public long getVisibleDuration() {
        if (this.timelineFactory == null) {
            return this.getDuration();
        }
        if (this.normalizeIndependent) {
            return this.timelineFactory.getMaxDurationAcrossPdm();
        }
        if (this.isEnableTimeRange()) {
            return this.latestTime - this.timelineFactory.getSessionStart();
        }
        return this.getDuration();
    }

    public TimelineRuler getHorizontalRuler() {
        return this.horizontalRuler;
    }

    public void setHorizontalRuler(TimelineRuler horizontalRuler) {
        if (this.horizontalRuler != horizontalRuler) {
            TimelineRuler oldHr = this.horizontalRuler;
            if (oldHr != null) {
                oldHr.removeAllPropertyChangeListeners();
            }
            this.horizontalRuler = horizontalRuler;
            if (this.horizontalRuler != null) {
                this.horizontalRuler.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.firePropertyChange(Session.PROPERTY_HRULER);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_HRULER);
        }
    }

    public VerticalRuler getVerticalRuler() {
        return this.verticalRuler;
    }

    public void setVerticalRuler(VerticalRuler verticalRuler) {
        if (this.verticalRuler != verticalRuler) {
            VerticalRuler oldVr = this.verticalRuler;
            if (oldVr != null) {
                oldVr.removeAllPropertyChangeListeners();
            }
            this.verticalRuler = verticalRuler;
            if (this.verticalRuler != null) {
                this.verticalRuler.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.dirty = true;
                        Session.this.firePropertyChange(Session.PROPERTY_VRULER);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_VRULER);
        }
    }

    public double getHorizontalScale() {
        return this.horizontalScale;
    }

    public void setHorizontalScale(double hScale, boolean updateTimeline) {
        if (hScale > 0.0 && hScale != this.horizontalScale) {
            this.horizontalScale = Math.min(this.maxHorizontalScale, hScale);
            this.dirty = true;
            this.firePropertyChange(PROPERTY_HORIZONTAL_SCALE);
            if (updateTimeline) {
                this.reloadTimelines();
            }
        }
    }

    protected void updateMaxHorizontalScale() {
        this.maxHorizontalScale = this.getVisibleDuration() > 0L ? 1.073741823E9 / (double)this.getDuration() : 1.0E-6;
        if (this.horizontalScale > this.maxHorizontalScale) {
            this.setHorizontalScale(this.maxHorizontalScale, true);
        }
    }

    public int getHorizontalReveal() {
        return this.horizontalReveal;
    }

    public void setHorizontalReveal(int horizontalReveal) {
        this.horizontalReveal = horizontalReveal;
        this.firePropertyChange(PROPERTY_HORIZONTAL_REVEAL);
    }

    public void setXPosition(int xPosition) {
        if (this.xPosition != xPosition) {
            this.xPosition = xPosition;
            this.firePropertyChange(PROPERTY_X_POSITION);
            this.reloadTimelines();
        }
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.firePropertyChange(PROPERTY_WIDTH);
            this.reloadTimelines();
        }
    }

    public int getXPosition() {
        return this.xPosition;
    }

    public int getVerticalReveal() {
        return this.verticalReveal;
    }

    public void setVerticalReveal(int verticalReveal) {
        this.verticalReveal = verticalReveal;
        this.firePropertyChange(PROPERTY_VERTICAL_REVEAL);
    }

    public void revealTimelineInterval(TimelineIntervalPair pair) {
        Timeline timeline = pair.getTimeline();
        if (timeline != null) {
            int Y = 0;
            for (Timeline tl : this.getVisibleTimelines()) {
                if (tl.equals(timeline)) break;
                Y += TimelineFigure.getScaledTimelineHeight(tl);
            }
            this.setVerticalReveal(Y);
            this.setVerticalReveal(Y + TimelineFigure.getScaledTimelineHeight(timeline));
            ITimelineInterval interval = pair.getInterval(this);
            if (interval != null) {
                int startX = (int)Math.round(this.horizontalScale * (double)interval.getStart());
                int endX = (int)Math.round(this.horizontalScale * (double)interval.getExtendedEnd());
                this.setHorizontalReveal(startX);
                this.setHorizontalReveal(endX);
            }
        }
    }

    public TimelineIntervalPair getPrimaryHighlighted() {
        return this.primaryHighlighted;
    }

    public Collection<TimelineIntervalPair> getHighlighted() {
        if (this.allHighlighted == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.allHighlighted);
    }

    public void setPrimaryHighlighted(TimelineIntervalPair highlight) {
        boolean needsUpdate = true;
        if (this.primaryHighlighted == null) {
            if (highlight == null) {
                needsUpdate = false;
            }
        } else if (this.primaryHighlighted.equals(highlight)) {
            needsUpdate = false;
        }
        if (needsUpdate) {
            this.primaryHighlighted = highlight;
            if (this.primaryHighlighted != null && this.primaryHighlighted.getInterval(this) == null && this.primaryHighlighted.getTimeline() == null) {
                this.primaryHighlighted = null;
            }
            if (this.isShowDependencies()) {
                this.updateDependenciesHighlightIntervals();
            } else {
                this.updateCorrelatedHighlightIntervals();
            }
            this.firePropertyChange(PROPERTY_HIGHLIGHT_INTERVAL);
        }
    }

    public TimelineIntervalPair getPrimarySelected() {
        return this.primarySelected;
    }

    public Collection<TimelineIntervalPair> getSecondarySelected() {
        if (this.secondarySelected == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.secondarySelected);
    }

    public Collection<TimelineIntervalPair> getAllSelected() {
        if (this.allSelected == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.allSelected);
    }

    public Collection<Long> getAllSelectedIntervalIds() {
        if (this.allSelectedIntervalIds == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.allSelectedIntervalIds);
    }

    public void setPrimarySelected(TimelineIntervalPair selected, boolean setAnalysisInterval) {
        boolean p;
        boolean bl = this.primarySelected == null ? selected == null : (p = this.primarySelected.equals(selected));
        if (!p) {
            this.setPrimaryAndSecondarySelected(selected, null, false, setAnalysisInterval);
        }
    }

    private void selectCorrelations() {
        TimelineIntervalPair[] pairs;
        TimelineIntervalPair[] timelineIntervalPairArray = pairs = this.allSelected.toArray(new TimelineIntervalPair[0]);
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            TimelineIntervalPair pair = timelineIntervalPairArray[n2];
            ITimelineInterval interval = pair.getInterval(this);
            if (interval instanceof TimelineIntervalHierarchy) {
                TimelineIntervalHierarchy hier = (TimelineIntervalHierarchy)interval;
                HashSet<TimelineIntervalHierarchy> family = new HashSet<TimelineIntervalHierarchy>();
                hier.getAncestors(family);
                hier.getDescendants(family);
                this.getCorrelatedIntervals(hier, family);
                for (TimelineIntervalHierarchy f : family) {
                    this.allSelected.add(new TimelineIntervalPair(f.getPrimaryTimeline(), f));
                    if (this.allSelectedIntervalIds == null) {
                        this.allSelectedIntervalIds = new HashSet<Long>();
                    }
                    this.allSelectedIntervalIds.add(f.getID());
                }
            }
            ++n2;
        }
    }

    private void selectDependencies() {
        TimelineIntervalPair[] pairs;
        TimelineIntervalPair[] timelineIntervalPairArray = pairs = this.allSelected.toArray(new TimelineIntervalPair[0]);
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            TimelineIntervalPair pair = timelineIntervalPairArray[n2];
            ITimelineInterval interval = pair.getInterval(this);
            Set<ITimelineInterval> dependencies = this.getIntervalDependencies(interval);
            for (ITimelineInterval dependency : dependencies) {
                if (dependency == interval) continue;
                this.allSelected.add(new TimelineIntervalPair(dependency.getPrimaryTimeline(), dependency));
                if (this.allSelectedIntervalIds == null) {
                    this.allSelectedIntervalIds = new HashSet<Long>();
                }
                this.allSelectedIntervalIds.add(dependency.getID());
            }
            ++n2;
        }
    }

    public void setPrimaryAndSecondarySelected(TimelineIntervalPair primary, Collection<TimelineIntervalPair> secondary, boolean selectCorrelated, boolean setAnalysisInterval) {
        this.primarySelected = primary;
        if (this.primarySelected != null && this.primarySelected.getInterval(this) == null && this.primarySelected.getTimeline() == null) {
            this.primarySelected = null;
        }
        if (this.primarySelected == null) {
            this.secondarySelected = null;
            this.allSelected = null;
            this.allSelectedIntervalIds = null;
        } else {
            this.secondarySelected = null;
            this.allSelected = new HashSet<TimelineIntervalPair>();
            this.allSelected.add(this.primarySelected);
            this.allSelectedIntervalIds = null;
            if (this.primarySelected.getInterval(this) != null) {
                this.allSelectedIntervalIds = new HashSet<Long>();
                this.allSelectedIntervalIds.add(this.primarySelected.getInterval(this).getID());
            }
            if (secondary != null) {
                for (TimelineIntervalPair sec : secondary) {
                    if (sec == null || sec.getInterval(this) == null && sec.getTimeline() == null) continue;
                    if (this.secondarySelected == null) {
                        this.secondarySelected = new HashSet<TimelineIntervalPair>();
                    }
                    this.secondarySelected.add(sec);
                    this.allSelected.add(sec);
                    if (sec.getInterval(this) == null) continue;
                    if (this.allSelectedIntervalIds == null) {
                        this.allSelectedIntervalIds = new HashSet<Long>();
                    }
                    this.allSelectedIntervalIds.add(sec.getInterval(this).getID());
                }
            }
            if (selectCorrelated) {
                if (this.isShowDependencies()) {
                    this.selectDependencies();
                } else {
                    this.selectCorrelations();
                }
            }
        }
        if (this.expertData != null) {
            this.expertData.refreshIntervals();
        }
        if (setAnalysisInterval && this.analysis != null) {
            this.analysis.setActiveScopeInterval(this.primarySelected == null ? null : this.primarySelected.getInterval(this));
        }
        this.firePropertyChange(PROPERTY_SELECTED_INTERVAL);
    }

    private void getCorrelatedIntervals(TimelineIntervalHierarchy interval, Set<TimelineIntervalHierarchy> correlatedIntervals) {
        TimelineIntervalHierarchy oldsetAncestor = interval.getOldestAncestor();
        HashSet<TimelineIntervalHierarchy> allDescendants = new HashSet<TimelineIntervalHierarchy>();
        oldsetAncestor.getDescendants(allDescendants);
        for (TimelineIntervalHierarchy child : allDescendants) {
            if (!child.isCorrelated(interval.getCorrelationIds())) continue;
            correlatedIntervals.add(child);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private void updateHighlightAddToTimelines() {
        ITimelineInterval interval = this.primaryHighlighted.getInterval(this);
        ICuptiActivity activity = interval == null ? null : this.timelineFactory.getActivity(interval.getID());
        ArrayList<Timeline> timelines = null;
        if (activity != null) {
            try {
                timelines = this.timelineFactory.createAndReturnTimelines(activity, null);
            }
            catch (ViperException viperException) {
                ViperExceptionHandler.logError("Can't get related timelines");
            }
        }
        if (timelines != null) {
            for (Timeline tl : timelines) {
                tl.addIntervalForceUnderLock(interval);
            }
        }
    }

    protected void updateDependenciesHighlightIntervals() {
        if (this.primaryHighlighted == null) {
            this.allHighlighted = null;
        } else {
            this.updateHighlightAddToTimelines();
            ITimelineInterval primaryInterval = this.primaryHighlighted.getInterval(this);
            this.allHighlighted = new HashSet<TimelineIntervalPair>();
            if (primaryInterval != null) {
                Set<ITimelineInterval> dependencies = this.getIntervalDependencies(primaryInterval);
                for (ITimelineInterval interval : dependencies) {
                    this.allHighlighted.add(new TimelineIntervalPair(interval.getPrimaryTimeline(), interval));
                }
            } else {
                this.allHighlighted.add(this.primaryHighlighted);
            }
        }
    }

    protected void updateCorrelatedHighlightIntervals() {
        if (this.primaryHighlighted == null) {
            this.allHighlighted = null;
        } else {
            this.updateHighlightAddToTimelines();
            ITimelineInterval interval = this.primaryHighlighted.getInterval(this);
            this.allHighlighted = new HashSet<TimelineIntervalPair>();
            this.allHighlighted.add(this.primaryHighlighted);
            HashSet<TimelineIntervalHierarchy> family = new HashSet<TimelineIntervalHierarchy>();
            if (interval instanceof TimelineIntervalKernel || interval instanceof TimelineIntervalMemset || interval instanceof TimelineIntervalMemcpy) {
                interval = ((TimelineIntervalHierarchy)interval).getParent();
            }
            if (interval instanceof TimelineIntervalAPI && ((TimelineIntervalHierarchy)interval).getParent() != null) {
                interval = ((TimelineIntervalHierarchy)interval).getParent();
            }
            if (interval instanceof TimelineIntervalAPI || interval instanceof TimelineIntervalOpenAcc) {
                TimelineIntervalHierarchy hostInterval = (TimelineIntervalHierarchy)interval;
                TimelineIntervalHierarchy oldest = hostInterval.getOldestAncestor();
                family.add(oldest);
                this.getHostLaunchedDescendants(oldest, family);
            }
            for (TimelineIntervalHierarchy f : family) {
                this.allHighlighted.add(new TimelineIntervalPair(f.getPrimaryTimeline(), f));
            }
        }
    }

    public void getHostLaunchedDescendants(TimelineIntervalHierarchy interval, Collection<TimelineIntervalHierarchy> hostLaunchedDescendants) {
        HashSet<TimelineIntervalHierarchy> descendants = new HashSet<TimelineIntervalHierarchy>();
        interval.getDescendants(descendants);
        for (TimelineIntervalHierarchy child : descendants) {
            TimelineIntervalKind childKind = child.getKind();
            if (!childKind.equals((Object)TimelineIntervalKind.DRIVER) && !childKind.equals((Object)TimelineIntervalKind.OPENACC) && !childKind.equals((Object)TimelineIntervalKind.KERNEL) && !childKind.equals((Object)TimelineIntervalKind.MEMSET) && !childKind.equals((Object)TimelineIntervalKind.MEMCPY_DTOD) && !childKind.equals((Object)TimelineIntervalKind.MEMCPY_DTOH) && !childKind.equals((Object)TimelineIntervalKind.MEMCPY_HTOD) && !childKind.equals((Object)TimelineIntervalKind.MEMCPY_PTOP) || !(child.getParent() instanceof TimelineIntervalAPI) && !(child.getParent() instanceof TimelineIntervalOpenAcc)) continue;
            hostLaunchedDescendants.add(child);
        }
    }

    public void unfocusAllTimelines() {
        for (Timeline compute : this.getTimelines(TimelineKind.KERNELS)) {
            compute.refreshDescendantVisibility(true);
        }
        this.firePropertyChange(PROPERTY_UNFOCUS_TIMELINES);
    }

    public void focusOnIntervals(Collection<ITimelineInterval> focusIntervals) {
        if (focusIntervals != null) {
            HashMap<Timeline, Collection<ITimelineInterval>> timelines = new HashMap<Timeline, Collection<ITimelineInterval>>();
            for (ITimelineInterval interval : focusIntervals) {
                if (interval.getPrimaryTimeline() == null) continue;
                this.addTimelineFocusInterval(timelines, interval.getPrimaryTimeline(), interval);
                if (!(interval instanceof TimelineIntervalHierarchy)) continue;
                HashSet<TimelineIntervalHierarchy> family = new HashSet<TimelineIntervalHierarchy>();
                ((TimelineIntervalHierarchy)interval).getAncestors(family);
                ((TimelineIntervalHierarchy)interval).getDescendants(family);
                for (TimelineIntervalHierarchy f : family) {
                    TimelineIntervalHierarchy fi = f;
                    Timeline ft = fi.getPrimaryTimeline();
                    if (ft == null) continue;
                    this.addTimelineFocusInterval(timelines, ft, fi);
                }
            }
            for (Timeline timeline : this.getTimelines()) {
                if (timelines.containsKey(timeline) || !(timeline instanceof TimelineKernel)) continue;
                timeline.setVisible(false);
            }
            HashSet<Timeline> allTimelines = new HashSet<Timeline>(timelines.keySet());
            block3: for (Timeline timeline : timelines.keySet()) {
                Timeline parent = timeline.getParent();
                while (parent != null) {
                    if (allTimelines.contains(parent)) continue block3;
                    allTimelines.add(parent);
                    parent = parent.getParent();
                }
            }
            this.focusOnTimelines(this.getTopLevelTimelines(), allTimelines);
        }
    }

    private void addTimelineFocusInterval(Map<Timeline, Collection<ITimelineInterval>> map, Timeline timeline, ITimelineInterval interval) {
        Collection<ITimelineInterval> intervals = map.get(timeline);
        if (intervals == null) {
            intervals = new HashSet<ITimelineInterval>();
            map.put(timeline, intervals);
        }
        intervals.add(interval);
    }

    private void focusOnTimelines(Collection<Timeline> visitTimelines, Collection<Timeline> revealTimelines) {
        for (Timeline visit : visitTimelines) {
            block3: {
                block4: {
                    ContainerState cState;
                    block6: {
                        block5: {
                            if (!revealTimelines.contains(visit)) break block3;
                            if (!visit.isContainer()) break block4;
                            cState = ContainerState.CLOSED;
                            if (!TimelineKind.CONTEXT.equals((Object)visit.getKind())) break block5;
                            if (ContainerState.CLOSED.equals((Object)visit.getContainerState())) break block6;
                            cState = visit.getContainerState();
                            break block6;
                        }
                        for (Timeline child : visit.getChildren()) {
                            if (!revealTimelines.contains(child)) continue;
                            cState = ContainerState.OPEN_ALL;
                            break;
                        }
                    }
                    visit.setContainerState(cState);
                }
                if (visit.getKind().isFilterable()) {
                    visit.setFiltered(false);
                }
                this.focusOnTimelines(visit.getChildren(), revealTimelines);
                continue;
            }
            if (!visit.isContainer() || TimelineKind.STREAMS.equals((Object)visit.getKind())) continue;
            visit.setContainerState(ContainerState.CLOSED);
        }
    }

    private void handleVisibilityChange() {
        this.clearAllVisibleTimelineList();
        this.setTimelineBackgroundColors();
        if (this.expertData != null) {
            this.expertData.refreshIntervals();
        }
        this.dirty = true;
    }

    public void fireGlobalVisibilityChange() {
        this.handleVisibilityChange();
        this.firePropertyChange(PROPERTY_TIMELINE);
    }

    public void fireProgressCancel() {
        this.firePropertyChange(PROPERTY_PROGRESS_CANCEL);
    }

    public boolean selectAnalyzedKernel() {
        Set<Long> kernels = this.kernelIDMap.keySet();
        HashSet<TimelineIntervalPair> set = null;
        if (kernels != null) {
            for (Long id : kernels) {
                ITimelineInterval interval = this.loadInterval(id, false);
                if (!(interval instanceof TimelineIntervalKernel)) continue;
                TimelineIntervalKernel kernel = (TimelineIntervalKernel)interval;
                TimelineIntervalPair pair = new TimelineIntervalPair(kernel.getPrimaryTimeline(), kernel);
                if (set == null) {
                    set = new HashSet<TimelineIntervalPair>();
                }
                set.add(pair);
            }
        }
        if (set != null && !set.isEmpty()) {
            ArrayList allPairs = new ArrayList(set);
            TimelineIntervalPair primary = (TimelineIntervalPair)allPairs.get(0);
            List<TimelineIntervalPair> secondary = allPairs.subList(1, allPairs.size());
            this.setPrimaryAndSecondarySelected(primary, secondary, false, true);
            return true;
        }
        return false;
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            List<ProfileDataModel> analysisPdms;
            List<ProfileDataModel> timelinePdms;
            w.write("<session version=\"" + this.version + "\"");
            if (this.name != null) {
                w.write(" name=\"" + XmlUtil.escapeString((String)this.name) + "\"");
            }
            w.write(" hscale=\"" + this.horizontalScale + "\"");
            w.write(" normalize=\"" + this.normalizeIndependent + "\"");
            w.write(">\n");
            if (this.timelineOptions != null) {
                this.timelineOptions.write(w);
            }
            if (this.executable != null) {
                this.executable.write(w);
            }
            if (this.expert != null) {
                this.expert.write(w);
            }
            if (this.analysis != null) {
                this.analysis.write(w);
            }
            if (this.expertSystem != null) {
                this.expertSystem.write(w);
            }
            if (this.verticalRuler != null) {
                this.verticalRuler.write(w);
            }
            if (this.horizontalRuler != null) {
                this.horizontalRuler.write(w);
            }
            if (this.timelineState != null) {
                this.timelineState.write(w);
            }
            if (this.timelineFactory != null) {
                timelinePdms = this.timelineFactory.getTimelinePdms();
                analysisPdms = this.timelineFactory.getAnalysisPdms();
            } else {
                timelinePdms = null;
                analysisPdms = null;
                if (this.cpuFile != null) {
                    w.write("<timelinepdm>\n");
                    ProfileDataModel.writeFile(w, this.cpuFile, null, null);
                    w.write("</timelinepdm>\n");
                }
            }
            if (timelinePdms != null) {
                this.writePdms(w, timelinePdms, "timelinepdm");
            }
            if (analysisPdms != null) {
                this.writePdms(w, analysisPdms, "analysispdm");
            }
            this.writeRebelReports(w);
            w.write("</session>\n");
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    public Session cloneSession() {
        Session newSession = new Session();
        this.clone(newSession);
        return newSession;
    }

    private void mergeTimelinesWithScopes(ProfileDataModel pdm) throws ViperException {
        List<SessionFilter> sessionFilters = pdm.getMergeScopes();
        if (sessionFilters != null && !sessionFilters.isEmpty()) {
            for (SessionFilter sessionFilter : sessionFilters) {
                this.mergeTimelines(pdm, sessionFilter, true, true, true);
            }
        } else {
            this.mergeTimelines(pdm, null, true, true, true);
        }
    }

    public void clone(Session newSession) {
        try {
            List<ProfileDataModel> timelinePdms;
            int numPdms;
            if (this.getName().endsWith(Viper.SESSION_FILE_EXT)) {
                String sessionNameWithoutExt = this.getName().substring(0, this.getName().length() - Viper.SESSION_FILE_EXT.length());
                newSession.setName(String.valueOf(sessionNameWithoutExt) + "-clone");
            } else {
                newSession.setName(String.valueOf(this.getName()) + "-clone");
            }
            newSession.setHorizontalScale(this.horizontalScale, true);
            if (this.getCpuTree(CpuTreeView.modes.CODE_STRUCTURE) != null) {
                newSession.setCpuTree(this.getCpuTree(CpuTreeView.modes.CODE_STRUCTURE).clone(), CpuTreeView.modes.CODE_STRUCTURE);
            }
            if (this.getCpuTree(CpuTreeView.modes.TOP_DOWN) != null) {
                newSession.setCpuTree(this.getCpuTree(CpuTreeView.modes.TOP_DOWN).clone(), CpuTreeView.modes.TOP_DOWN);
            }
            if (this.getCpuTree(CpuTreeView.modes.BOTTOM_UP) != null) {
                newSession.setCpuTree(this.getCpuTree(CpuTreeView.modes.BOTTOM_UP).clone(), CpuTreeView.modes.BOTTOM_UP);
            }
            newSession.cpuSourceBaseDir = this.cpuSourceBaseDir;
            if (this.executable != null) {
                newSession.setExecutable(new Executable(this.getXmlElement(this.executable)));
            }
            if (this.expert != null) {
                newSession.setExpert(new Expert(this.getXmlElement(this.expert)));
            }
            if (this.verticalRuler != null) {
                newSession.setVerticalRuler(new VerticalRuler(newSession, this.getXmlElement(this.verticalRuler)));
            }
            if (this.horizontalRuler != null) {
                newSession.setHorizontalRuler(new TimelineRuler(newSession, this.getXmlElement(this.horizontalRuler)));
            }
            if (this.timelineState != null) {
                Session session = newSession;
                session.getClass();
                newSession.timelineState = session.new TimelineState(this.getXmlElement(this.timelineState));
            }
            if ((numPdms = (timelinePdms = this.timelineFactory.getTimelinePdms()).size()) > 1) {
                ProfileDataModel[] pdms = new ProfileDataModel[numPdms];
                File[] files = new File[numPdms];
                int i = 0;
                while (i < numPdms) {
                    File file;
                    files[i] = file = new File(timelinePdms.get(i).getPdmFilePath());
                    ProfileDataModel pdm = new ProfileDataModel();
                    pdm.read(file);
                    pdms[i] = pdm;
                    ++i;
                }
                newSession.setTimelinesMultiplePdms(pdms);
            } else if (numPdms == 1) {
                ProfileDataModel tlpdm = new ProfileDataModel();
                File file = new File(timelinePdms.get(0).getPdmFilePath());
                tlpdm.read(file);
                newSession.setTimelines(tlpdm);
                for (ProfileDataModel pdm : this.timelineFactory.getAnalysisPdms()) {
                    ProfileDataModel newPdm = new ProfileDataModel();
                    newPdm.read(new File(pdm.getPdmFilePath()));
                    newPdm.setScope(pdm);
                    newPdm.setNullSourceLevelResults(pdm);
                    newSession.mergeTimelinesWithScopes(newPdm);
                }
            }
            if (this.analysis != null) {
                newSession.setAnalysis(new Analysis(this.getXmlElement(this.analysis)));
            }
            if (this.expertSystem != null) {
                newSession.setExpertSystem(new ExpertSystem(newSession, this.getXmlElement(this.expertSystem)));
            }
            if (!newSession.topLevelTimelines.isEmpty() && newSession.analysis != null) {
                newSession.analysis.setVisitedStage(AnalysisStage.TIMELINE, null, true);
            }
        }
        catch (Exception e2) {
            ViperException e2;
            if (!(e2 instanceof ViperException)) {
                e2 = new ViperException(e2);
            }
            ViperExceptionHandler.handle(ViperMessages.Clone_Fail_Title, ViperMessages.Clone_Fail_Message, e2);
        }
    }

    public int getNumTimelinePdms() {
        List<ProfileDataModel> timelinePdms;
        if (this.timelineFactory != null && (timelinePdms = this.timelineFactory.getTimelinePdms()) != null) {
            return timelinePdms.size();
        }
        return 0;
    }

    public List<ProfileDataModel> getTimelinePdms() {
        if (this.timelineFactory != null) {
            return this.timelineFactory.getTimelinePdms();
        }
        return null;
    }

    private Element getXmlElement(ISessionSerializable model) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        BufferedWriter writer = new BufferedWriter(osw);
        model.write(writer);
        writer.flush();
        writer.close();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        String xml = new String(bout.toByteArray(), "UTF-8");
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        return doc.getDocumentElement();
    }

    private void writePdms(Writer w, List<ProfileDataModel> pdmList, String tagName) throws ViperException, IOException {
        w.write("<" + tagName + ">\n");
        for (ProfileDataModel pdm : pdmList) {
            pdm.write(w);
        }
        w.write("</" + tagName + ">\n");
    }

    protected void read(Element el) throws ViperException {
        NodeList pdmList;
        Element pdmElement;
        block67: {
            block66: {
                if (!"session".equals(el.getTagName())) {
                    throw new ViperException("expected \"session\" tag, got " + el.getTagName());
                }
                try {
                    this.version = Integer.parseInt(el.getAttribute("version"));
                    this.setName(StringUtils.emptyToNull(el.getAttribute("name")));
                    this.setHorizontalScale(Double.parseDouble(el.getAttribute("hscale")), true);
                    this.setNormalizeIndependently(Boolean.parseBoolean(el.getAttribute("normalize")));
                }
                catch (NumberFormatException e) {
                    throw new ViperException("unable to parse version, name, or hscale", e);
                }
                NodeList tlOptions = el.getElementsByTagName("timelineoptions");
                switch (tlOptions.getLength()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.timelineOptions = new TimelineOptions((Element)tlOptions.item(0));
                        break;
                    }
                    default: {
                        throw new ViperException("expected 0 or 1 <vruler> tags, got " + tlOptions.getLength());
                    }
                }
                NodeList execList = el.getElementsByTagName("executable");
                switch (execList.getLength()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.setExecutable(new Executable((Element)execList.item(0)));
                        break;
                    }
                    default: {
                        throw new ViperException("expected 0 or 1 <executable> tags, got " + execList.getLength());
                    }
                }
                NodeList expertList = el.getElementsByTagName("expert");
                switch (expertList.getLength()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.setExpert(new Expert((Element)expertList.item(0)));
                        break;
                    }
                    default: {
                        throw new ViperException("expected 0 or 1 <expert> tags, got " + expertList.getLength());
                    }
                }
                NodeList vrulerList = el.getElementsByTagName("vruler");
                switch (vrulerList.getLength()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.setVerticalRuler(new VerticalRuler(this, (Element)vrulerList.item(0)));
                        break;
                    }
                    default: {
                        throw new ViperException("expected 0 or 1 <vruler> tags, got " + vrulerList.getLength());
                    }
                }
                NodeList hrulerList = el.getElementsByTagName("hruler");
                switch (hrulerList.getLength()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.setHorizontalRuler(new TimelineRuler(this, (Element)hrulerList.item(0)));
                        break;
                    }
                    default: {
                        throw new ViperException("expected 0 or 1 <hruler> tags, got " + hrulerList.getLength());
                    }
                }
                NodeList tlList = el.getElementsByTagName("timelinestate");
                switch (tlList.getLength()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.timelineState = new TimelineState((Element)tlList.item(0));
                        break;
                    }
                    default: {
                        throw new ViperException("expected 0 or 1 <timelines> tags, got " + tlList.getLength());
                    }
                }
                if (this.version < 2) break block66;
                NodeList tlPdmList = el.getElementsByTagName("timelinepdm");
                switch (tlPdmList.getLength()) {
                    case 0: {
                        break block67;
                    }
                    case 1: {
                        pdmElement = (Element)tlPdmList.item(0);
                        pdmList = pdmElement.getElementsByTagName("pdm");
                        if (pdmList.getLength() == 1) {
                            try {
                                ProfileDataModel pdm = new ProfileDataModel(this, (Element)pdmList.item(0));
                                this.setTimelines(pdm);
                            }
                            catch (OutOfMemoryError e) {
                                ViperExceptionHandler.logError("Out of memory error", e);
                                LargeDataMessageDialog.show();
                            }
                            catch (ViperException viperException) {}
                        } else if (pdmList.getLength() > 1) {
                            ProfileDataModel[] pdms = new ProfileDataModel[pdmList.getLength()];
                            int i = 0;
                            while (i < pdmList.getLength()) {
                                ProfileDataModel pdm;
                                pdms[i] = pdm = new ProfileDataModel(this, (Element)pdmList.item(i));
                                ++i;
                            }
                            try {
                                this.setTimelinesMultiplePdms(pdms);
                            }
                            catch (OutOfMemoryError e) {
                                ViperExceptionHandler.logError("Out of memory error", e);
                                LargeDataMessageDialog.show();
                            }
                        }
                        break block67;
                    }
                    default: {
                        throw new ViperException("expected 0 or 1 <timelinepdm> tags, got " + tlPdmList.getLength());
                    }
                }
            }
            NodeList pdmList2 = el.getElementsByTagName("pdm");
            switch (pdmList2.getLength()) {
                case 0: {
                    break;
                }
                case 1: {
                    ProfileDataModel pdm = new ProfileDataModel(this, (Element)pdmList2.item(0));
                    try {
                        this.setTimelines(pdm);
                    }
                    catch (OutOfMemoryError e) {
                        ViperExceptionHandler.logError("Out of memory error", e);
                        LargeDataMessageDialog.show();
                    }
                    break;
                }
                default: {
                    throw new ViperException("expected 0 or 1 <pdm> tags, got " + pdmList2.getLength());
                }
            }
        }
        if (this.version >= 2) {
            NodeList analysisPdmList = el.getElementsByTagName("analysispdm");
            switch (analysisPdmList.getLength()) {
                case 0: {
                    break;
                }
                case 1: {
                    pdmElement = (Element)analysisPdmList.item(0);
                    pdmList = pdmElement.getElementsByTagName("pdm");
                    int i = 0;
                    while (i < pdmList.getLength()) {
                        ProfileDataModel pdm = new ProfileDataModel(this, (Element)pdmList.item(i));
                        this.mergeTimelinesWithScopes(pdm);
                        ++i;
                    }
                    break;
                }
                default: {
                    throw new ViperException("expected 0 or 1 <timelinepdm> tags, got " + analysisPdmList.getLength());
                }
            }
        }
        NodeList rebelReportList = el.getElementsByTagName("rebelreport");
        switch (rebelReportList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Element reportElement = (Element)rebelReportList.item(0);
                NodeList reportList = reportElement.getElementsByTagName("report");
                int i = 0;
                while (i < reportList.getLength()) {
                    this.extractReportFile((Element)reportList.item(i));
                    ++i;
                }
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <timelinepdm> tags, got " + rebelReportList.getLength());
            }
        }
        NodeList analysisList = el.getElementsByTagName("analysis");
        switch (analysisList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                this.setAnalysis(new Analysis((Element)analysisList.item(0)));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <analysis> tags, got " + analysisList.getLength());
            }
        }
        NodeList expertSystemList = el.getElementsByTagName("expertsystem");
        switch (expertSystemList.getLength()) {
            case 0: {
                if (this.analysis == null) break;
                this.setExpertSystem(new ExpertSystem(this));
                break;
            }
            case 1: {
                this.setExpertSystem(new ExpertSystem(this, (Element)expertSystemList.item(0)));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <expertsystem> tags, got " + expertSystemList.getLength());
            }
        }
        if (!this.topLevelTimelines.isEmpty() && this.analysis != null) {
            this.analysis.setVisitedStage(AnalysisStage.TIMELINE, null, true);
        }
    }

    private void extractReportFile(Element el) {
        String strScope = StringUtils.emptyToNull(el.getAttribute("scope"));
        try {
            int length;
            SessionFilter scope = Viper.deserialize(strScope, SessionFilter.class);
            String str = el.getTextContent();
            byte[] data = DatatypeConverter.parseBase64Binary((String)str);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            GZIPInputStream zStream = new GZIPInputStream(inputStream);
            IPath path = TemporaryDirs.temp.newSubfolder();
            path = path.append("temp" + Viper.REBEL_COMMAND_LINE_EXT);
            String tempFile = path.toOSString();
            FileOutputStream out = new FileOutputStream(tempFile);
            int chunk = 8192;
            byte[] buffer = new byte[chunk];
            while ((length = zStream.read(buffer, 0, chunk)) != -1) {
                out.write(buffer, 0, length);
            }
            out.close();
            zStream.close();
            ((InputStream)inputStream).close();
            this.addRebelReport(scope, tempFile);
        }
        catch (ViperException | IOException e) {
            ViperExceptionHandler.handle("Session Open Failed", "Could not open " + Viper.REBEL_PRODUCT_NAME + "report file", e);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getLabel() {
        return this.getName();
    }

    public long getStartCorrelationId() {
        return this.startCorrelationId;
    }

    public void setStartCorrelationId(long startCorrelationId) {
        this.startCorrelationId = startCorrelationId;
    }

    public long getEndCorrelationId() {
        return this.endCorrelationId;
    }

    public void setEndCorrelationId(long endCorrelationId) {
        this.endCorrelationId = endCorrelationId;
    }

    public int getPdmSize() {
        return this.pdmSize;
    }

    public void setPdmSize(int size) {
        this.pdmSize = size;
    }

    public synchronized void waitForLoadTimelines() {
        for (Thread th : this.tlRefreshThreads) {
            if (th == null) continue;
            try {
                th.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadTimelines() {
        if (this.width == 0) {
            return;
        }
        if (this.timelineFactory == null) {
            return;
        }
        double startNS = (double)this.xPosition / this.horizontalScale;
        double endNS = startNS + (double)this.width / this.horizontalScale;
        Session session = this;
        synchronized (session) {
            Thread current = this.tlRefreshThreads.peekLast();
            if (current != null) {
                current.interrupt();
            }
            Iterator itr = this.tlRefreshThreads.iterator();
            while (itr.hasNext()) {
                Thread th = (Thread)itr.next();
                if (th != null && th.isAlive()) continue;
                itr.remove();
            }
            TimelineRefreshThread newThread = new TimelineRefreshThread(this.timelineFactory, startNS, endNS, this.width);
            this.tlRefreshThreads.addLast(newThread);
            this.fireStartLoading(DATANAME_TIMELINE);
            newThread.start();
        }
    }

    public void startEventRefresh() {
        if (!this.timelinesCreated()) {
            return;
        }
        if (this.etRefreshThread != null) {
            this.stopEventRefresh();
        }
        this.etRefreshThread = new EventRefreshThread("Event Refresh");
        this.fireStartLoading(DATANAME_METRIC);
        this.etRefreshThread.start();
    }

    public void stopEventRefresh() {
        if (this.etRefreshThread != null) {
            this.etRefreshThread.interrupt();
            while (true) {
                try {
                    this.etRefreshThread.join();
                    this.etRefreshThread = null;
                }
                catch (InterruptedException e) {
                    ViperExceptionHandler.logError("interrupt at stop refresh thread join", e);
                    continue;
                }
                break;
            }
        }
    }

    public void setTimeRange(long earliestTime, long latestTime, ProfileDataModel pdm) {
        if (earliestTime >= 0L && (earliestTime < this.earliestTime || this.earliestTime < 0L)) {
            this.earliestTime = earliestTime;
        }
        this.setLatestTime(latestTime);
        if (this.pdmTimeRangeMap.containsKey(pdm)) {
            TimeRange range = this.pdmTimeRangeMap.get(pdm);
            if (earliestTime >= 0L && earliestTime < range.earliestTime) {
                range.earliestTime = earliestTime;
            }
            if (latestTime >= 0L && latestTime > range.latestTime) {
                range.latestTime = latestTime;
            }
        } else if (earliestTime >= 0L) {
            if (latestTime >= 0L) {
                this.pdmTimeRangeMap.put(pdm, new TimeRange(earliestTime, latestTime));
            } else {
                this.pdmTimeRangeMap.put(pdm, new TimeRange(earliestTime, 0L));
            }
        }
    }

    public long getEarliestTime(ProfileDataModel pdm) {
        if (this.normalizeIndependent && this.pdmTimeRangeMap.containsKey(pdm)) {
            return this.pdmTimeRangeMap.get(pdm).earliestTime;
        }
        return this.earliestTime;
    }

    public long getEarliestTime() {
        return this.earliestTime;
    }

    public void setLatestTime(long latestTime) {
        if (latestTime > this.latestTime) {
            this.latestTime = latestTime;
        }
    }

    public long getLatestTime() {
        return this.latestTime;
    }

    public long getLatestTime(ProfileDataModel pdm) {
        if (this.normalizeIndependent && this.pdmTimeRangeMap.containsKey(pdm)) {
            return this.pdmTimeRangeMap.get(pdm).latestTime;
        }
        return this.latestTime;
    }

    public long getSessionStartTime(ITimelineInterval interval) {
        if (this.timelineFactory != null) {
            ProfileDataModel pdm = this.timelineFactory.getPdm(interval.getID());
            return this.getSessionStartTime(pdm);
        }
        return -1L;
    }

    public long getSessionStartTime(ProfileDataModel pdm) {
        if (this.normalizeIndependent && pdm != null && this.pdmTimeRangeMap.containsKey(pdm)) {
            return this.pdmTimeRangeMap.get(pdm).earliestTime;
        }
        if (this.timelineFactory != null) {
            return this.timelineFactory.getSessionStart();
        }
        return -1L;
    }

    public long getSessionStartTime() {
        if (this.timelineFactory != null) {
            return this.timelineFactory.getSessionStart();
        }
        return -1L;
    }

    public ICuptiActivity getActivity(long id) {
        return this.timelineFactory.getActivity(id);
    }

    public void addEvent(Event event) {
        this.eventSet.add(event);
    }

    public Set<Event> getEvents() {
        return this.eventSet;
    }

    public void addAggregatedMetric(Metric metric) {
        this.aggregatedMetricSet.add(metric);
    }

    public Set<Metric> getAggregatedMetrics() {
        return this.aggregatedMetricSet;
    }

    public boolean timelinesCreated() {
        return this.timelinesCreated;
    }

    public int getProcessId(ITimelineInterval interval) {
        int procId = -1;
        List<Timeline> apiTimelines = this.getTimelines(Arrays.asList(TimelineKind.RUNTIME, TimelineKind.DRIVER, TimelineKind.OPENACC));
        for (Timeline timeline : apiTimelines) {
            long[] intervalIds;
            long[] lArray = intervalIds = timeline.getIntervalIds();
            int n = intervalIds.length;
            int n2 = 0;
            while (n2 < n) {
                long id = lArray[n2];
                ICuptiActivity activity = this.getActivity(id);
                if (activity instanceof CuptiActivityAPI) {
                    CuptiActivityAPI activityApi = (CuptiActivityAPI)activity;
                    HashSet<Integer> correlationId = new HashSet<Integer>();
                    correlationId.add(activityApi.correlationId);
                    if (interval.isCorrelated(correlationId)) {
                        procId = activityApi.processId;
                        break;
                    }
                }
                if (activity instanceof CuptiActivityOpenAcc) {
                    CuptiActivityOpenAcc activityOpenAcc = (CuptiActivityOpenAcc)activity;
                    if (interval.isCorrelated(activityOpenAcc.correlations)) {
                        procId = activityOpenAcc.cuProcessId;
                        break;
                    }
                }
                ++n2;
            }
            if (procId != -1) break;
        }
        return procId;
    }

    public long getEndId(long id) {
        Long result = this.idToEndIdMap.get(id);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public void setEndId(long id, long endId) {
        this.idToEndIdMap.put(id, endId);
    }

    public long getAuxId(long id) {
        Long result = this.idToAuxIdMap.get(id);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public void setAuxId(long id, long auxId) {
        this.idToAuxIdMap.put(id, auxId);
    }

    public ITimelineInterval getLoadedInterval(long id) {
        return this.recentlyLoadedIntervals.get(id);
    }

    public void setLoadedInterval(ITimelineInterval interval) {
        this.recentlyLoadedIntervals.put(interval.getID(), interval);
    }

    public void reset() {
        this.setPrimaryAndSecondarySelected(null, null, true, true);
        this.getExpertSystem().setCurrentStageKind(ExpertSystemStageKind.INTRO);
        if (this.getExecutable() != null) {
            try {
                this.setTimelines(null);
            }
            catch (ViperException viperException) {
                ViperExceptionHandler.logError("unable to clear timelines");
            }
        }
        this.kernelIDMap.clear();
        this.idToAuxIdMap.clear();
        this.idToEndIdMap.clear();
        this.timelinesCreated = false;
        this.eventSet.clear();
        this.aggregatedMetricSet.clear();
        this.instantaneousMetricManager.reset();
        this.instantaneousEventManager.reset();
        if (this.scopeReportMap != null && !this.scopeReportMap.isEmpty()) {
            this.scopeReportMap.clear();
        }
        this.expertData = null;
        this.firePropertyChange(PROPERTY_EXPERTDATA);
    }

    public void resetKernelAnalyses() {
        this.getExpertSystem().setCurrentStageKind(ExpertSystemStageKind.INTRO);
        TimelineIntervalKernel kernel = AnalysisStage.getAnalysisHostLaunchedKernel(this);
        if (kernel == null) {
            return;
        }
        this.kernelIDMap.remove(kernel.getID());
        kernel.clearAllAnalysis();
        this.getExpertData().refreshAll();
        this.firePropertyChange(PROPERTY_EXPERTDATA);
    }

    public void resetAllAnalyses() {
        this.getExpertSystem().setCurrentStageKind(ExpertSystemStageKind.INTRO);
        this.kernelIDMap.clear();
        this.idToAuxIdMap.clear();
        this.idToEndIdMap.clear();
        this.eventSet.clear();
        this.aggregatedMetricSet.clear();
        this.instantaneousMetricManager.reset();
        this.instantaneousEventManager.reset();
        if (this.scopeReportMap != null && !this.scopeReportMap.isEmpty()) {
            this.scopeReportMap.clear();
        }
        this.getExpertData().refreshAll();
        this.firePropertyChange(PROPERTY_EXPERTDATA);
    }

    public CallTree getCpuTree(CpuTreeView.modes mode) {
        return this.cpuTree[mode.ordinal()];
    }

    public void setCpuTree(CallTree c, CpuTreeView.modes mode) {
        this.cpuTree[mode.ordinal()] = c;
    }

    public void setNormalizeIndependently(boolean normalize) {
        this.normalizeIndependent = normalize;
    }

    public boolean isNormalizeIndependently() {
        return this.normalizeIndependent;
    }

    public void setSamplingPeriod(double period) {
        this.samples.setSamplingPeriod(period);
    }

    public void importNvprofCpuData(String databaseFile) {
        this.cpuFile = databaseFile;
        CallTree cpuTree = NativeXutils.profGraphSelect(this, databaseFile, CpuTreeView.modes.CODE_STRUCTURE.ordinal());
        cpuTree.setCumulativeHits();
        cpuTree.setFunctionShadowHits();
        cpuTree.populateCodeStructureTree(this.samples);
        cpuTree.accumulateAndCalcStats();
        cpuTree.getFunctionShadow().accumulateAndCalcStats();
        this.setCpuTree(cpuTree, CpuTreeView.modes.CODE_STRUCTURE);
        cpuTree = NativeXutils.profGraphSelect(this, databaseFile, CpuTreeView.modes.TOP_DOWN.ordinal());
        cpuTree.setCumulativeHits();
        cpuTree.setFunctionShadowHits();
        cpuTree.accumulateAndCalcStats();
        cpuTree.getFunctionShadow().accumulateAndCalcStats();
        this.setCpuTree(cpuTree, CpuTreeView.modes.TOP_DOWN);
        cpuTree = NativeXutils.profGraphSelect(this, databaseFile, CpuTreeView.modes.BOTTOM_UP.ordinal());
        cpuTree.setCumulativeHits();
        cpuTree.setFunctionShadowHits();
        cpuTree.accumulateAndCalcStats();
        cpuTree.getFunctionShadow().accumulateAndCalcStats();
        this.setCpuTree(cpuTree, CpuTreeView.modes.BOTTOM_UP);
        this.samples.sumTotalThreads();
        NativeXutils.profGetMessages(this, databaseFile);
        if (this.cpuSourceBaseDir == null) {
            this.cpuSourceBaseDir = new Path(databaseFile).removeLastSegments(1);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CpuTreeView view = (CpuTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.nvidia.viper.cpuview");
                if (view != null) {
                    Session.this.currentThread = CallTree.getTotalThread();
                    view.openDefaultTree(Session.this.getCpuTree(CpuTreeView.modes.BOTTOM_UP), Session.this);
                }
            }
        });
    }

    public void setSamples(CpuSampleInfo samples) {
        this.samples = samples;
    }

    public IPath getCpuSourceBaseDir() {
        if (this.cpuSourceBaseDir != null) {
            return this.cpuSourceBaseDir;
        }
        return Path.ROOT;
    }

    public void setCpuSourceBaseDir(String path) {
        this.cpuSourceBaseDir = path == null ? null : new Path(path);
    }

    public void focusCriticalPathTimeline(boolean focus) {
        if (focus) {
            Set<ITimelineInterval> intervals;
            CriticalPath cp = this.getCriticalPath();
            if (cp != null && (intervals = cp.getIntervalsOnCriticalPath(this)) != null && !intervals.isEmpty()) {
                ArrayList<TimelineIntervalPair> allPairs = new ArrayList<TimelineIntervalPair>();
                for (ITimelineInterval interval : intervals) {
                    allPairs.add(new TimelineIntervalPair(interval.getPrimaryTimeline(), interval));
                }
                TimelineIntervalPair primary = (TimelineIntervalPair)allPairs.get(0);
                List<TimelineIntervalPair> secondary = allPairs.subList(1, allPairs.size());
                this.setPrimaryAndSecondarySelected(primary, secondary, false, true);
            }
        } else {
            this.setPrimaryAndSecondarySelected(null, null, false, false);
        }
    }

    public void focusFilteredUvmIntervals(boolean focus) {
        if (focus) {
            if (this.uvmManager.getFilteredUvmIntervalIds() != null && !this.uvmManager.getFilteredUvmIntervalIds().isEmpty()) {
                ArrayList<TimelineIntervalPair> allPairs = new ArrayList<TimelineIntervalPair>();
                for (Long intervalId : this.uvmManager.getFilteredUvmIntervalIds()) {
                    ITimelineInterval interval = this.loadInterval(intervalId, false);
                    allPairs.add(new TimelineIntervalPair(interval.getPrimaryTimeline(), interval));
                }
                TimelineIntervalPair primary = (TimelineIntervalPair)allPairs.get(0);
                List<TimelineIntervalPair> secondary = allPairs.subList(1, allPairs.size());
                this.setPrimaryAndSecondarySelected(primary, secondary, false, false);
            }
        } else {
            this.setPrimaryAndSecondarySelected(null, null, false, false);
        }
    }

    public int getTimelineFocusMode() {
        return this.timelineFocusMode;
    }

    public void setTimelineFocusMode(TimelineFocusMode timelineFocusMode, boolean isSetMode) {
        this.timelineFocusMode = isSetMode ? (this.timelineFocusMode |= timelineFocusMode.value) : (this.timelineFocusMode &= ~timelineFocusMode.value);
    }

    public boolean isDrawOnFilteredUvmIntervals(Long intervalId) {
        if (this.isUvmFilterEnabled() && this.uvmManager.getFilteredUvmIntervalIds() != null) {
            return this.uvmManager.getFilteredUvmIntervalIds().contains(intervalId);
        }
        return false;
    }

    public CriticalPath getCriticalPath() {
        return this.criticalPathCache;
    }

    public boolean isDrawOnCriticalPath(ITimelineInterval interval) {
        CriticalPath cp;
        if (this.isShowCriticalPath() && (cp = this.getCriticalPath()) != null) {
            Set<ITimelineInterval> intervals = cp.getIntervalsOnCriticalPath(this);
            return intervals.contains(interval);
        }
        return false;
    }

    public boolean isShowDependencies() {
        return (this.timelineFocusMode & TimelineFocusMode.DEPENDENCY.value) != 0;
    }

    public final Set<ITimelineInterval> getIntervalDependencies(ITimelineInterval interval) {
        HashSet<ITimelineInterval> result;
        block10: {
            result = new HashSet<ITimelineInterval>();
            long[] chironIds = null;
            try {
                long pdm = this.getTimelinePdms().get(0).getNativeHandle();
                NativeChiron.ParadigmKind kind = NativeChiron.ParadigmKind.ParadigmCuda;
                long nativeId = interval.getID();
                if (interval instanceof TimelineIntervalPThread) {
                    kind = NativeChiron.ParadigmKind.ParadigmPThread;
                    nativeId = ((TimelineIntervalPThread)interval).getPThreadId();
                }
                if ((chironIds = NativeChiron.getConnectedActivities(pdm, kind.getCode(), nativeId)) == null) break block10;
                long[] lArray = chironIds;
                int n = chironIds.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        long chironId = lArray[n2];
                        long[] activityInfo = NativeChiron.getActivityInfo(pdm, chironId);
                        if (activityInfo == null || activityInfo.length < 2) {
                            ViperExceptionHandler.logError("NativeChiron.getActivityInfo failed");
                        } else {
                            ITimelineInterval dependency;
                            long paradigmIntervalId;
                            NativeChiron.ParadigmKind paradigm = NativeChiron.ParadigmKind.valueOf((int)activityInfo[0]);
                            long finalId = paradigmIntervalId = activityInfo[1];
                            if (paradigm == NativeChiron.ParadigmKind.ParadigmPThread) {
                                try {
                                    finalId = this.timelineFactory.getPThreadIntervalId(paradigmIntervalId);
                                }
                                catch (ViperException e) {
                                    ViperExceptionHandler.logError(e.getMessage());
                                    break block11;
                                }
                            }
                            if ((dependency = this.getLoadedInterval(finalId)) != null) {
                                result.add(dependency);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (ChironException e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
        result.add(interval);
        return result;
    }

    public boolean isShowCriticalPath() {
        return (this.timelineFocusMode & TimelineFocusMode.CRITICAL_PATH.value) != 0;
    }

    public CpuThread getCurrentThread() {
        return this.currentThread;
    }

    public boolean isUvmFilterEnabled() {
        return (this.timelineFocusMode & TimelineFocusMode.UVM_FILTER.value) != 0;
    }

    public void addInstantaneousEvent(CuptiActivityEvent event) {
        this.instantaneousEventManager.addEvent(event);
    }

    public void addInstantaneousMetric(CuptiActivityMetric metric) {
        this.instantaneousMetricManager.addMetric(metric);
    }

    public CpuSampleInfo getSamples() {
        return this.samples;
    }

    public HashMap<String, List<CCFFMessage>> getMessagesMap() {
        return this.messagesMap;
    }

    public void setCurrentThread(CpuThread thread) {
        this.currentThread = thread;
    }

    public void addThread(CpuThread thread) {
        this.allThreads.add(thread);
    }

    public Iterator<CpuThread> iteratorAllThread() {
        return this.allThreads.iterator();
    }

    public TreePath[] getCpuTreeState(CpuTreeView.modes mode) {
        return this.cpuTreeState[mode.ordinal()];
    }

    public void setCpuTreeState(CpuTreeView.modes mode, TreePath[] cpuTreeState) {
        this.cpuTreeState[mode.ordinal()] = cpuTreeState;
    }

    public void setNumSegmentsUVM(int num) {
        this.timelineOptions.numSegmentsUVM = num;
    }

    public int getNumSegmentsUVM() {
        return this.timelineOptions.numSegmentsUVM;
    }

    public void setIsUVMSegmentEnabled(boolean enable) {
        this.timelineOptions.uvmSegmentEnabled = enable;
    }

    public boolean isUVMSegmentEnabled() {
        return this.timelineOptions.uvmSegmentEnabled;
    }

    public void enableTimeline(TimelineKind kind, boolean enable) {
        this.timelineOptions.enableTimeline(kind, enable);
    }

    public boolean isTimelineDisabled(TimelineKind kind) {
        if (this.timelineOptions.disabledTimelines == null) {
            return false;
        }
        return this.timelineOptions.disabledTimelines.contains((Object)kind);
    }

    public Set<TimelineKind> getDisabledTimeline() {
        return this.timelineOptions.disabledTimelines;
    }

    public void setEnableTimeRange(boolean enable) {
        this.timelineOptions.enableTimeRange = enable;
    }

    public boolean isEnableTimeRange() {
        return this.timelineOptions.enableTimeRange;
    }

    public void setTimelineStart(long start) {
        this.timelineOptions.start = start;
    }

    public void setTimelineEnd(long end) {
        this.timelineOptions.end = end;
    }

    public long getTimelineStart() {
        return this.timelineOptions.start * 1000000L;
    }

    public long getTimelineEnd() {
        return this.timelineOptions.end * 1000000L;
    }

    public void addAggregatedOpenACC(CuptiActivityOpenAcc openAcc) throws ViperException {
        this.openAccSummary.findAggregate(openAcc);
    }

    public void setOpenAccTotalTime(int id, long openAccTotalTime) {
        this.openAccSummaryMap.get(id).setTotalTime(openAccTotalTime);
    }

    public boolean isNVLinkTopologyPresent() {
        List<ProfileDataModel> timelinePdms = this.getTimelinePdms();
        if (timelinePdms != null && !timelinePdms.isEmpty()) {
            ProfileDataModel pdm = timelinePdms.get(0);
            return pdm.nvLinks != null && !pdm.nvLinks.isEmpty();
        }
        return false;
    }

    public boolean isProfileInRebel() {
        FileSystem fileSystem;
        Executable executable = this.getExecutable();
        if (executable != null && (fileSystem = executable.getFileSystem()) != null) {
            try {
                IDevicesData deviceData = fileSystem.getDeviceData(false);
                if (deviceData != null) {
                    return deviceData.isTuringOrOnwardFound();
                }
            }
            catch (ViperException | DeviceListNotReadyException e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
        int major = -1;
        int minor = -1;
        boolean profileInRebel = false;
        List<Timeline> deviceTimelines = this.getTimelines(TimelineKind.DEVICE);
        for (Timeline timeline : deviceTimelines) {
            TimelineDevice deviceTimeline = (TimelineDevice)timeline;
            major = deviceTimeline.getComputeCapabilityMajor();
            if (!Viper.isTuringAndOnward(major, minor = deviceTimeline.getComputeCapabilityMinor())) continue;
            profileInRebel = true;
            break;
        }
        return profileInRebel;
    }

    public void setPCSamplingPeriod(int samplingPeriod) {
        this.samplingPeriod = samplingPeriod;
    }

    public int getPCSamplingPeriod() {
        return this.samplingPeriod;
    }

    public OpenAccSummary getOpenAccSummary(int process) {
        OpenAccSummary summary = this.openAccSummaryMap.get(new Integer(process));
        if (summary == null) {
            summary = new OpenAccSummary(this);
            this.openAccSummaryMap.put(new Integer(process), summary);
            if (this.summaryViewDefaultProcess == 0) {
                this.summaryViewDefaultProcess = process;
            }
        }
        return summary;
    }

    public OpenMPSummary getOpenMPSummary(int process) {
        OpenMPSummary summary = this.openMPSummaryMap.get(new Integer(process));
        if (summary == null) {
            summary = new OpenMPSummary(this);
            this.openMPSummaryMap.put(new Integer(process), summary);
            if (this.summaryViewDefaultProcess == 0) {
                this.summaryViewDefaultProcess = process;
            }
        }
        return summary;
    }

    public int getSummaryViewDefaultProcess() {
        return this.summaryViewDefaultProcess;
    }

    public void addRebelReport(SessionFilter filter, String path) {
        if (this.scopeReportMap == null) {
            this.scopeReportMap = new HashMap<SessionFilter, String>();
        }
        this.scopeReportMap.put(filter, path);
        if (!this.isDirty()) {
            this.setDirty(true);
        }
    }

    public String getRebelReport(SessionFilter filter) {
        if (this.scopeReportMap != null) {
            for (Map.Entry<SessionFilter, String> entry : this.scopeReportMap.entrySet()) {
                if (!filter.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private void writeRebelReports(Writer w) throws IOException, ViperException {
        if (this.scopeReportMap != null && !this.scopeReportMap.isEmpty()) {
            String tagName = "rebelreport";
            w.write("<" + tagName + ">\n");
            for (Map.Entry<SessionFilter, String> entry : this.scopeReportMap.entrySet()) {
                this.writeReportFile(w, entry.getKey(), entry.getValue());
            }
            w.write("</" + tagName + ">\n");
        }
    }

    private void writeReportFile(Writer w, SessionFilter scope, String reportPath) throws IOException, ViperException {
        int bytes_read;
        w.write("<report");
        String strScope = Viper.serialize(scope);
        w.write(" scope=\"" + strScope + "\"");
        w.write(">");
        FileInputStream inputStream = new FileInputStream(reportPath);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream zStream = new GZIPOutputStream(outputStream);
        byte[] buffer = new byte[8192];
        while ((bytes_read = inputStream.read(buffer)) != -1) {
            zStream.write(buffer, 0, bytes_read);
        }
        inputStream.close();
        zStream.close();
        String str = DatatypeConverter.printBase64Binary((byte[])outputStream.toByteArray());
        w.write(str);
        w.write("</report>\n");
    }

    static /* synthetic */ boolean access$2(Session session) {
        return session.etThreadRunning;
    }

    static /* synthetic */ void access$6(Session session, boolean bl) {
        session.tlThreadRunning = bl;
    }

    private class EventRefreshThread
    extends Thread {
        public EventRefreshThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                try {
                    Session.this.threadsControl.lock();
                    while (Session.this.tlThreadRunning) {
                        Session.this.tlThreadFinished.await();
                    }
                    Session.this.etThreadRunning = true;
                }
                catch (InterruptedException interruptedException) {
                    Session.this.fireStopLoading(Session.DATANAME_METRIC);
                    Session.this.threadsControl.unlock();
                    return;
                }
            }
            finally {
                Session.this.threadsControl.unlock();
            }
            Session.this.expertData.refreshData();
            Session.this.fireStopLoading(Session.DATANAME_METRIC);
            Session.this.threadsControl.lock();
            Session.this.etThreadRunning = false;
            Session.this.etThreadFinished.signalAll();
            Session.this.threadsControl.unlock();
        }
    }

    class TimeRange {
        private long earliestTime;
        private long latestTime;

        TimeRange(long earliestTime, long latestTime) {
            this.earliestTime = earliestTime;
            this.latestTime = latestTime;
        }
    }

    public static enum TimelineFocusMode {
        CRITICAL_PATH(1),
        DEPENDENCY(2),
        UVM_FILTER(4),
        NONE(0);

        public int value;

        private TimelineFocusMode(int value) {
            this.value = value;
        }
    }

    class TimelineOptions {
        private Set<TimelineKind> disabledTimelines;
        private boolean enableTimeRange = false;
        private long start = -1L;
        private long end = -1L;
        private int numSegmentsUVM = UVM_NUM_SEGMENT_DEFAULT;
        private boolean uvmSegmentEnabled = true;

        public TimelineOptions() {
        }

        public TimelineOptions(Element el) throws ViperException {
            if (!"timelineoptions".equals(el.getTagName())) {
                throw new ViperException("expected \"timelineoptions\" tag, got " + el.getTagName());
            }
            String str = StringUtils.emptyToNull(el.getAttribute("enabletimerange"));
            if (str != null) {
                this.enableTimeRange = Boolean.parseBoolean(str);
            }
            if ((str = StringUtils.emptyToNull(el.getAttribute("start"))) != null) {
                this.start = Integer.parseInt(str);
            }
            if ((str = StringUtils.emptyToNull(el.getAttribute("end"))) != null) {
                this.end = Integer.parseInt(str);
            }
            if ((str = StringUtils.emptyToNull(el.getAttribute("numsegmentsuvm"))) != null) {
                this.numSegmentsUVM = Integer.parseInt(str);
            }
            if ((str = StringUtils.emptyToNull(el.getAttribute("uvmisegmentenabled"))) != null) {
                this.uvmSegmentEnabled = Boolean.parseBoolean(str);
            }
            if ((str = StringUtils.emptyToNull(el.getAttribute("disabledtimelines"))) != null) {
                String[] array;
                TimelineKind[] kindValues = TimelineKind.values();
                String[] stringArray = array = str.split(",");
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    String strKind = stringArray[n2];
                    int value = Integer.parseInt(strKind);
                    TimelineKind kind = kindValues[value];
                    this.enableTimeline(kind, false);
                    ++n2;
                }
            }
        }

        public void write(Writer w) throws IOException {
            w.write("<timelineoptions");
            if (this.disabledTimelines != null) {
                String strKind = "";
                for (TimelineKind kind : this.disabledTimelines) {
                    if (!strKind.isEmpty()) {
                        strKind = String.valueOf(strKind) + ",";
                    }
                    strKind = String.valueOf(strKind) + kind.ordinal();
                }
                w.write(" disabledtimelines=\"" + strKind + "\"");
            }
            w.write(" enabletimerange=\"" + this.enableTimeRange + "\"");
            w.write(" start=\"" + this.start + "\"");
            w.write(" end=\"" + this.end + "\"");
            w.write(" numsegmentsuvm=\"" + this.numSegmentsUVM + "\"");
            w.write(" uvmisegmentenabled=\"" + this.uvmSegmentEnabled + "\"");
            w.write("/>\n");
        }

        public void enableTimeline(TimelineKind kind, boolean enable) {
            if (enable) {
                if (this.disabledTimelines != null && this.disabledTimelines.contains((Object)kind)) {
                    this.disabledTimelines.remove((Object)kind);
                }
            } else {
                if (this.disabledTimelines == null) {
                    this.disabledTimelines = new HashSet<TimelineKind>();
                }
                this.disabledTimelines.add(kind);
            }
        }
    }

    private class TimelineRefreshThread
    extends Thread {
        private final TimelineFactory factory;
        private final double startNS;
        private final double endNS;
        private final int width;

        public TimelineRefreshThread(TimelineFactory factory, double startNS, double endNS, int width) {
            super("Timeline Refresh");
            this.factory = factory;
            this.startNS = startNS;
            this.endNS = endNS;
            this.width = width;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
             *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
             *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    protected class TimelineState
    implements ISessionSerializable {
        private Vector<State> orderedTimelineState = new Vector();
        Map<String, State> stateMap = new HashMap<String, State>();

        protected TimelineState(Element timelinesElement) throws ViperException {
            if (!"timelinestate".equals(timelinesElement.getTagName())) {
                throw new ViperException("expected \"timelinestate\" tag, got " + timelinesElement.getTagName());
            }
            NodeList tlList = timelinesElement.getElementsByTagName("timeline");
            int i = 0;
            while (i < tlList.getLength()) {
                ContainerState containerState;
                Element tlElement = (Element)tlList.item(i);
                if (!"timeline".equals(tlElement.getTagName())) {
                    throw new ViperException("expected \"timeline\" tag, got " + tlElement.getTagName());
                }
                String pathName = StringUtils.emptyToNull(tlElement.getAttribute("pathname"));
                TimelineKind kind = TimelineKind.valueOf(tlElement.getAttribute("kind"));
                boolean filtered = Boolean.parseBoolean(tlElement.getAttribute("filtered"));
                try {
                    containerState = ContainerState.valueOf(tlElement.getAttribute("containerstate"));
                }
                catch (Exception exception) {
                    containerState = ContainerState.OPEN_ALL;
                }
                this.addState(pathName, kind, containerState, filtered);
                ++i;
            }
        }

        protected TimelineState() {
            Map<Timeline, String> pathnames = this.getTimelinePathnames();
            for (Timeline tl : Session.this.getTimelines()) {
                String pathname;
                Timeline parent;
                if (tl instanceof TimelineKernel && (parent = tl.getParent()) != null && parent instanceof TimelineKernel || (pathname = pathnames.get(tl)) == null) continue;
                this.addState(pathname, tl.getKind(), tl.getContainerState(), tl.isFiltered());
            }
        }

        protected State addState(String pathname, TimelineKind kind, ContainerState containerState, boolean filtered) {
            State newState = new State(this.orderedTimelineState.size(), containerState, filtered);
            this.orderedTimelineState.add(newState);
            this.stateMap.put(pathname, newState);
            return newState;
        }

        protected void apply() {
            State state;
            String pathname;
            Map<Timeline, String> timelinePathNameMap = this.getTimelinePathnames();
            for (Timeline tl : Session.this.getTimelines()) {
                pathname = timelinePathNameMap.get(tl);
                if (pathname == null || !this.stateMap.containsKey(pathname)) continue;
                state = this.stateMap.get(pathname);
                tl.setFiltered(state.filtered);
            }
            for (Timeline tl : Session.this.getTimelines()) {
                pathname = timelinePathNameMap.get(tl);
                if (pathname == null || !this.stateMap.containsKey(pathname)) continue;
                state = this.stateMap.get(pathname);
                tl.setContainerState(state.containerState);
            }
            TimelineOrderComparator orderComparator = new TimelineOrderComparator(timelinePathNameMap);
            for (Timeline topLevelTimeline : Session.this.topLevelTimelines) {
                this.orderChildren(topLevelTimeline, orderComparator);
            }
        }

        private void orderChildren(Timeline parent, Comparator<Timeline> orderComparator) {
            List<Timeline> children = parent.getChildren();
            if (children.size() > 1) {
                boolean canReorder = true;
                for (Timeline child : children) {
                    canReorder &= child.getKind().canReorder();
                }
                if (canReorder) {
                    Timeline[] childrenArray = children.toArray(new Timeline[0]);
                    Arrays.sort(childrenArray, orderComparator);
                    int idx = 0;
                    while (idx < childrenArray.length) {
                        Timeline child = childrenArray[idx];
                        parent.appendChild(child);
                        ++idx;
                    }
                }
            }
            for (Timeline child : children) {
                this.orderChildren(child, orderComparator);
            }
        }

        protected Map<Timeline, String> getTimelinePathnames() {
            HashMap<Timeline, String> pathMap = new HashMap<Timeline, String>();
            for (Timeline timeline : Session.this.topLevelTimelines) {
                this.getTimelinePathnames(timeline, (IPath)new Path(""), pathMap);
            }
            return pathMap;
        }

        private void getTimelinePathnames(Timeline timeline, IPath parentPath, Map<Timeline, String> pathMap) {
            IPath path = parentPath.append(timeline.getIdentifyingName());
            pathMap.put(timeline, path.toString());
            for (Timeline child : timeline.getChildren()) {
                this.getTimelinePathnames(child, path, pathMap);
            }
        }

        @Override
        public void write(Writer w) throws ViperException {
            Map<Timeline, String> pathnames = this.getTimelinePathnames();
            try {
                w.write("<timelinestate>\n");
                for (Timeline tl : Session.this.getTimelines()) {
                    String pathname;
                    Timeline parent;
                    if (tl instanceof TimelineKernel && (parent = tl.getParent()) != null && parent instanceof TimelineKernel || (pathname = pathnames.get(tl)) == null) continue;
                    w.write("<timeline pathname=\"" + XmlUtil.escapeString((String)pathname) + "\" kind=\"" + tl.getKind().name() + "\" containerstate=\"" + tl.getContainerState().name() + "\" filtered=\"" + tl.isFiltered() + "\"/>\n");
                }
                w.write("</timelinestate>\n");
            }
            catch (Exception e) {
                throw new ViperException(e);
            }
        }

        private class State {
            private int index;
            private ContainerState containerState;
            private boolean filtered;

            private State(int index, ContainerState containerState, boolean filtered) {
                this.index = index;
                this.containerState = containerState;
                this.filtered = filtered;
            }
        }

        class TimelineOrderComparator
        implements Comparator<Timeline> {
            private Map<Timeline, String> timelinePathNameMap;

            public TimelineOrderComparator(Map<Timeline, String> timelinePathNameMap) {
                this.timelinePathNameMap = timelinePathNameMap;
            }

            @Override
            public int compare(Timeline tl1, Timeline tl2) {
                String pn1 = this.timelinePathNameMap.get(tl1);
                String pn2 = this.timelinePathNameMap.get(tl2);
                if (pn1 == null && pn2 == null) {
                    return 0;
                }
                if (pn1 == null) {
                    return 1;
                }
                if (pn2 == null) {
                    return -1;
                }
                State state1 = TimelineState.this.stateMap.get(pn1);
                State state2 = TimelineState.this.stateMap.get(pn2);
                if (state1 == null && state2 == null) {
                    return 0;
                }
                if (state1 == null) {
                    return 1;
                }
                if (state2 == null) {
                    return -1;
                }
                return state1.index - state2.index;
            }
        }
    }
}

