/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SaveScopeResourcesHandler
implements IStatusHandler {
    IResource[] fSaves = null;

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Object[] objects;
        ILaunchConfiguration config = null;
        IProject[] projects = null;
        if (source instanceof Object[] && (objects = (Object[])source).length == 2) {
            config = (ILaunchConfiguration)objects[0];
            projects = (IProject[])objects[1];
        }
        if (config != null && DebugUITools.isPrivate(config)) {
            return Boolean.TRUE;
        }
        if (projects != null) {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String save = store.getString("org.eclipse.debug.ui.save_dirty_editors_before_launch");
            int ret = this.showSaveDialog(projects, !save.equals("never"), save.equals("prompt"));
            if (ret == 0) {
                this.doSave();
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        boolean cancel = DebugUIPlugin.preLaunchSave();
        return cancel;
    }

    protected IResource[] getScopedDirtyResources(IProject[] projects) {
        HashSet<IResource> dirtyres = new HashSet<IResource>();
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int l = 0;
        while (l < windows.length) {
            IWorkbenchPage[] pages = windows[l].getPages();
            int i = 0;
            while (i < pages.length) {
                IEditorPart[] eparts = pages[i].getDirtyEditors();
                int j = 0;
                while (j < eparts.length) {
                    IResource resource = (IResource)eparts[j].getEditorInput().getAdapter(IResource.class);
                    if (resource != null) {
                        int k = 0;
                        while (k < projects.length) {
                            if (projects[k].equals((Object)resource.getProject())) {
                                dirtyres.add(resource);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        return dirtyres.toArray(new IResource[dirtyres.size()]);
    }

    protected void doSave() {
        if (this.fSaves != null) {
            IDE.saveAllEditors((IResource[])this.fSaves, (boolean)false);
        }
    }

    protected int showSaveDialog(IProject[] projects, boolean save, boolean prompt) {
        if (save) {
            Object[] resources = this.getScopedDirtyResources(projects);
            if (prompt && resources.length > 0) {
                ScopedResourcesSelectionDialog lsd = new ScopedResourcesSelectionDialog(DebugUIPlugin.getShell(), new AdaptableList((IAdaptable[])resources), (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchLabelProvider());
                lsd.setInitialSelections(resources);
                lsd.setTitle(LaunchConfigurationsMessages.SaveScopeResourcesHandler_3);
                if (lsd.open() == 1) {
                    return 1;
                }
                Object[] objs = lsd.getResult();
                this.fSaves = new IResource[objs.length];
                int i = 0;
                while (i < objs.length) {
                    this.fSaves[i] = (IResource)objs[i];
                    ++i;
                }
            } else {
                this.fSaves = resources;
            }
        }
        return 0;
    }

    class ScopedResourcesSelectionDialog
    extends AbstractDebugCheckboxSelectionDialog {
        private final String SETTINGS_ID = "org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG";
        Button fSavePref;
        Object fInput;
        IStructuredContentProvider fContentProvider;
        ILabelProvider fLabelProvider;

        public ScopedResourcesSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
            super(parentShell);
            this.SETTINGS_ID = "org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG";
            this.fInput = input;
            this.fContentProvider = contentProvider;
            this.fLabelProvider = labelProvider;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.setShowSelectAllButtons(true);
        }

        @Override
        protected IContentProvider getContentProvider() {
            return this.fContentProvider;
        }

        @Override
        protected IBaseLabelProvider getLabelProvider() {
            return this.fLabelProvider;
        }

        @Override
        protected String getDialogSettingsId() {
            return "org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG";
        }

        @Override
        protected String getHelpContextId() {
            return "org.eclipse.debug.ui.select_resources_to_save_dialog";
        }

        @Override
        protected Object getViewerInput() {
            return this.fInput;
        }

        @Override
        protected String getViewerLabel() {
            return LaunchConfigurationsMessages.SaveScopeResourcesHandler_2;
        }

        @Override
        protected void addCustomFooterControls(Composite parent) {
            super.addCustomFooterControls(parent);
            this.fSavePref = new Button(parent, 32);
            this.fSavePref.setText(LaunchConfigurationsMessages.SaveScopeResourcesHandler_1);
            this.fSavePref.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ScopedResourcesSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(ScopedResourcesSelectionDialog.this.fSavePref.getSelection());
                }
            });
        }

        @Override
        protected void okPressed() {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String val = this.fSavePref.getSelection() ? "always" : "prompt";
            store.setValue("org.eclipse.debug.ui.save_dirty_editors_before_launch", val);
            super.okPressed();
        }

        @Override
        protected void addViewerListeners(StructuredViewer viewer) {
        }

        @Override
        protected boolean isValid() {
            return true;
        }
    }
}

